/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.swt.custom;

import java.util.Arrays;
import java.util.Map;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.FormWidgetFactory;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.IPropertyList;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.Tab;
import org.eclipse.birt.report.designer.internal.ui.util.UIHelper;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AccordionPropertyList
extends Canvas
implements IPropertyList {
    public static final Image ICON_COLLAPSE = UIHelper.getImage(ReportPlugin.getDefault().getBundle(), "icons/obj16/collapse.png");
    public static final Image ICON_EXPAND = UIHelper.getImage(ReportPlugin.getDefault().getBundle(), "icons/obj16/expand.png");
    private static final ListElement[] ELEMENTS_EMPTY = new ListElement[0];
    protected static final int NONE = -1;
    protected static final int INDENT = 7;
    private boolean focus = false;
    private ListElement[] elements;
    private int selectedElementIndex = -1;
    private int widestLabelIndex = -1;
    private int tabsThatFitInComposite = -1;
    private Color widgetForeground;
    private Color widgetBackground;
    private Color widgetNormalShadow;
    private Color listBackground;
    private Color hoverGradientStart;
    private Color hoverGradientEnd;
    private Color defaultGradientStart;
    private Color defaultGradientEnd;
    private Color indentedDefaultBackground;
    private Color indentedHoverBackground;
    private GC textGc;
    private FormToolkit factory = FormWidgetFactory.getInstance();
    private Map elementMap = null;

    public AccordionPropertyList(Composite parent) {
        super(parent, 0);
        this.removeAll();
        this.setLayout((Layout)new FormLayout());
        this.initColours();
        this.initAccessible();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                AccordionPropertyList.this.focus = true;
                int i = AccordionPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    AccordionPropertyList.this.elements[i].redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                AccordionPropertyList.this.focus = false;
                int i = AccordionPropertyList.this.getSelectionIndex();
                if (i >= 0) {
                    AccordionPropertyList.this.elements[i].redraw();
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){});
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                AccordionPropertyList.this.computeTopAndBottomTab();
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 32 || e.detail == 64) {
                    int nMax = AccordionPropertyList.this.elements.length - 1;
                    int nCurrent = AccordionPropertyList.this.getSelectionIndex();
                    if (e.detail == 32) {
                        --nCurrent;
                        nCurrent = Math.max(0, nCurrent);
                    } else if (e.detail == 64) {
                        ++nCurrent;
                        nCurrent = Math.min(nCurrent, nMax);
                    }
                    AccordionPropertyList.this.select(nCurrent, true);
                    AccordionPropertyList.this.computeTopAndBottomTab();
                    AccordionPropertyList.this.redraw();
                } else {
                    e.doit = true;
                }
            }
        });
    }

    protected void computeTabsThatFitInComposite() {
        this.tabsThatFitInComposite = (this.getSize().y - 22) / this.getTabHeight();
        if (this.tabsThatFitInComposite <= 0) {
            this.tabsThatFitInComposite = 1;
        }
    }

    public Object getElementAt(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        return null;
    }

    @Override
    public int getSelectionIndex() {
        return this.selectedElementIndex;
    }

    @Override
    public String getSelectionKey() {
        return this.elementMap.keySet().toArray()[this.selectedElementIndex].toString();
    }

    public void removeAll() {
        if (this.elements != null) {
            int i = 0;
            while (i < this.elements.length) {
                this.elements[i].dispose();
                ++i;
            }
        }
        this.elements = ELEMENTS_EMPTY;
        this.selectedElementIndex = -1;
        this.widestLabelIndex = -1;
    }

    @Override
    public void setElements(Map children) {
        this.elementMap = children;
        if (this.elements != ELEMENTS_EMPTY) {
            this.removeAll();
        }
        this.elements = new ListElement[children.size()];
        if (children.size() == 0) {
            this.widestLabelIndex = -1;
        } else {
            this.widestLabelIndex = 0;
            int i = 0;
            while (i < children.size()) {
                this.elements[i] = new ListElement((Composite)this, (Tab)children.get(children.keySet().toArray()[i]), i);
                this.elements[i].setVisible(false);
                this.elements[i].setLayoutData(null);
                if (i != this.widestLabelIndex) {
                    String label = ((Tab)children.get(children.keySet().toArray()[i])).getText();
                    if (this.getTextDimension((String)label).x > this.getTextDimension((String)((Tab)children.get((Object)children.keySet().toArray()[this.widestLabelIndex])).getText()).x) {
                        this.widestLabelIndex = i;
                    }
                }
                Composite container = new Composite((Composite)this, 0);
                container.setVisible(false);
                container.setLayoutData(null);
                this.elements[i].setData(container);
                ++i;
            }
        }
        this.computeTopAndBottomTab();
    }

    public void select(int index, boolean reveal) {
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                this.resetSelectedItem(lastSelected);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                    this.resetSelectedItem(this.getSelectionIndex() + 1);
                }
            }
            FormData formData = new FormData();
            formData.height = 0;
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.elements[index], 0);
            Composite container = (Composite)this.elements[index].getData();
            container.setLayoutData((Object)formData);
            container.setVisible(true);
            formData = new FormData();
            formData.height = this.getTabHeight();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)container, 0);
            if (index + 1 < this.elements.length) {
                this.elements[index + 1].setLayoutData(formData);
            }
            container.getParent().layout();
        }
        this.notifyListeners(13, new Event());
    }

    private void resetSelectedItem(int index) {
        Composite container = (Composite)this.elements[index].getData();
        container.setLayoutData(null);
        container.setVisible(false);
        FormData formData = new FormData();
        formData.height = this.getTabHeight();
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.top = new FormAttachment((Control)this.elements[index], 0);
        if (index + 1 < this.elements.length) {
            this.elements[index + 1].setLayoutData(formData);
        }
    }

    @Override
    public void setSelection(String key, int index) {
        if (this.elementMap.containsKey(key)) {
            index = Arrays.asList(this.elementMap.keySet().toArray()).indexOf(key);
        }
        if (this.getSelectionIndex() == index) {
            return;
        }
        if (index >= 0 && index < this.elements.length) {
            int lastSelected = this.getSelectionIndex();
            this.elements[index].setSelected(true);
            this.selectedElementIndex = index;
            if (lastSelected != -1) {
                this.elements[lastSelected].setSelected(false);
                this.resetSelectedItem(lastSelected);
                if (this.getSelectionIndex() != this.elements.length - 1) {
                    this.elements[this.getSelectionIndex() + 1].setSelected(false);
                    this.resetSelectedItem(this.getSelectionIndex() + 1);
                }
            }
            FormData formData = new FormData();
            formData.height = 0;
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)this.elements[index], 0);
            Composite container = (Composite)this.elements[index].getData();
            container.setLayoutData((Object)formData);
            container.setVisible(true);
            formData = new FormData();
            formData.height = this.getTabHeight();
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            formData.top = new FormAttachment((Control)container, 0);
            if (index + 1 < this.elements.length) {
                this.elements[index + 1].setLayoutData(formData);
            }
            container.getParent().layout();
        }
    }

    public void deselectAll() {
        if (this.getSelectionIndex() != -1) {
            this.elements[this.getSelectionIndex()].setSelected(false);
            this.selectedElementIndex = -1;
        }
    }

    private int getIndex(ListElement element) {
        return element.index;
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        Point result = super.computeSize(hHint, wHint, changed);
        if (this.widestLabelIndex == -1) {
            String properties_not_available = Messages.getString((String)"TabbedPropertyList.properties.not.available");
            result.x = this.getTextDimension((String)properties_not_available).x + 7;
        } else {
            int width = this.getTextDimension((String)this.elements[this.widestLabelIndex].getText()).x;
            result.x = width + 32;
            result.x = result.x >= 125 ? result.x : 125;
        }
        return result;
    }

    private Point getTextDimension(String text) {
        if (this.textGc == null || this.textGc.isDisposed()) {
            this.textGc = new GC((Drawable)this);
        }
        this.textGc.setFont(this.getFont());
        Point point = this.textGc.textExtent(text);
        ++point.x;
        return point;
    }

    private void initColours() {
        this.listBackground = Display.getCurrent().getSystemColor(25);
        this.widgetBackground = Display.getCurrent().getSystemColor(22);
        this.widgetForeground = Display.getCurrent().getSystemColor(21);
        this.widgetNormalShadow = Display.getCurrent().getSystemColor(18);
        RGB white = Display.getCurrent().getSystemColor(1).getRGB();
        this.defaultGradientStart = this.factory.getColors().createColor("TabbedPropertyList.defaultTabGradientStart", FormColors.blend((RGB)ColorConstants.button.getRGB(), (RGB)ColorConstants.listBackground.getRGB(), (int)85));
        this.defaultGradientEnd = this.factory.getColors().createColor("TabbedPropertyList.defaultTabGradientEnd", FormColors.blend((RGB)ColorConstants.button.getRGB(), (RGB)ColorConstants.buttonDarker.getRGB(), (int)45));
        this.hoverGradientStart = this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientStart", FormColors.blend((RGB)white, (RGB)this.widgetBackground.getRGB(), (int)20));
        this.hoverGradientEnd = this.factory.getColors().createColor("TabbedPropertyList.hoverBackgroundGradientEnd", FormColors.blend((RGB)this.widgetNormalShadow.getRGB(), (RGB)this.widgetBackground.getRGB(), (int)10));
        this.indentedDefaultBackground = this.factory.getColors().createColor("TabbedPropertyList.indentedDefaultBackground", FormColors.blend((RGB)white, (RGB)this.widgetBackground.getRGB(), (int)10));
        this.indentedHoverBackground = this.factory.getColors().createColor("TabbedPropertyList.indentedHoverBackground", FormColors.blend((RGB)white, (RGB)this.widgetBackground.getRGB(), (int)75));
    }

    public void dispose() {
        if (this.textGc != null && !this.textGc.isDisposed()) {
            this.textGc.dispose();
            this.textGc = null;
        }
        super.dispose();
    }

    private int getTabHeight() {
        int tabHeight = this.getTextDimension((String)"").y + 7;
        if (this.tabsThatFitInComposite == 1) {
            int ret = this.getBounds().height - 20;
            return ret > tabHeight ? tabHeight : (ret < 5 ? 5 : ret);
        }
        return tabHeight;
    }

    public void computeTopAndBottomTab() {
        this.computeTabsThatFitInComposite();
        this.layoutTabs();
    }

    private void layoutTabs() {
        if (this.tabsThatFitInComposite != -1 && this.elements.length > 0) {
            int i = 0;
            while (i < this.elements.length) {
                FormData formData = new FormData();
                formData.height = this.getTabHeight();
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                formData.top = i == 0 ? new FormAttachment(0, 0) : (i == this.getSelectionIndex() + 1 ? new FormAttachment((Control)((Composite)this.elements[i - 1].getData()), 0) : new FormAttachment((Control)this.elements[i - 1], 0));
                this.elements[i].setLayoutData(formData);
                this.elements[i].setVisible(true);
                if (i == this.getSelectionIndex()) {
                    formData = new FormData();
                    formData.height = 0;
                    formData.left = new FormAttachment(0, 0);
                    formData.right = new FormAttachment(100, 0);
                    formData.top = new FormAttachment((Control)this.elements[i], 0);
                    container = (Composite)this.elements[i].getData();
                    int height = container.computeSize((int)-1, (int)-1).y;
                    if (formData.height < height) {
                        formData.height = height;
                    }
                    container.setLayoutData((Object)formData);
                    container.setVisible(true);
                } else {
                    container = (Composite)this.elements[i].getData();
                    container.setLayoutData(null);
                    container.setVisible(false);
                }
                ++i;
            }
        }
        Composite grandparent = this.getParent().getParent();
        grandparent.layout(true);
        this.layout(true);
    }

    private void initAccessible() {
        final Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (AccordionPropertyList.this.getSelectionIndex() != -1) {
                    e.result = AccordionPropertyList.this.elements[AccordionPropertyList.this.getSelectionIndex()].getText();
                }
            }

            public void getHelp(AccessibleEvent e) {
                if (AccordionPropertyList.this.getSelectionIndex() != -1) {
                    e.result = AccordionPropertyList.this.elements[AccordionPropertyList.this.getSelectionIndex()].getText();
                }
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = AccordionPropertyList.this.toControl(new Point(e.x, e.y));
                e.childID = AccordionPropertyList.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                if (AccordionPropertyList.this.getSelectionIndex() != -1) {
                    Rectangle location = AccordionPropertyList.this.elements[AccordionPropertyList.this.getSelectionIndex()].getBounds();
                    Point pt = AccordionPropertyList.this.toDisplay(new Point(location.x, location.y));
                    e.x = pt.x;
                    e.y = pt.y;
                    e.width = location.width;
                    e.height = location.height;
                }
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 37;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0x300006;
            }
        });
        this.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (AccordionPropertyList.this.isFocusControl()) {
                    accessible.setFocus(-1);
                }
            }
        });
        this.addListener(15, new Listener(){

            public void handleEvent(Event event) {
                accessible.setFocus(-1);
            }
        });
    }

    @Override
    public Control getControl() {
        return this;
    }

    @Override
    public Control getItem(int index) {
        if (index >= 0 && index < this.elements.length) {
            return this.elements[index];
        }
        return null;
    }

    public class ListElement
    extends Canvas {
        private Tab tab;
        private int index;
        private boolean selected;
        private boolean hover;

        public ListElement(Composite parent, Tab tab, int index) {
            super(parent, 524288);
            this.tab = tab;
            this.hover = false;
            this.selected = false;
            this.index = index;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    ListElement.this.paint(e);
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Composite tabbedPropertyComposite;
                    Control[] children;
                    if (!ListElement.this.selected) {
                        AccordionPropertyList.this.select(AccordionPropertyList.this.getIndex(ListElement.this), true);
                        AccordionPropertyList.this.computeTopAndBottomTab();
                    }
                    if ((children = (tabbedPropertyComposite = ListElement.this.getParent()).getParent().getTabList()) != null && children.length > 0) {
                        int i = 0;
                        while (i < children.length) {
                            if (children[i] != AccordionPropertyList.this && children[i].setFocus()) {
                                ((ListElement)ListElement.this).AccordionPropertyList.this.focus = false;
                                return;
                            }
                            ++i;
                        }
                    }
                }
            });
            this.addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (!ListElement.this.hover) {
                        ListElement.this.hover = true;
                        ListElement.this.redraw();
                    }
                }
            });
            this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseExit(MouseEvent e) {
                    ListElement.this.hover = false;
                    ListElement.this.redraw();
                }
            });
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.redraw();
        }

        private void paint(PaintEvent e) {
            Rectangle bounds = this.getBounds();
            e.gc.setForeground(AccordionPropertyList.this.widgetNormalShadow);
            e.gc.drawLine(0, 0, bounds.width - 1, 0);
            e.gc.setForeground(AccordionPropertyList.this.listBackground);
            e.gc.drawLine(0, 1, bounds.width - 1, 1);
            if (this.hover && this.tab.isIndented()) {
                e.gc.setBackground(AccordionPropertyList.this.indentedHoverBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            } else if (this.hover) {
                e.gc.setForeground(AccordionPropertyList.this.hoverGradientStart);
                e.gc.setBackground(AccordionPropertyList.this.hoverGradientEnd);
                e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
            } else if (this.tab.isIndented()) {
                e.gc.setBackground(AccordionPropertyList.this.indentedDefaultBackground);
                e.gc.fillRectangle(0, 2, bounds.width - 1, bounds.height - 1);
            } else {
                e.gc.setForeground(AccordionPropertyList.this.defaultGradientStart);
                e.gc.setBackground(AccordionPropertyList.this.defaultGradientEnd);
                e.gc.fillGradientRectangle(0, 2, bounds.width - 1, bounds.height - 1, true);
            }
            e.gc.setForeground(AccordionPropertyList.this.widgetNormalShadow);
            e.gc.drawLine(bounds.width - 1, 1, bounds.width - 1, bounds.height + 1);
            e.gc.drawLine(0, 1, 0, bounds.height + 1);
            int textIndent = 7;
            FontMetrics fm = e.gc.getFontMetrics();
            int height = fm.getHeight();
            int textMiddle = (bounds.height - height) / 2;
            textIndent = this.tab.isIndented() ? (textIndent += 7) : (textIndent -= 3);
            if (this.selected) {
                e.gc.drawImage(ICON_EXPAND, textIndent, textMiddle - 1);
            } else {
                e.gc.drawImage(ICON_COLLAPSE, textIndent, textMiddle - 1);
            }
            textIndent = textIndent + 16 + 5;
            e.gc.setForeground(AccordionPropertyList.this.widgetForeground);
            if (this.selected) {
                e.gc.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            }
            e.gc.drawText(this.tab.getText(), textIndent, textMiddle, true);
            if (((AccordionPropertyList)this.getParent()).focus && this.selected && AccordionPropertyList.this.focus) {
                Point point = e.gc.textExtent(this.tab.getText());
                e.gc.drawLine(textIndent, bounds.height - 4, textIndent + point.x, bounds.height - 4);
            }
            if (!this.hover && this != AccordionPropertyList.this.elements[AccordionPropertyList.this.getSelectionIndex()]) {
                e.gc.setForeground(AccordionPropertyList.this.listBackground);
                e.gc.drawLine(1, bounds.height - 1, bounds.width - 2, bounds.height - 1);
            }
            if (this == AccordionPropertyList.this.elements[AccordionPropertyList.this.getSelectionIndex()] || this == AccordionPropertyList.this.elements[AccordionPropertyList.this.elements.length - 1]) {
                e.gc.setForeground(AccordionPropertyList.this.widgetNormalShadow);
                e.gc.drawLine(0, bounds.height - 1, bounds.width, bounds.height - 1);
            }
        }

        public String getText() {
            return this.tab.getText();
        }

        public String toString() {
            return this.tab.getText();
        }
    }
}

