/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.designer.core.model.DesignElementHandleAdapter;
import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportDesignHandleAdapter;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.core.model.schematic.HandleAdapterFactory;
import org.eclipse.birt.report.designer.internal.ui.editors.parts.DeferredGraphicalViewer;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.border.BaseBorder;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editparts.MultipleEditPart;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.editpolicies.ReportElementResizablePolicy;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.IReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.ReportElementFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.figures.TableFigure;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.AbstractGuideHandle;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.handles.IGuideFeedBackHost;
import org.eclipse.birt.report.designer.internal.ui.editors.schematic.tools.ReportElementDragTracker;
import org.eclipse.birt.report.designer.internal.ui.layout.ReportFlowLayout;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.util.ColorManager;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.engine.css.engine.value.css.CSSValueConstants;
import org.eclipse.birt.report.engine.util.SvgFile;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.eclipse.birt.report.model.api.util.DimensionUtil;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public abstract class ReportElementEditPart
extends AbstractGraphicalEditPart
implements IModelAdapterHelper,
IGuideFeedBackHost {
    private static final int DELAY_TIME = 1600;
    protected DesignElementHandleAdapter peer;
    private AbstractGuideHandle guideHandle = null;
    private boolean isEdited = false;
    protected Logger logger = Logger.getLogger(ReportElementEditPart.class.getName());
    private boolean isDirty = true;

    public ReportElementEditPart(Object model) {
        if (Policy.TRACING_EDITPART_CREATE) {
            String[] result = this.getClass().getName().split("\\.");
            System.out.println(result[result.length - 1] + " >> Created for " + String.valueOf(model));
        }
        this.setModel(model);
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.peer = this.creatDesignElementHandleAdapter();
    }

    public DesignElementHandleAdapter creatDesignElementHandleAdapter() {
        HandleAdapterFactory.getInstance().remove(this.getModel());
        return HandleAdapterFactory.getInstance().getDesignElementHandleAdapter(this.getModel(), (IModelAdapterHelper)this);
    }

    public void performRequest(Request request) {
        if (request.getExtendedData().get("newObject from library") != null) {
            return;
        }
        if ("open".equals(request.getType()) || "create element".equals(request.getType())) {
            if (this.isEdited()) {
                return;
            }
            this.setEdited(true);
            try {
                this.performDirectEdit();
            }
            catch (RuntimeException e) {
                this.logger.log(Level.SEVERE, e.getMessage(), e);
            }
            this.setEdited(false);
        }
    }

    public void performDirectEdit() {
    }

    protected boolean isEdited() {
        return this.isEdited;
    }

    protected void setEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }

    protected AbstractGuideHandle createGuideHandle() {
        EditPart part = this.getParent();
        if (part instanceof ReportElementEditPart) {
            return ((ReportElementEditPart)part).getGuideHandle();
        }
        return null;
    }

    protected AbstractGuideHandle getGuideHandle() {
        if (this.guideHandle == null) {
            this.guideHandle = this.interCreateGuideHandle();
        }
        return this.guideHandle;
    }

    private AbstractGuideHandle interCreateGuideHandle() {
        if (this.getParent() instanceof MultipleEditPart) {
            return ((MultipleEditPart)this.getParent()).createGuideHandle();
        }
        return this.createGuideHandle();
    }

    @Override
    public void addGuideFeedBack() {
        if (this.guideHandle == null) {
            this.guideHandle = this.interCreateGuideHandle();
        }
        if (this.guideHandle != null && this.guideHandle != this.findHandle()) {
            this.clearGuideHandle();
            this.getHandleLayer().add((IFigure)this.guideHandle);
            this.guideHandle.invalidate();
            this.guideHandle.setCanDeleteGuide(true);
        } else if (this.guideHandle != null && this.guideHandle == this.findHandle()) {
            this.guideHandle.setCanDeleteGuide(false);
        } else if (this.guideHandle != null) {
            this.guideHandle.setCanDeleteGuide(true);
        }
    }

    private AbstractGuideHandle findHandle() {
        IFigure layer = this.getHandleLayer();
        List list = layer.getChildren();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof AbstractGuideHandle) {
                return (AbstractGuideHandle)((Object)obj);
            }
            ++i;
        }
        return null;
    }

    protected void clearGuideHandle() {
        IFigure layer = this.getHandleLayer();
        List list = layer.getChildren();
        ArrayList<IFigure> temp = new ArrayList<IFigure>();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Object obj = list.get(i);
            if (obj instanceof AbstractGuideHandle) {
                temp.add((IFigure)obj);
            }
            ++i;
        }
        size = temp.size();
        i = 0;
        while (i < size) {
            IFigure figure = (IFigure)temp.get(i);
            layer.remove(figure);
            ++i;
        }
    }

    protected void removeGuideFeedBack() {
        if (this.guideHandle != null && this.guideHandle.getParent() == this.getHandleLayer()) {
            this.getHandleLayer().remove((IFigure)this.guideHandle);
        } else if (this.getParent() instanceof ReportElementEditPart) {
            ((ReportElementEditPart)this.getParent()).removeGuideFeedBack();
        }
        this.guideHandle = null;
    }

    @Override
    public void delayRemoveGuideFeedBack() {
        if (this.guideHandle != null) {
            this.guideHandle.setCanDeleteGuide(true);
        }
        Display.getCurrent().timerExec(1600, new Runnable(){

            @Override
            public void run() {
                if (ReportElementEditPart.this.guideHandle != null && ReportElementEditPart.this.guideHandle.isCanDeleteGuide()) {
                    ReportElementEditPart.this.removeGuideFeedBack();
                }
            }
        });
    }

    private IFigure getHandleLayer() {
        super.getLayer((Object)"Handle Layer");
        LayerManager manager = (LayerManager)this.getViewer().getEditPartRegistry().get(LayerManager.ID);
        return manager.getLayer((Object)"Handle Layer");
    }

    public void activate() {
        if (this.isActive()) {
            return;
        }
        super.activate();
        this.refreshPageClip();
        this.getFigure().addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

            public void mouseEntered(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }

            public void mouseExited(MouseEvent me) {
                ReportElementEditPart.this.delayRemoveGuideFeedBack();
            }

            public void mouseHover(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }

            public void mouseMoved(MouseEvent me) {
                ReportElementEditPart.this.addGuideFeedBack();
            }
        });
        this.getFigure().setFocusTraversable(true);
        this.updateLayoutPreference();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!(ReportElementEditPart.this.getModel() instanceof DesignElementHandle) || ReportElementEditPart.this.isDelete()) {
                    return;
                }
                EditPart parent = ReportElementEditPart.this.getParent();
                while (parent != null) {
                    if (parent instanceof RootEditPart) break;
                    parent = parent.getParent();
                }
                if (parent == null) {
                    return;
                }
                if (((DeferredGraphicalViewer)ReportElementEditPart.this.getViewer()).getFigureCanvas() == null) {
                    return;
                }
                DesignElementHandle handle = (DesignElementHandle)ReportElementEditPart.this.getModel();
                ReportElementEditPart part = ReportElementEditPart.this;
                while (part != null && !(part instanceof RootEditPart)) {
                    part = part.getParent();
                }
                if (ReportElementEditPart.this.getModelAdapter() == null || part == null) {
                    return;
                }
                Object[] backGroundPosition = ReportElementEditPart.this.getBackgroundPosition(handle);
                Object xPosition = backGroundPosition[0];
                Object yPosition = backGroundPosition[1];
                boolean needRefresh = false;
                if (xPosition instanceof DimensionValue) {
                    needRefresh = true;
                }
                if (yPosition instanceof DimensionValue) {
                    needRefresh = true;
                }
                if (ReportElementEditPart.this.isPercentageValue(handle.getProperty("marginLeft"))) {
                    needRefresh = true;
                }
                if (ReportElementEditPart.this.isPercentageValue(handle.getProperty("marginRight"))) {
                    needRefresh = true;
                }
                if (needRefresh) {
                    ReportElementEditPart.this.refreshVisuals();
                }
            }
        });
    }

    private boolean isPercentageValue(Object object) {
        DimensionValue dimension;
        String units;
        return object instanceof DimensionValue && "%".equals(units = (dimension = (DimensionValue)object).getUnits());
    }

    public void deactivate() {
        if (!this.isActive()) {
            return;
        }
        this.removeGuideFeedBack();
        super.deactivate();
        HandleAdapterFactory.getInstance().remove(this.getModel(), (IModelAdapterHelper)this);
    }

    protected abstract void createEditPolicies();

    public DragTracker getDragTracker(Request req) {
        ReportElementDragTracker track = new ReportElementDragTracker((EditPart)this);
        return track;
    }

    public Rectangle getBounds() {
        return this.getReportElementHandleAdapt().getbounds();
    }

    public void setBounds(Rectangle r) {
        try {
            this.getReportElementHandleAdapt().setBounds(r);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Point getLocation() {
        return this.getReportElementHandleAdapt().getLocation();
    }

    public void setLocation(Point p) {
        try {
            this.getReportElementHandleAdapt().setLocation(p);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    public Dimension getSize() {
        return this.getReportElementHandleAdapt().getSize();
    }

    public void setSize(Dimension d) {
        try {
            this.getReportElementHandleAdapt().setSize(d);
        }
        catch (SemanticException e) {
            ExceptionHandler.handle(e);
        }
    }

    protected Font getFont(ReportItemHandle handle) {
        return UIUtil.getFont(handle);
    }

    protected Font getFont() {
        return this.getFont((ReportItemHandle)this.getModel());
    }

    public String getDisplayLabel() {
        return null;
    }

    public final void refreshVisuals() {
        super.refreshVisuals();
        this.refreshFigure();
        this.refreshReportChildren(this);
        this.getFigure().repaint();
    }

    public void refreshChildren() {
        super.refreshChildren();
    }

    public void refreshReportChildren(ReportElementEditPart parent) {
        List list = parent.getChildren();
        int i = 0;
        while (i < list.size()) {
            Object part = list.get(i);
            if (part instanceof ReportElementEditPart && !((ReportElementEditPart)part).isDelete()) {
                ((ReportElementEditPart)part).refreshFigure();
                this.refreshReportChildren((ReportElementEditPart)part);
            }
            ++i;
        }
    }

    public abstract void refreshFigure();

    protected void refreshMargin() {
        if (this.getFigure() instanceof IReportElementFigure) {
            if (this.isFixLayout() && this.getFigure().getParent() != null) {
                ((IReportElementFigure)this.getFigure()).setMargin(this.getModelAdapter().getMargin(null, this.getFigure().getParent().getClientArea().getSize()));
            } else {
                ((IReportElementFigure)this.getFigure()).setMargin(this.getModelAdapter().getMargin(null));
            }
        }
    }

    protected void refreshBackground(DesignElementHandle handle) {
        this.refreshBackgroundColor(handle);
        this.refreshBackgroundImage(handle);
    }

    protected void refreshBackgroundColor(DesignElementHandle handle) {
        Object obj = handle.getProperty("backgroundColor");
        if (handle instanceof MasterPageHandle) {
            this.getFigure().setOpaque(true);
        } else {
            this.getFigure().setOpaque(false);
        }
        if (obj != null) {
            int color = 0xFFFFFF;
            color = obj instanceof String ? ColorUtil.parseColor((String)((String)obj)) : (Integer)obj;
            this.getFigure().setBackgroundColor(ColorManager.getColor((int)color));
            this.getFigure().setOpaque(true);
        }
    }

    protected Image getBackImage(DesignElementHandle handle) {
        String backGroundImage = this.getBackgroundImage(handle);
        if (backGroundImage == null) {
            return null;
        }
        Image image = null;
        String imageSourceType = "embed";
        Object obj = handle.getProperty("backgroundImageType");
        if (obj instanceof String) {
            imageSourceType = obj.toString();
        }
        try {
            if (imageSourceType.equalsIgnoreCase(CSSValueConstants.URL_VALUE.getCssText())) {
                image = ImageManager.getInstance().getImage(this.getModelAdapter().getModuleHandle(), backGroundImage);
            }
            if (imageSourceType.equalsIgnoreCase(CSSValueConstants.EMBED_VALUE.getCssText()) || image == null) {
                image = ImageManager.getInstance().getEmbeddedImage(this.getModelAdapter().getModuleHandle(), backGroundImage);
            }
        }
        catch (SWTException e) {
            image = null;
        }
        return image;
    }

    protected void refreshBackgroundImage(DesignElementHandle handle) {
        IReportElementFigure figure = (IReportElementFigure)this.getFigure();
        String backGroundImage = this.getBackgroundImage(handle);
        if (backGroundImage == null) {
            figure.setImage(null);
        }
        Object obj = handle.getProperty("backgroundImageType");
        String imageSourceType = CSSValueConstants.URL_VALUE.getCssText();
        if (obj instanceof String) {
            imageSourceType = obj.toString();
        }
        Image image = null;
        try {
            if (imageSourceType.equalsIgnoreCase(CSSValueConstants.URL_VALUE.getCssText())) {
                image = ImageManager.getInstance().getImage(this.getModelAdapter().getModuleHandle(), backGroundImage);
            }
            if (imageSourceType.equalsIgnoreCase(CSSValueConstants.EMBED_VALUE.getCssText()) || image == null) {
                image = ImageManager.getInstance().getEmbeddedImage(this.getModelAdapter().getModuleHandle(), backGroundImage);
            }
        }
        catch (SWTException e) {
            image = null;
        }
        if (image == null) {
            figure.setImage(null);
            return;
        }
        int dpi = this.getImageDPI(backGroundImage);
        if (figure instanceof ReportElementFigure) {
            ((ReportElementFigure)figure).setBackgroundImageDPI(dpi);
        } else if (figure instanceof TableFigure) {
            ((TableFigure)figure).setBackgroundImageDPI(dpi);
        }
        int pxBackgroundHeight = 0;
        int pxBackgroundWidth = 0;
        double percentageHeight = 1.0;
        double percentageWidth = 1.0;
        String propertyValue = handle.getStringProperty("backgroundSizeHeight");
        if (!(propertyValue == null || "auto".equals(propertyValue) || "cover".equals(propertyValue) || "contain".equals(propertyValue))) {
            if (propertyValue.endsWith("%")) {
                percentageHeight = Double.parseDouble(propertyValue.replace("%", "")) / 100.0;
            } else {
                DimensionValue propertyBackgroundHeight = (DimensionValue)handle.getProperty("backgroundSizeHeight");
                if (propertyBackgroundHeight.getUnits().equals("px")) {
                    pxBackgroundHeight = (int)propertyBackgroundHeight.getMeasure();
                } else {
                    DimensionValue backgroundHeight = DimensionUtil.convertTo((double)propertyBackgroundHeight.getMeasure(), (String)propertyBackgroundHeight.getUnits(), (String)"in");
                    pxBackgroundHeight = (int)MetricUtility.inchToPixel((double)backgroundHeight.getMeasure());
                }
            }
        }
        if (!((propertyValue = handle.getStringProperty("backgroundSizeWidth")) == null || "auto".equals(propertyValue) || "cover".equals(propertyValue) || "contain".equals(propertyValue))) {
            if (propertyValue.endsWith("%")) {
                percentageWidth = Double.parseDouble(propertyValue.replace("%", "")) / 100.0;
            } else {
                DimensionValue propertyBackgroundWidth = (DimensionValue)handle.getProperty("backgroundSizeWidth");
                if (propertyBackgroundWidth.getUnits().equals("px")) {
                    pxBackgroundWidth = (int)propertyBackgroundWidth.getMeasure();
                } else {
                    DimensionValue backgroundWidth = DimensionUtil.convertTo((double)propertyBackgroundWidth.getMeasure(), (String)propertyBackgroundWidth.getUnits(), (String)"in");
                    pxBackgroundWidth = (int)MetricUtility.inchToPixel((double)backgroundWidth.getMeasure());
                }
            }
        }
        figure.setImage(image, pxBackgroundHeight, pxBackgroundWidth, percentageHeight, percentageWidth);
        Object[] backGroundPosition = this.getBackgroundPosition(handle);
        int backGroundRepeat = this.getBackgroundRepeat(handle);
        figure.setRepeat(backGroundRepeat);
        Object xPosition = backGroundPosition[0];
        Object yPosition = backGroundPosition[1];
        Rectangle area = this.getFigure().getClientArea();
        org.eclipse.swt.graphics.Rectangle imageArea = image.getBounds();
        Point position = new Point(-1, -1);
        int alignment = 0;
        if (xPosition instanceof Integer) {
            position.x = (Integer)xPosition;
        } else if (xPosition instanceof DimensionValue) {
            int percentX = (int)((DimensionValue)xPosition).getMeasure();
            position.x = (area.width - imageArea.width) * percentX / 100;
        } else if (xPosition instanceof String) {
            alignment |= DesignElementHandleAdapter.getPosition((String)((String)xPosition));
        }
        if (yPosition instanceof Integer) {
            position.y = (Integer)yPosition;
        } else if (yPosition instanceof DimensionValue) {
            int percentY = (int)((DimensionValue)yPosition).getMeasure();
            position.y = (area.width - imageArea.width) * percentY / 100;
        } else if (yPosition instanceof String) {
            alignment |= DesignElementHandleAdapter.getPosition((String)((String)yPosition));
        }
        figure.setAlignment(alignment);
        figure.setPosition(position);
    }

    private int getImageDPI(String backGroundImage) {
        if (!(this.getModel() instanceof DesignElementHandle)) {
            return 0;
        }
        DesignElementHandle model = (DesignElementHandle)this.getModel();
        InputStream in = null;
        URL temp = null;
        try {
            temp = URIUtil.isValidResourcePath((String)backGroundImage) ? ImageManager.getInstance().generateURL(model.getModuleHandle(), URIUtil.getLocalPath((String)backGroundImage)) : ImageManager.getInstance().generateURL(model.getModuleHandle(), backGroundImage);
            if (temp != null) {
                in = temp.openStream();
            }
        }
        catch (IOException e) {
            in = null;
        }
        int dpi = 96;
        if (!SvgFile.isSvg((String)backGroundImage, (String)backGroundImage, (String)backGroundImage)) {
            dpi = UIUtil.getImageResolution(in)[0];
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    ExceptionHandler.handle(e);
                }
            }
        }
        return dpi;
    }

    public void markDirty(boolean bool) {
        this.isDirty = bool;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected DesignElementHandleAdapter getModelAdapter() {
        if (this.peer == null) {
            this.peer = HandleAdapterFactory.getInstance().getDesignElementHandleAdapter(this.getModel(), (IModelAdapterHelper)this);
        }
        return this.peer;
    }

    public Dimension getPreferredSize() {
        Dimension size = this.getFigure().getSize().getCopy();
        return size;
    }

    public Insets getInsets() {
        return new Insets(this.getFigure().getInsets());
    }

    protected ReportItemtHandleAdapter getReportElementHandleAdapt() {
        return (ReportItemtHandleAdapter)this.getModelAdapter();
    }

    protected void refreshPageClip() {
        Object obj;
        if (this.getFigure() instanceof ReportElementFigure && (obj = this.getViewer().getProperty("Layout Size")) instanceof Rectangle) {
            ((ReportElementFigure)this.getFigure()).setPageClip((Rectangle)obj);
        }
    }

    protected void updateBaseBorder(DesignElementHandle handle, BaseBorder border) {
        this.updateBottomBorder(handle, border);
        this.updateTopBorder(handle, border);
        this.updateLeftBorder(handle, border);
        this.updateRightBorder(handle, border);
        this.updateDiagonalBorder(handle, border);
        this.updateAntidiagonalBorder(handle, border);
    }

    protected void updateBottomBorder(DesignElementHandle handle, BaseBorder border) {
        border.bottomColor = handle.getPropertyHandle("borderBottomColor").getIntValue();
        border.bottomStyle = handle.getPropertyHandle("borderBottomStyle").getStringValue();
        border.bottomWidth = handle.getPropertyHandle("borderBottomWidth").getStringValue();
    }

    protected void updateTopBorder(DesignElementHandle handle, BaseBorder border) {
        border.topColor = handle.getPropertyHandle("borderTopColor").getIntValue();
        border.topStyle = handle.getPropertyHandle("borderTopStyle").getStringValue();
        border.topWidth = handle.getPropertyHandle("borderTopWidth").getStringValue();
    }

    protected void updateLeftBorder(DesignElementHandle handle, BaseBorder border) {
        border.leftColor = handle.getPropertyHandle("borderLeftColor").getIntValue();
        border.leftStyle = handle.getPropertyHandle("borderLeftStyle").getStringValue();
        border.leftWidth = handle.getPropertyHandle("borderLeftWidth").getStringValue();
    }

    protected void updateRightBorder(DesignElementHandle handle, BaseBorder border) {
        border.rightColor = handle.getPropertyHandle("borderRightColor").getIntValue();
        border.rightStyle = handle.getPropertyHandle("borderRightStyle").getStringValue();
        border.rightWidth = handle.getPropertyHandle("borderRightWidth").getStringValue();
    }

    protected void updateDiagonalBorder(DesignElementHandle handle, BaseBorder border) {
        border.diagonalNumber = 0;
        border.diagonalColor = 0;
        border.diagonalStyle = null;
        border.diagonalWidth = null;
        if (handle.getPropertyHandle("diagonalNumber") != null) {
            border.diagonalNumber = handle.getPropertyHandle("diagonalNumber").getIntValue();
        }
        if (border.diagonalNumber > 0) {
            if (handle.getPropertyHandle("diagonalColor") != null) {
                border.diagonalColor = handle.getPropertyHandle("diagonalColor").getIntValue();
            }
            if (handle.getPropertyHandle("diagonalStyle") != null) {
                border.diagonalStyle = handle.getPropertyHandle("diagonalStyle").getStringValue();
            }
            if (handle.getPropertyHandle("diagonalThickness") != null) {
                border.diagonalWidth = handle.getPropertyHandle("diagonalThickness").getStringValue();
            }
        }
    }

    protected void updateAntidiagonalBorder(DesignElementHandle handle, BaseBorder border) {
        border.antidiagonalNumber = 0;
        border.antidiagonalColor = 0;
        border.antidiagonalStyle = null;
        border.antidiagonalWidth = null;
        if (handle.getPropertyHandle("antidiagonalNumber") != null) {
            border.antidiagonalNumber = handle.getPropertyHandle("antidiagonalNumber").getIntValue();
        }
        if (border.antidiagonalNumber > 0) {
            if (handle.getPropertyHandle("antidiagonalColor") != null) {
                border.antidiagonalColor = handle.getPropertyHandle("antidiagonalColor").getIntValue();
            }
            if (handle.getPropertyHandle("antidiagonalStyle") != null) {
                border.antidiagonalStyle = handle.getPropertyHandle("antidiagonalStyle").getStringValue();
            }
            if (handle.getPropertyHandle("antidiagonalThickness") != null) {
                border.antidiagonalWidth = handle.getPropertyHandle("antidiagonalThickness").getStringValue();
            }
        }
    }

    protected void refreshBorder(DesignElementHandle handle, BaseBorder border) {
        this.updateBaseBorder(handle, border);
        this.getFigure().setBorder((Border)border);
        this.refreshPageClip();
    }

    protected Insets getMasterPageInsets(DesignElementHandle handle) {
        return ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPageInsets(handle);
    }

    protected Dimension getMasterPageSize(DesignElementHandle handle) {
        return ((ReportDesignHandleAdapter)this.getModelAdapter()).getMasterPageSize(handle);
    }

    protected int getForegroundColor(DesignElementHandle handle) {
        return this.getModelAdapter().getForegroundColor(handle);
    }

    protected int getBackgroundColor(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundColor(handle);
    }

    protected String getBackgroundImage(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundImage(handle);
    }

    protected Object[] getBackgroundPosition(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundPosition(handle);
    }

    protected int getBackgroundRepeat(DesignElementHandle handle) {
        return this.getModelAdapter().getBackgroundRepeat(handle);
    }

    protected int getBackgroundHeight(DesignElementHandle handle) {
        return 0;
    }

    protected boolean isFigureLeft(Request request) {
        if (!(request instanceof SelectionRequest)) {
            return true;
        }
        SelectionRequest selctionRequest = (SelectionRequest)request;
        Point p = selctionRequest.getLocation();
        this.getFigure().translateToRelative((Translatable)p);
        Point center = this.getFigure().getBounds().getCenter();
        return center.x >= p.x;
    }

    public boolean isDelete() {
        boolean bool = false;
        if (this.getModel() instanceof DesignElementHandle && !(this.getModel() instanceof ModuleHandle)) {
            bool = ((DesignElementHandle)this.getModel()).getContainer() == null || ((DesignElementHandle)this.getModel()).getRoot() == null;
        }
        return bool;
    }

    public void notifyModelChange() {
        if (this.getParent() != null && this.getParent() instanceof ReportElementEditPart) {
            ((ReportElementEditPart)this.getParent()).notifyModelChange();
        }
    }

    protected void contentChange(Map<?, ?> info) {
        this.markDirty(true);
        this.refresh();
    }

    protected void propertyChange(Map<?, ?> info) {
        this.refreshVisuals();
    }

    public boolean isinterest(Object model) {
        return this.getModel().equals(model);
    }

    public boolean isinterestSelection(Object object) {
        return false;
    }

    public EditPolicy getResizePolice(EditPolicy parentPolice) {
        ReportElementResizablePolicy policy = new ReportElementResizablePolicy();
        policy.setResizeDirections(20);
        return policy;
    }

    public void removeChild(EditPart child) {
        super.removeChild(child);
    }

    public String getGuideLabel() {
        return "";
    }

    protected String getTextDirection() {
        DesignElementHandle handle = (DesignElementHandle)this.getModel();
        return this.getTextDirection(handle);
    }

    protected String getTextDirection(DesignElementHandle handle) {
        return handle.isDirectionRTL() ? "rtl" : "ltr";
    }

    protected void updateLayoutPreference() {
        if (!(this.getModel() instanceof DesignElementHandle)) {
            return;
        }
        ModuleHandle handle = ((DesignElementHandle)this.getModel()).getModuleHandle();
        if (!(handle instanceof ReportDesignHandle)) {
            return;
        }
        if (this.getContentPane().getLayoutManager() instanceof ReportFlowLayout) {
            ((ReportFlowLayout)this.getContentPane().getLayoutManager()).setLayoutPreference(((ReportDesignHandle)handle).getLayoutPreference());
        }
    }

    public boolean isFixLayout() {
        return DEUtil.isFixLayout((Object)this.getModel());
    }
}

