/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.commands;

import org.eclipse.birt.report.designer.core.commands.MoveGuideCommand;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.testutil.BaseTestCase;
import org.eclipse.birt.report.designer.util.MetricUtility;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.util.DimensionUtil;

public class MoveGuideCommandTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.getReportDesignHandle().setDefaultUnits("in");
    }

    public void testMoveGuildRightMargin() {
        int rightMargin = 100;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(rightMargin, "rightMargin");
        moveGuideCmd.execute();
        MoveGuideCommandTest.assertTrue((boolean)page.getRightMargin().getUnits().equals("in"));
        double value = MetricUtility.inchToPixel((double)page.getRightMargin().getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)rightMargin);
    }

    public void testMoveGuildLeftMargin() throws SemanticException {
        int leftMargin = 200;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        this.getReportDesignHandle().setDefaultUnits("cm");
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(leftMargin, "leftMargin");
        moveGuideCmd.execute();
        DimensionValue dim = page.getLeftMargin().getAbsoluteValue();
        MoveGuideCommandTest.assertTrue((boolean)dim.getUnits().equals("cm"));
        DimensionValue dimInch = DimensionUtil.convertTo((DimensionValue)dim, (String)"cm", (String)"in");
        double value = MetricUtility.inchToPixel((double)dimInch.getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)leftMargin);
    }

    public void testMoveGuildTopMargin() {
        int topMargin = 300;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(topMargin, "topMargin");
        moveGuideCmd.execute();
        MoveGuideCommandTest.assertTrue((boolean)page.getTopMargin().getUnits().equals("in"));
        double value = MetricUtility.inchToPixel((double)page.getTopMargin().getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)topMargin);
    }

    public void testMoveGuildBottomMargin() {
        int bottomMargin = 400;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(bottomMargin, "bottomMargin");
        moveGuideCmd.execute();
        MoveGuideCommandTest.assertTrue((boolean)page.getBottomMargin().getUnits().equals("in"));
        double value = MetricUtility.inchToPixel((double)page.getBottomMargin().getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)bottomMargin);
    }

    public void testMoveGuildLittleBottomMargin() {
        int bottomMargin = 1;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(bottomMargin, "bottomMargin");
        moveGuideCmd.execute();
        MoveGuideCommandTest.assertTrue((boolean)page.getBottomMargin().getUnits().equals("in"));
        double value = MetricUtility.inchToPixel((double)page.getBottomMargin().getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)bottomMargin);
    }

    public void testMoveGuildLargeBottomMargin() {
        int bottomMargin = Integer.MAX_VALUE;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(bottomMargin, "bottomMargin");
        moveGuideCmd.execute();
        MoveGuideCommandTest.assertTrue((boolean)page.getBottomMargin().getUnits().equals("in"));
        double value = MetricUtility.inchToPixel((double)page.getBottomMargin().getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)bottomMargin);
    }

    public void testMoveGuildNegtiveBottomMargin() {
        int bottomMargin = -100;
        MasterPageHandle page = SessionHandleAdapter.getInstance().getMasterPageHandle();
        MoveGuideCommand moveGuideCmd = new MoveGuideCommand(bottomMargin, "bottomMargin");
        moveGuideCmd.execute();
        MoveGuideCommandTest.assertTrue((boolean)page.getBottomMargin().getUnits().equals("in"));
        double value = MetricUtility.inchToPixel((double)page.getBottomMargin().getMeasure());
        MoveGuideCommandTest.assertEquals((int)((int)value), (int)0);
    }
}

