/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionKey;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRow;
import org.eclipse.birt.data.engine.olap.data.util.DiskSortedStack;
import org.junit.Assert;
import org.junit.Test;

public class FactTableRowTest {
    @Test
    public void testSaveAndLoad() throws IOException {
        int rowLen = 100000;
        int FACT_TABLE_BUFFER_SIZE = 40000;
        DiskSortedStack result = new DiskSortedStack(40000, true, false, FactTableRow.getCreator());
        int i = 99999;
        while (i >= 0) {
            result.push((Object)this.createRow(i));
            --i;
        }
        i = 0;
        while (i < 100000) {
            this.checkEquals((FactTableRow)result.pop(), this.createRow(i));
            ++i;
        }
        result.close();
    }

    @Test
    public void testSaveAndLoad2() throws IOException {
        int rowLen = 100000;
        int FACT_TABLE_BUFFER_SIZE = 40000;
        DiskSortedStack result = new DiskSortedStack(40000, true, false, FactTableRow.getCreator());
        int i = 99999;
        while (i >= 0) {
            result.push((Object)this.createRow2(i));
            --i;
        }
        i = 0;
        while (i < 100000) {
            this.checkEquals((FactTableRow)result.pop(), this.createRow2(i));
            ++i;
        }
        result.close();
    }

    private void checkEquals(FactTableRow factTableRow1, FactTableRow factTableRow2) {
        Assert.assertEquals((Object)factTableRow1, (Object)factTableRow2);
        Assert.assertEquals((long)factTableRow1.getMeasures().length, (long)factTableRow2.getMeasures().length);
        int i = 0;
        while (i < factTableRow2.getMeasures().length) {
            Assert.assertEquals((Object)factTableRow1.getMeasures()[i], (Object)factTableRow2.getMeasures()[i]);
            ++i;
        }
    }

    private FactTableRow createRow(int iValue) {
        int dimensionLen = 3;
        int measureLen = 3;
        FactTableRow factTableRow = new FactTableRow();
        factTableRow.setDimensionKeys(new DimensionKey[3]);
        int i = 0;
        while (i < 3) {
            factTableRow.getDimensionKeys()[i] = new DimensionKey(i);
            int j = 0;
            while (j < i) {
                factTableRow.getDimensionKeys()[i].getKeyValues()[j] = new Integer(iValue + j);
                ++j;
            }
            ++i;
        }
        factTableRow.setMeasures(new Object[3]);
        i = 0;
        while (i < 3) {
            factTableRow.getMeasures()[i] = new Integer(iValue + i);
            ++i;
        }
        return factTableRow;
    }

    private FactTableRow createRow2(int iValue) {
        int dimensionLen = 3;
        int measureLen = 3;
        FactTableRow factTableRow = new FactTableRow();
        factTableRow.setDimensionKeys(new DimensionKey[3]);
        int i = 0;
        while (i < 3) {
            factTableRow.getDimensionKeys()[i] = new DimensionKey(i);
            int j = 0;
            while (j < i) {
                if (j != 1) {
                    factTableRow.getDimensionKeys()[i].getKeyValues()[j] = new Integer(iValue + j);
                }
                ++j;
            }
            ++i;
        }
        factTableRow.setMeasures(new Object[3]);
        i = 0;
        while (i < 3) {
            factTableRow.getMeasures()[i] = new Integer(iValue + i);
            ++i;
        }
        return factTableRow;
    }
}

