/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.HashMap;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.core.script.ScriptContext;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IColumnDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ColumnDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptDataSourceDesign;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.junit.Assert;
import org.junit.Test;
import testutil.BaseTestCase;

public class ProgressiveAggregationTest
extends BaseTestCase {
    @Test
    public void testEmptyResultSet() throws BirtException {
        DataEngineContext context = DataEngineContext.newInstance((int)3, (ScriptContext)this.scriptContext, null, null, null);
        context.setTmpdir(BaseTestCase.getTempDir());
        PlatformConfig platformConfig = new PlatformConfig();
        platformConfig.setTempDir(BaseTestCase.getTempDir());
        DataEngine dataEngine = DataEngine.newDataEngine((PlatformConfig)platformConfig, (DataEngineContext)context);
        ScriptDataSourceDesign dataSource = new ScriptDataSourceDesign("ds");
        dataSource.setOpenScript("i = 0;");
        ScriptDataSetDesign dataSet = new ScriptDataSetDesign("test");
        dataSet.setDataSource("ds");
        dataSet.addResultSetHint((IColumnDefinition)new ColumnDefinition("column1"));
        dataSet.setFetchScript(" i++; return false");
        dataEngine.defineDataSource((IBaseDataSourceDesign)dataSource);
        dataEngine.defineDataSet((IBaseDataSetDesign)dataSet);
        QueryDefinition qd = new QueryDefinition();
        qd.addBinding((IBinding)new Binding("column1", (IBaseExpression)new ScriptExpression("dataSetRow[\"column1\"]", 2)));
        Binding total1 = new Binding("column2", (IBaseExpression)new ScriptExpression(null));
        total1.setAggrFunction("count");
        qd.addBinding((IBinding)total1);
        qd.setDataSetName("test");
        HashMap appContextMap = new HashMap();
        IResultIterator ri1 = dataEngine.prepare((IQueryDefinition)qd, appContextMap).execute(null).getResultIterator();
        Assert.assertFalse((boolean)ri1.next());
        Assert.assertEquals((long)ri1.getInteger("column2").intValue(), (long)0L);
        dataEngine.shutdown();
    }
}

