/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.reportitem.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.DataType;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.data.Query;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.QueryImpl;
import org.eclipse.birt.chart.reportitem.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataServiceProvider;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.emf.common.util.EList;

public final class QueryUIHelper {
    private static final String BASE_SERIES = Messages.getString((String)"QueryHelper.Text.CategroySeries");
    private static final String ORTHOGONAL_SERIES = Messages.getString((String)"QueryHelper.Text.ValueSeries");
    private static final String X_SERIES = Messages.getString((String)"QueryHelper.Text.XSeries");
    private static final String Y_SERIES = Messages.getString((String)"QueryHelper.Text.YSeries");
    private final Chart cm;
    private IDataServiceProvider dataProvider;

    public QueryUIHelper(Chart cm) {
        this.cm = cm;
    }

    public void enableDataTypeValidator(IDataServiceProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public Collection<String> validate() {
        ArrayList<String> problems = new ArrayList<String>();
        QueryValidator[] qsqa = this.cm instanceof ChartWithAxes ? this.getValidators((ChartWithAxes)this.cm) : this.getValidators((ChartWithoutAxes)this.cm);
        int i = 0;
        while (i < qsqa.length) {
            qsqa[i].validate(problems);
            ++i;
        }
        return problems;
    }

    QueryValidator[] getValidators(ChartWithAxes cwa) {
        ArrayList<QueryValidator> alSeriesQueries = new ArrayList<QueryValidator>(4);
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        if (elSD.size() != 1) {
            return alSeriesQueries.toArray(new QueryDefineValidator[alSeriesQueries.size()]);
        }
        SeriesDefinition bsd = (SeriesDefinition)elSD.get(0);
        Series seBase = bsd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        int[] bDataIndex = seBase.getDefinedDataDefinitionIndex();
        Query[] qua = new Query[bDataIndex.length];
        QueryDefineValidator sqd = new QueryDefineValidator(X_SERIES, qua);
        int i = 0;
        while (i < bDataIndex.length) {
            if (i < elBaseSeries.size()) {
                qua[i] = (Query)elBaseSeries.get(bDataIndex[i]);
            } else {
                qua[i] = QueryImpl.create((String)"");
                elBaseSeries.add((Object)qua[i]);
            }
            ++i;
        }
        alSeriesQueries.add(sqd);
        Axis[] axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int j = 0;
        while (j < axaOrthogonal.length) {
            elSD = axaOrthogonal[j].getSeriesDefinitions();
            ArrayList<Query> queries = new ArrayList<Query>(elSD.size());
            int k = 0;
            while (k < elSD.size()) {
                SeriesDefinition vsd = (SeriesDefinition)elSD.get(k);
                Series seOrthogonal = vsd.getDesignTimeSeries();
                EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
                int[] oDataIndex = seOrthogonal.getDefinedDataDefinitionIndex();
                qua = new Query[oDataIndex.length];
                sqd = new QueryDefineValidator(Y_SERIES, qua);
                int i2 = 0;
                while (i2 < oDataIndex.length) {
                    if (oDataIndex[i2] < elOrthogonalSeries.size()) {
                        qua[i2] = (Query)elOrthogonalSeries.get(oDataIndex[i2]);
                    } else {
                        qua[i2] = QueryImpl.create((String)"");
                        elOrthogonalSeries.add((Object)qua[i2]);
                    }
                    ++i2;
                }
                alSeriesQueries.add(sqd);
                queries.add((Query)elOrthogonalSeries.get(oDataIndex[0]));
                ++k;
            }
            if (this.dataProvider != null) {
                alSeriesQueries.add(new DataTypeValidator(bsd, (List<SeriesDefinition>)elSD, queries));
            }
            ++j;
        }
        return alSeriesQueries.toArray(new QueryValidator[alSeriesQueries.size()]);
    }

    QueryValidator[] getValidators(ChartWithoutAxes cwoa) {
        ArrayList<QueryValidator> alSeriesQueries = new ArrayList<QueryValidator>(4);
        EList elSD = cwoa.getSeriesDefinitions();
        if (elSD.size() != 1) {
            return alSeriesQueries.toArray(new QueryDefineValidator[alSeriesQueries.size()]);
        }
        SeriesDefinition bsd = (SeriesDefinition)elSD.get(0);
        Series seBase = bsd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        int[] bDataIndex = seBase.getDefinedDataDefinitionIndex();
        Query[] qua = new Query[bDataIndex.length];
        QueryDefineValidator sqd = new QueryDefineValidator(BASE_SERIES, qua);
        int i = 0;
        while (i < bDataIndex.length) {
            if (i < elBaseSeries.size()) {
                qua[i] = (Query)elBaseSeries.get(bDataIndex[i]);
            } else {
                qua[i] = QueryImpl.create((String)"");
                elBaseSeries.add((Object)qua[i]);
            }
            ++i;
        }
        alSeriesQueries.add(sqd);
        elSD = bsd.getSeriesDefinitions();
        ArrayList<Query> queries = new ArrayList<Query>(elSD.size());
        int k = 0;
        while (k < elSD.size()) {
            SeriesDefinition vsd = (SeriesDefinition)elSD.get(k);
            Series seOrthogonal = vsd.getDesignTimeSeries();
            EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
            int[] oDataIndex = seOrthogonal.getDefinedDataDefinitionIndex();
            qua = new Query[oDataIndex.length];
            sqd = new QueryDefineValidator(ORTHOGONAL_SERIES, qua);
            int i2 = 0;
            while (i2 < oDataIndex.length) {
                if (oDataIndex[i2] < elOrthogonalSeries.size()) {
                    qua[i2] = (Query)elOrthogonalSeries.get(oDataIndex[i2]);
                } else {
                    qua[i2] = QueryImpl.create((String)"");
                    elOrthogonalSeries.add((Object)qua[i2]);
                }
                ++i2;
            }
            alSeriesQueries.add(sqd);
            queries.add((Query)elOrthogonalSeries.get(oDataIndex[0]));
            ++k;
        }
        if (this.dataProvider != null) {
            alSeriesQueries.add(new DataTypeValidator(bsd, (List<SeriesDefinition>)elSD, queries));
        }
        return alSeriesQueries.toArray(new QueryValidator[alSeriesQueries.size()]);
    }

    public static Map<String, Query[]> getQueryDefinitionsMap(Chart cm) {
        if (cm instanceof ChartWithAxes) {
            return QueryUIHelper.getQueryDefinitionsMap((ChartWithAxes)cm);
        }
        if (cm instanceof ChartWithoutAxes) {
            return QueryUIHelper.getQueryDefinitionsMap((ChartWithoutAxes)cm);
        }
        return Collections.emptyMap();
    }

    static Map<String, Query[]> getQueryDefinitionsMap(ChartWithAxes cwa) {
        Query[] q;
        Axis[] axaOrthogonal;
        HashMap<String, Query[]> queryMap = new HashMap<String, Query[]>();
        Axis axPrimaryBase = cwa.getPrimaryBaseAxes()[0];
        EList elSD = axPrimaryBase.getSeriesDefinitions();
        SeriesDefinition bsd = (SeriesDefinition)elSD.get(0);
        Series seBase = bsd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        Query categoryQuery = (Query)elBaseSeries.get(0);
        if (categoryQuery != null) {
            queryMap.put("category", new Query[]{categoryQuery});
        }
        ArrayList<Query> yOptionQueryList = new ArrayList<Query>();
        ArrayList<Query> valueQueryList = new ArrayList<Query>();
        Axis[] axisArray = axaOrthogonal = cwa.getOrthogonalAxes(axPrimaryBase, true);
        int n = axaOrthogonal.length;
        int n2 = 0;
        while (n2 < n) {
            Axis axis = axisArray[n2];
            elSD = axis.getSeriesDefinitions();
            for (SeriesDefinition sdef : elSD) {
                Query yOptionQuery = sdef.getQuery();
                if (yOptionQuery != null) {
                    yOptionQueryList.add(yOptionQuery);
                }
                Series seOrthogonal = sdef.getDesignTimeSeries();
                EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
                for (Query q2 : elOrthogonalSeries) {
                    if (q2 == null) continue;
                    valueQueryList.add(q2);
                }
            }
            ++n2;
        }
        if (yOptionQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("optional", yOptionQueryList.toArray(q));
        }
        if (valueQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("value", valueQueryList.toArray(q));
        }
        return queryMap;
    }

    static Map<String, Query[]> getQueryDefinitionsMap(ChartWithoutAxes cwoa) {
        Query[] q;
        HashMap<String, Query[]> queryMap = new HashMap<String, Query[]>();
        EList elSD = cwoa.getSeriesDefinitions();
        SeriesDefinition bsd = (SeriesDefinition)elSD.get(0);
        Series seBase = bsd.getDesignTimeSeries();
        EList elBaseSeries = seBase.getDataDefinition();
        Query categoryQuery = (Query)elBaseSeries.get(0);
        if (categoryQuery != null) {
            queryMap.put("category", new Query[]{categoryQuery});
        }
        ArrayList<Query> yOptionQueryList = new ArrayList<Query>();
        ArrayList<Query> valueQueryList = new ArrayList<Query>();
        elSD = bsd.getSeriesDefinitions();
        for (SeriesDefinition sdef : elSD) {
            Query yOptionQuery = sdef.getQuery();
            if (yOptionQuery != null) {
                yOptionQueryList.add(yOptionQuery);
            }
            Series seOrthogonal = sdef.getDesignTimeSeries();
            EList elOrthogonalSeries = seOrthogonal.getDataDefinition();
            for (Query q2 : elOrthogonalSeries) {
                if (q2 == null) continue;
                valueQueryList.add(q2);
            }
        }
        if (yOptionQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("optional", yOptionQueryList.toArray(q));
        }
        if (valueQueryList.size() > 0) {
            q = new Query[]{};
            queryMap.put("value", valueQueryList.toArray(q));
        }
        return queryMap;
    }

    private final class DataTypeValidator
    implements QueryValidator {
        private final SeriesDefinition bsd;
        private final List<SeriesDefinition> vsds;
        private final List<Query> queries;

        DataTypeValidator(SeriesDefinition bsd, List<SeriesDefinition> vsds, List<Query> queries) {
            this.bsd = bsd;
            this.vsds = vsds;
            this.queries = queries;
        }

        @Override
        public void validate(List<String> al) {
            int size = this.vsds.size();
            if (size > 1) {
                DataType firstDataType = null;
                int i = 0;
                while (i < size) {
                    if (!this.queries.get(i).isDefined()) {
                        return;
                    }
                    String aggFun = null;
                    try {
                        aggFun = ChartUtil.getFullAggregateExpression((SeriesDefinition)this.vsds.get(i), (SeriesDefinition)this.bsd, (Query)this.queries.get(i));
                    }
                    catch (ChartException e) {
                        e.printStackTrace();
                    }
                    DataType dataType = null;
                    dataType = "Count".equals(aggFun) || "DistinctCount".equals(aggFun) ? DataType.NUMERIC_LITERAL : QueryUIHelper.this.dataProvider.getDataType(this.queries.get(i).getDefinition());
                    if (dataType != null) {
                        if (firstDataType == null) {
                            firstDataType = dataType;
                        } else if (firstDataType != dataType) {
                            String errorMessage = QueryUIHelper.this.cm instanceof ChartWithAxes ? Messages.getString((String)"QueryHelper.InconsitentDataTypesForAxis") : Messages.getString((String)"QueryHelper.InconsitentDataTypesForValueSeries");
                            al.add(errorMessage);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private static final class QueryDefineValidator
    implements QueryValidator {
        private final String sSeriesType;
        private final Query[] qua;

        QueryDefineValidator(String sSeriesType, Query[] qua) {
            this.sSeriesType = sSeriesType;
            this.qua = qua;
        }

        @Override
        public void validate(List<String> al) {
            if (this.qua.length == 0) {
                al.add(Messages.getString((String)"QueryHelper.NoDataDefinitionFor", (Object)this.sSeriesType));
            } else {
                Object seriesName = ((Series)this.qua[0].eContainer()).getSeriesIdentifier();
                Object nameExt = "";
                if (seriesName != null && seriesName.toString().length() > 0) {
                    nameExt = "(" + seriesName.toString() + ")";
                }
                int i = 0;
                while (i < this.qua.length) {
                    if (!this.qua[i].isDefined()) {
                        al.add(Messages.getString((String)"QueryHelper.dataDefnUndefined", (Object)(this.sSeriesType + (String)nameExt)));
                    }
                    ++i;
                }
            }
        }
    }

    static interface QueryValidator {
        public void validate(List<String> var1);
    }
}

