/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.DatabaseMetaData;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.DataSourceMetaData;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.OdaJdbcDriver;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataSourceMetaDataTest {
    OdaJdbcDriver connFact;
    Connection conn1;
    DataSourceMetaData dbMeta1;
    Connection conn2;
    DataSourceMetaData dbMeta2;

    @Before
    public void dataSourceMetaDataSetUp() throws Exception {
        this.conn1 = TestUtil.openConnection();
        this.conn2 = TestUtil.openConnection();
        this.conn2.close();
        this.dbMeta1 = (DataSourceMetaData)this.conn1.getMetaData("");
        this.dbMeta2 = (DataSourceMetaData)this.conn2.getMetaData("");
    }

    @After
    public void dataSourceMetaDataTearDown() throws Exception {
        this.conn1.close();
    }

    @Test
    public void testDataSourceMetaData() throws Exception {
        DataSourceMetaData tempMeta = new DataSourceMetaData((IConnection)new Connection(), TestUtil.openJDBCConnection().getMetaData());
        Assert.assertNotNull((Object)tempMeta);
    }

    @Test
    public void testGetConnection() throws Exception {
        Assert.assertEquals((Object)this.dbMeta1.getConnection(), (Object)this.conn1);
        Assert.assertEquals((Object)this.dbMeta2.getConnection(), (Object)this.conn2);
    }

    @Test
    public void testGetDataSourceObjects() throws Exception {
        Assert.assertNull((Object)this.dbMeta1.getDataSourceObjects("", "", "", ""));
        Assert.assertNull((Object)this.dbMeta2.getDataSourceObjects("", "", "", ""));
    }

    @Test
    public void testGetDataSourceMajorVersion() throws Exception {
    }

    @Test
    public void testGetDataSourceMinorVersion() throws Exception {
    }

    @Test
    public void testGetDataSourceProductName() throws Exception {
    }

    @Test
    public void testGetDataSourceProductVersion() throws Exception {
    }

    @Test
    public void testGetSQLStateType() throws Exception {
        try {
            this.dbMeta2.getSQLStateType();
            Assert.fail((String)"call getSQLStateType from DataSourceMetaData which is from the non-opened connection should throw exception.");
        }
        catch (JDBCException jDBCException) {
            // empty catch block
        }
        java.sql.Connection jdbcConn = TestUtil.openJDBCConnection();
        DatabaseMetaData dbMeta = jdbcConn.getMetaData();
        if (dbMeta.getSQLStateType() == 2) {
            Assert.assertEquals((long)this.dbMeta1.getSQLStateType(), (long)1L);
        } else {
            Assert.assertEquals((long)this.dbMeta1.getSQLStateType(), (long)0L);
        }
    }

    @Test
    public void testSupportsMultipleOpenResults() throws Exception {
        Assert.assertFalse((boolean)this.dbMeta1.supportsMultipleOpenResults());
        Assert.assertFalse((boolean)this.dbMeta2.supportsMultipleOpenResults());
    }

    @Test
    public void testSupportsMultipleResultSets() throws Exception {
        Assert.assertTrue((boolean)this.dbMeta1.supportsMultipleResultSets());
        Assert.assertTrue((boolean)this.dbMeta2.supportsMultipleResultSets());
    }

    @Test
    public void testSupportsNamedResultSets() throws Exception {
        Assert.assertTrue((boolean)this.dbMeta1.supportsNamedResultSets());
        Assert.assertTrue((boolean)this.dbMeta2.supportsNamedResultSets());
    }

    @Test
    public void testSupportsNamedParameters() throws Exception {
        Assert.assertFalse((boolean)this.dbMeta1.supportsNamedParameters());
        Assert.assertFalse((boolean)this.dbMeta2.supportsNamedParameters());
    }

    @Test
    public void testSupportsInParameters() throws Exception {
        Assert.assertTrue((boolean)this.dbMeta1.supportsInParameters());
        Assert.assertTrue((boolean)this.dbMeta2.supportsInParameters());
    }

    @Test
    public void testSupportsOutParameters() throws Exception {
        Assert.assertTrue((boolean)this.dbMeta1.supportsOutParameters());
        Assert.assertTrue((boolean)this.dbMeta2.supportsOutParameters());
    }

    @Test
    public void testGetSortMode() throws Exception {
        Assert.assertEquals((long)this.dbMeta1.getSortMode(), (long)0L);
        Assert.assertEquals((long)this.dbMeta2.getSortMode(), (long)0L);
    }
}

