/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.engine.computation;

import junit.framework.TestCase;
import org.eclipse.birt.chart.computation.Point;
import org.eclipse.birt.chart.computation.Rectangle;

public class RectangleTest
extends TestCase {
    Rectangle r;

    protected void setUp() throws Exception {
        super.setUp();
        this.r = new Rectangle();
        this.r.setRect(1.0, 1.0, 4.0, 4.0);
    }

    protected void tearDown() throws Exception {
        this.r = null;
        super.tearDown();
    }

    public void testGet() {
        RectangleTest.assertEquals((double)this.r.getHeight(), (double)4.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getWidth(), (double)4.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getX(), (double)1.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getY(), (double)1.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getMinX(), (double)1.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getMinY(), (double)1.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getMaxX(), (double)5.0, (double)0.0);
        RectangleTest.assertEquals((double)this.r.getMaxY(), (double)5.0, (double)0.0);
    }

    public void testOutcode() {
        RectangleTest.assertEquals((int)this.r.outcode(0.0, 1.0), (int)1);
        RectangleTest.assertEquals((int)this.r.outcode(1.0, 0.0), (int)2);
        RectangleTest.assertEquals((int)this.r.outcode(0.0, 0.0), (int)3);
        RectangleTest.assertEquals((int)this.r.outcode(6.0, 5.0), (int)4);
        RectangleTest.assertEquals((int)this.r.outcode(6.0, 0.0), (int)6);
        RectangleTest.assertEquals((int)this.r.outcode(5.0, 6.0), (int)8);
        RectangleTest.assertEquals((int)this.r.outcode(0.0, 6.0), (int)9);
    }

    public void testIsEmpty() {
        RectangleTest.assertEquals((boolean)this.r.isEmpty(), (boolean)false);
    }

    public void testContain() {
        RectangleTest.assertEquals((boolean)this.r.contains(new Point(0.0, 0.0)), (boolean)false);
        RectangleTest.assertEquals((boolean)this.r.contains(new Point(2.0, 2.0)), (boolean)true);
    }
}

