/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.tests.device.render;

import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.eclipse.birt.chart.tests.device.render.Png24PrimitiveGen;
import org.eclipse.birt.chart.tests.device.render.SvgPrimitiveGen;
import utility.ImageUtil;

public class ImageOutputBaseTest
extends TestCase {
    protected File file;
    protected String dirName;
    protected String filename;
    protected String workspaceDir;

    public ImageOutputBaseTest(File file, String dirName, String filename, String workspaceDir) {
        super(filename);
        this.file = file;
        this.dirName = dirName;
        this.filename = filename;
        this.workspaceDir = workspaceDir;
    }

    public void runTest() throws Throwable {
        String[] files;
        if (!ImageUtil.isRenderingTestApplicable()) {
            return;
        }
        HashMap<ImageUtil.ImageCompParam, Integer> params = new HashMap<ImageUtil.ImageCompParam, Integer>();
        params.put(ImageUtil.ImageCompParam.TOLERANCE, 4);
        Png24PrimitiveGen generator2 = new Png24PrimitiveGen(new FileInputStream(this.workspaceDir + File.separator + "input" + this.dirName + File.separator + this.filename + ".drw"), this.workspaceDir + File.separator + "output" + this.dirName + File.separator + this.filename + ".png");
        generator2.generate();
        generator2.flush();
        String control = this.workspaceDir + File.separator + "golden" + this.dirName + File.separator + this.filename + ".png";
        Image result = ImageUtil.compare((String)control, (String)(this.workspaceDir + File.separator + "output" + this.dirName + File.separator + this.filename + ".png"), params);
        if (result != null) {
            ImageUtil.savePNG((Image)result, (String)control);
            ImageOutputBaseTest.fail();
        }
        SvgPrimitiveGen generator3 = new SvgPrimitiveGen(new FileInputStream(this.workspaceDir + File.separator + "input" + this.dirName + File.separator + this.filename + ".drw"), this.workspaceDir + File.separator + "output" + this.dirName + File.separator + this.filename + ".svg");
        generator3.generate();
        generator3.flush();
        String[] stringArray = files = new String[]{this.workspaceDir + File.separator + "golden" + this.dirName + File.separator + this.filename + ".svg", this.workspaceDir + File.separator + "output" + this.dirName + File.separator + this.filename + ".svg"};
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            FileInputStream inStream = new FileInputStream(file);
            TranscoderInput input = new TranscoderInput((InputStream)inStream);
            FileOutputStream outStream = new FileOutputStream(file + ".png");
            TranscoderOutput output = new TranscoderOutput((OutputStream)outStream);
            PNGTranscoder converter = new PNGTranscoder();
            converter.transcode(input, output);
            outStream.flush();
            ((OutputStream)outStream).close();
            ++n2;
        }
        result = ImageUtil.compare((String)(files[0] + ".png"), (String)(files[1] + ".png"));
        if (result != null) {
            ImageUtil.savePNG((Image)result, (String)(files[0] + ".png"));
            ImageOutputBaseTest.fail();
        }
    }
}

