/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.core.archive.compound.ArchiveFileFactory;
import org.eclipse.birt.core.archive.compound.IArchiveFileFactory;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IRenderTask;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportEngineFactory;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunTask;

public abstract class EngineCase
extends TestCase {
    protected static final String REPORT_DESIGN = "design.rptdesign";
    protected static final String REPORT_DOCUMENT = "reportdocument";
    protected IReportEngine engine;
    protected IArchiveFileFactory archiveFactory = new ArchiveFileFactory();

    public EngineCase() {
    }

    public EngineCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.engine = this.createReportEngine();
    }

    protected void tearDown() throws Exception {
        this.engine.destroy();
    }

    public void copyResource(String src, String tgt) {
        InputStream in;
        File parent = new File(tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        EngineCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream(tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EngineCase.fail();
        }
    }

    public byte[] loadResource(String src) {
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(src);
        EngineCase.assertTrue((in != null ? 1 : 0) != 0);
        try {
            int size = in.available();
            byte[] buffer = new byte[size];
            in.read(buffer);
            in.close();
            return buffer;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            EngineCase.fail();
            return null;
        }
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(file.toString() + " can't be removed in " + String.valueOf(((Object)((Object)this)).getClass()));
        }
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void unzip(String src, String folder) {
    }

    public IReportEngine createReportEngine() {
        return this.createReportEngine(null);
    }

    public IReportEngine createReportEngine(EngineConfig config) {
        Object factory;
        if (config == null) {
            config = new EngineConfig();
        }
        if ((factory = Platform.createFactoryObject((String)"org.eclipse.birt.report.engine.ReportEngineFactory")) instanceof IReportEngineFactory) {
            return ((IReportEngineFactory)factory).createReportEngine(config);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public String renderDocument(String reportDocument) throws EngineException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void render(String design, IRenderOption options) throws EngineException {
        IReportDocument document = this.createReportDocument(design);
        IRenderTask render = this.engine.createRenderTask(document);
        render.setRenderOption(options);
        render.render();
        render.close();
        document.close();
    }

    protected IReportDocument createReportDocument(String designFileName) throws EngineException {
        this.useDesignFile(designFileName);
        this.createReportDocument();
        return this.engine.openReportDocument(REPORT_DOCUMENT);
    }

    public void createReportDocument(String reportDesign, String reportDocument) throws EngineException {
        IReportRunnable report = this.engine.openReportDesign(reportDesign);
        try (IRunTask task = this.engine.createRunTask(report);){
            task.run(reportDocument);
        }
    }

    protected void useDesignFile(String fileName) {
        this.removeFile(REPORT_DESIGN);
        this.removeFile(REPORT_DOCUMENT);
        this.copyResource(fileName, REPORT_DESIGN);
    }

    protected void createReportDocument() throws EngineException {
        IReportRunnable report = this.engine.openReportDesign(REPORT_DESIGN);
        IRunTask task = this.engine.createRunTask(report);
        task.run(REPORT_DOCUMENT);
        task.close();
    }

    protected String runAndRender(String designFile) throws EngineException, IOException {
        IRunAndRenderTask runAndRenderTask = this.createRunAndRenderTask(designFile);
        HTMLRenderOption options = new HTMLRenderOption();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)out);
        options.setOutputFormat("html");
        options.setHtmlPagination(true);
        runAndRenderTask.setRenderOption((IRenderOption)options);
        runAndRenderTask.run();
        runAndRenderTask.close();
        String result = new String(out.toByteArray());
        out.close();
        return result;
    }

    protected IRunAndRenderTask createRunAndRenderTask(String designFile) throws EngineException {
        this.useDesignFile(designFile);
        IReportRunnable reportDesign = this.engine.openReportDesign(REPORT_DESIGN);
        IRunAndRenderTask runAndRenderTask = this.engine.createRunAndRenderTask(reportDesign);
        return runAndRenderTask;
    }

    protected String render(String designFile) throws EngineException, IOException {
        HTMLRenderOption options = new HTMLRenderOption();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        options.setOutputStream((OutputStream)out);
        options.setHtmlPagination(true);
        options.setOutputFormat("html");
        this.render(designFile, (IRenderOption)options);
        String result = new String(out.toByteArray());
        out.close();
        return result;
    }

    protected int getCount(String source, String match) {
        int count = 0;
        int index = 0;
        while ((index = source.indexOf(match, index)) >= 0) {
            ++count;
            if (++index < source.length()) continue;
        }
        return count;
    }
}

