/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.OdaLevelAttributeHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.OdaLevelAttribute;
import org.eclipse.birt.report.model.api.elements.structures.Rule;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;
import org.eclipse.birt.report.model.api.olap.OdaCubeHandle;
import org.eclipse.birt.report.model.api.olap.OdaHierarchyHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class OdaCubeParseTest
extends BaseTestCase {
    private final String FILE_NAME = "OdaCubeParserTest.xml";

    public void testParser() throws Exception {
        this.openDesign("OdaCubeParserTest.xml");
        OdaCubeParseTest.assertNotNull((Object)this.designHandle);
        OdaCubeHandle cube = (OdaCubeHandle)this.designHandle.findCube("testCube");
        Iterator iter = cube.filtersIterator();
        FilterConditionHandle filterConditionHandle = (FilterConditionHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        PropertyHandle propHandle = cube.getPropertyHandle("dimensions");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        DimensionHandle dimension = (DimensionHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)dimension, (Object)cube.getContent("dimensions", 0));
        OdaCubeParseTest.assertEquals((String)"testDimension", (String)dimension.getName());
        OdaCubeParseTest.assertTrue((boolean)dimension.isTimeType());
        propHandle = dimension.getPropertyHandle("hierarchies");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)dimension.getContentCount("hierarchies"));
        OdaHierarchyHandle hierarchy = (OdaHierarchyHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)hierarchy, (Object)dimension.getContent("hierarchies", 0));
        OdaCubeParseTest.assertEquals((String)"testHierarchy", (String)hierarchy.getName());
        propHandle = cube.getPropertyHandle("dimensions");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)cube.getContentCount("dimensions"));
        iter = hierarchy.filtersIterator();
        filterConditionHandle = (FilterConditionHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"filter expression", (String)filterConditionHandle.getExpr());
        propHandle = hierarchy.getPropertyHandle("levels");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)hierarchy.getContentCount("levels"));
        LevelHandle level = (LevelHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)level, (Object)hierarchy.getContent("levels", 0));
        OdaCubeParseTest.assertEquals((String)"testLevel", (String)level.getName());
        OdaCubeParseTest.assertEquals((String)"integer", (String)level.getDataType());
        OdaCubeParseTest.assertEquals((String)"none", (String)level.getInterval());
        OdaCubeParseTest.assertEquals((double)3.0, (double)level.getIntervalRange(), (double)0.0);
        OdaCubeParseTest.assertEquals((String)"Jan", (String)level.getIntervalBase());
        OdaCubeParseTest.assertEquals((String)"dynamic", (String)level.getLevelType());
        OdaCubeParseTest.assertEquals((String)"2", (String)level.getDefaultValue());
        iter = level.staticValuesIterator();
        RuleHandle rule = (RuleHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"rule expression", (String)rule.getRuleExpression());
        OdaCubeParseTest.assertEquals((String)"display expression", (String)rule.getDisplayExpression());
        rule = (RuleHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"rule expression2", (String)rule.getRuleExpression());
        OdaCubeParseTest.assertEquals((String)"display expression2", (String)rule.getDisplayExpression());
        iter = level.attributesIterator();
        OdaLevelAttributeHandle attribute = (OdaLevelAttributeHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"var1", (String)attribute.getName());
        OdaCubeParseTest.assertEquals((String)"string", (String)attribute.getDataType());
        OdaCubeParseTest.assertEquals((String)"native var1", (String)attribute.getNativeName());
        OdaCubeParseTest.assertEquals((int)10, (int)attribute.getNativeDataType());
        attribute = (OdaLevelAttributeHandle)iter.next();
        OdaCubeParseTest.assertEquals((String)"var2", (String)attribute.getName());
        OdaCubeParseTest.assertEquals((String)"integer", (String)attribute.getDataType());
        OdaCubeParseTest.assertEquals((String)"native var2", (String)attribute.getNativeName());
        OdaCubeParseTest.assertEquals((int)2, (int)attribute.getNativeDataType());
        propHandle = cube.getPropertyHandle("measureGroups");
        OdaCubeParseTest.assertEquals((int)1, (int)propHandle.getContentCount());
        OdaCubeParseTest.assertEquals((int)1, (int)cube.getContentCount("measureGroups"));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((Object)measureGroup, (Object)cube.getContent("measureGroups", 0));
        OdaCubeParseTest.assertEquals((String)"testMeasureGroup", (String)measureGroup.getName());
        propHandle = measureGroup.getPropertyHandle("measures");
        MeasureHandle measure = (MeasureHandle)propHandle.getContent(0);
        OdaCubeParseTest.assertEquals((String)"testMeasure", (String)measure.getName());
        OdaCubeParseTest.assertEquals((String)"column", (String)measure.getMeasureExpression());
        OdaCubeParseTest.assertEquals((String)"min", (String)measure.getFunction());
        OdaCubeParseTest.assertFalse((boolean)measure.isCalculated());
        OdaCubeParseTest.assertEquals((String)"justify", (String)level.getAlignment());
        OdaCubeParseTest.assertEquals((String)"justify", (String)measure.getAlignment());
    }

    public void testWriter() throws Exception {
        this.openDesign("OdaCubeParserTest.xml");
        OdaCubeParseTest.assertNotNull((Object)this.designHandle);
        String namePrix = "new";
        String valuePrix = "updated ";
        ElementFactory factory = this.designHandle.getElementFactory();
        OdaCubeHandle cube = (OdaCubeHandle)this.designHandle.findCube("testCube");
        cube.setName(namePrix + cube.getName());
        cube.add("dimensions", (DesignElementHandle)factory.newOdaDimension(null));
        DimensionHandle dimension = (DimensionHandle)cube.getContent("dimensions", 0);
        dimension.setName(namePrix + dimension.getName());
        dimension.setTimeType(false);
        dimension.setDefaultHierarchy((HierarchyHandle)factory.newOdaHierarchy("testDefaultHierarchy"));
        dimension.add("hierarchies", (DesignElementHandle)factory.newOdaHierarchy(null));
        OdaHierarchyHandle hierarchy = (OdaHierarchyHandle)dimension.getContent("hierarchies", 0);
        hierarchy.setName(namePrix + hierarchy.getName());
        hierarchy.add("levels", (DesignElementHandle)factory.newOdaLevel(dimension, null));
        LevelHandle level = (LevelHandle)hierarchy.getContent("levels", 0);
        level.setName(namePrix + level.getName());
        level.setDataType("string");
        level.setIntervalRange(5.0);
        level.setDefaultValue("10");
        level.setIntervalBase(valuePrix + level.getIntervalBase());
        level.setLevelType("mirrored");
        PropertyHandle propHandle = level.getPropertyHandle("staticValues");
        propHandle.removeItem(0);
        Rule rule = new Rule();
        rule.setProperty("displayExpre", (Object)"new display expression");
        rule.setProperty("ruleExpre", (Object)"new rule expression");
        propHandle.insertItem((IStructure)rule, 0);
        propHandle = level.getPropertyHandle("attributes");
        propHandle.removeItem(propHandle.get(1));
        OdaLevelAttribute attribute = new OdaLevelAttribute();
        attribute.setName("var3");
        attribute.setDataType("boolean");
        attribute.setNativeDataType(new Integer(100));
        attribute.setNativeName("new native name 3");
        propHandle.insertItem((IStructure)attribute, 0);
        cube.add("measureGroups", (DesignElementHandle)factory.newOdaMeasureGroup(null));
        MeasureGroupHandle measureGroup = (MeasureGroupHandle)cube.getContent("measureGroups", 0);
        measureGroup.setName(namePrix + measureGroup.getName());
        measureGroup.add("measures", (DesignElementHandle)factory.newOdaMeasure(null));
        MeasureHandle measure = (MeasureHandle)measureGroup.getContent("measures", 0);
        measure.setName(namePrix + measure.getName());
        measure.setMeasureExpression(valuePrix + measure.getMeasureExpression());
        measure.setFunction("count");
        measure.setCalculated(true);
        level.setAlignment("center");
        measure.setAlignment("center");
        this.save();
        OdaCubeParseTest.assertTrue((boolean)this.compareFile("OdaCubeParserTest_golden.xml"));
    }
}

