/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.SortElementHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class FilterAndSortParseTest
extends BaseTestCase {
    private static final String FILE_NAME = "FilterAndSortParseTest.xml";

    public void testParser() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        FilterAndSortParseTest.assertNotNull((Object)testTable);
        List valueList = testTable.getListProperty("filter");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        FilterAndSortParseTest.assertEquals((String)"lt", (String)filter.getOperator());
        FilterAndSortParseTest.assertTrue((boolean)filter.isOptional());
        FilterAndSortParseTest.assertEquals((String)"filter expression", (String)filter.getExpr());
        FilterAndSortParseTest.assertEquals((String)"value1 expression", (String)filter.getValue1());
        FilterAndSortParseTest.assertEquals((String)"value2 expression", (String)filter.getValue2());
        ExpressionHandle exprHandle = filter.getExpressionProperty("value2");
        FilterAndSortParseTest.assertEquals((String)"constant", (String)exprHandle.getType());
        FilterAndSortParseTest.assertEquals((String)"value2 expression", (String)exprHandle.getStringExpression());
        FilterAndSortParseTest.assertEquals((String)"ResultSet", (String)filter.getFilterTarget());
        FilterAndSortParseTest.assertEquals((String)"ext name", (String)filter.getExtensionName());
        FilterAndSortParseTest.assertEquals((String)"ext id", (String)filter.getExtensionExprId());
        FilterAndSortParseTest.assertTrue((boolean)filter.pushDown());
        FilterAndSortParseTest.assertEquals((String)"DynamicFilterParam", (String)filter.getDynamicFilterParameter());
        FilterAndSortParseTest.assertEquals((String)"slicer", (String)filter.getType());
        FilterAndSortParseTest.assertTrue((boolean)filter.updateAggregation());
        MemberValueHandle memberValue = filter.getMember();
        FilterAndSortParseTest.assertEquals((String)"value_1", (String)memberValue.getValue());
        FilterAndSortParseTest.assertEquals((String)"testDimension/testLevel", (String)memberValue.getCubeLevelName());
        FilterAndSortParseTest.assertNotNull((Object)memberValue.getLevel());
        Iterator iter = memberValue.filtersIterator();
        FilterConditionHandle filterStructHandle = (FilterConditionHandle)iter.next();
        FilterAndSortParseTest.assertEquals((String)"lt", (String)filterStructHandle.getOperator());
        memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        FilterAndSortParseTest.assertEquals((String)"value_2", (String)memberValue.getValue());
        FilterAndSortParseTest.assertNull((Object)memberValue.getLevel());
        FilterAndSortParseTest.assertNull((Object)memberValue.getCubeLevelName());
        valueList = testTable.getListProperty("sorts");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        SortElementHandle sort = (SortElementHandle)valueList.get(0);
        FilterAndSortParseTest.assertEquals((String)"key_1", (String)sort.getKey());
        FilterAndSortParseTest.assertEquals((String)"desc", (String)sort.getDirection());
        FilterAndSortParseTest.assertEquals((int)8, (int)sort.getStrength());
        FilterAndSortParseTest.assertEquals((Object)ULocale.GERMAN, (Object)sort.getLocale());
        memberValue = sort.getMember();
        FilterAndSortParseTest.assertEquals((String)"value_1", (String)memberValue.getValue());
        FilterAndSortParseTest.assertEquals((String)"testDimension/testLevel", (String)memberValue.getCubeLevelName());
        FilterAndSortParseTest.assertNotNull((Object)memberValue.getLevel());
        memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        FilterAndSortParseTest.assertEquals((String)"value_2", (String)memberValue.getValue());
        FilterAndSortParseTest.assertNull((Object)memberValue.getLevel());
        FilterAndSortParseTest.assertNull((Object)memberValue.getCubeLevelName());
        TableHandle table = (TableHandle)this.designHandle.findElement("Test table");
        FilterAndSortParseTest.assertNotNull((Object)table);
        FilterConditionHandle filterHandle = (FilterConditionHandle)table.filtersIterator().next();
        FilterAndSortParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        FilterAndSortParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        FilterAndSortParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        FilterAndSortParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        FilterAndSortParseTest.assertEquals((String)"ext name", (String)filterHandle.getExtensionName());
        FilterAndSortParseTest.assertEquals((String)"ext id", (String)filterHandle.getExtensionExprId());
        FilterAndSortParseTest.assertTrue((boolean)filterHandle.pushDown());
        FilterAndSortParseTest.assertEquals((String)"DynamicFilterParam", (String)filterHandle.getDynamicFilterParameter());
        FilterAndSortParseTest.assertEquals((String)"slicer", (String)filterHandle.getType());
        FilterAndSortParseTest.assertTrue((boolean)filterHandle.updateAggregation());
        FilterAndSortParseTest.assertEquals((String)"customed 1", (String)filterHandle.getCustomValue());
    }

    public void testWriter() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        FilterAndSortParseTest.assertNotNull((Object)testTable);
        String valuePrefix = "new ";
        List valueList = testTable.getListProperty("filter");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        filter.setOperator("ge");
        filter.setOptional(false);
        filter.setExpr("new " + filter.getExpr());
        filter.setValue1("new " + filter.getValue1());
        filter.setValue2("new " + filter.getValue2());
        filter.setFilterTarget("DataSet");
        filter.setExtensionExprId("new " + filter.getExtensionExprId());
        filter.setExtensionName("new " + filter.getExtensionName());
        filter.setPushDown(false);
        filter.setDynamicFilterParameter("new " + filter.getDynamicFilterParameter());
        filter.setType("simple");
        filter.setUpdateAggregation(false);
        MemberValueHandle memberValue = filter.getMember();
        memberValue.setValue("new " + memberValue.getValue());
        memberValue.setLevel(this.designHandle.findLevel("testDimension/testLevel_one"));
        Iterator iter = memberValue.filtersIterator();
        FilterConditionHandle filterStructHandle = (FilterConditionHandle)iter.next();
        memberValue.getPropertyHandle("filter").addItem(filterStructHandle.getStructure().copy());
        valueList = testTable.getListProperty("sorts");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        SortElementHandle sort = (SortElementHandle)valueList.get(0);
        sort.setKey("new " + sort.getKey());
        sort.setDirection("asc");
        sort.setStrength(12);
        sort.setLocale(ULocale.CANADA_FRENCH);
        memberValue = sort.getMember();
        memberValue.setValue("new " + memberValue.getValue());
        memberValue.setLevel(this.designHandle.findLevel("testDimension/testLevel_one"));
        TableHandle table = (TableHandle)this.designHandle.findElement("Test table");
        FilterAndSortParseTest.assertNotNull((Object)table);
        Iterator iter1 = table.filtersIterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)iter1.next();
        filterHandle.setOperator("gt");
        filterHandle.setExpr("new " + filterHandle.getExpr());
        filterHandle.setValue1("new " + filterHandle.getValue1());
        filterHandle.setExtensionExprId("new " + filterHandle.getExtensionExprId());
        filterHandle.setExtensionName("new " + filterHandle.getExtensionName());
        filterHandle.setPushDown(false);
        filterHandle.setDynamicFilterParameter("new " + filterHandle.getDynamicFilterParameter());
        filterHandle.setType("simple");
        filterHandle.setUpdateAggregation(false);
        filterHandle = (FilterConditionHandle)iter1.next();
        ArrayList<Expression> tmpList = new ArrayList<Expression>();
        tmpList.add(new Expression((Object)"constant1", "constant"));
        filterHandle.setValue1(tmpList);
        filterHandle.setValue2(new Expression((Object)"constant2", "constant"));
        filterHandle.setCustomValue("customed updated");
        this.save();
        FilterAndSortParseTest.assertTrue((boolean)this.compareFile("FilterAndSortParseTest_golden.xml"));
    }

    public void testUserProperties() throws Exception {
        this.openDesign("FilterAndSortParseTest_1.xml");
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        FilterAndSortParseTest.assertNotNull((Object)testTable);
        List valueList = testTable.getListProperty("filter");
        FilterAndSortParseTest.assertEquals((int)2, (int)valueList.size());
        FilterConditionElementHandle filter = (FilterConditionElementHandle)valueList.get(0);
        List userProps = filter.getUserProperties();
        FilterAndSortParseTest.assertEquals((int)1, (int)userProps.size());
        UserPropertyDefn userProp = (UserPropertyDefn)userProps.get(0);
        FilterAndSortParseTest.assertEquals((Object)userProp, (Object)filter.getPropertyDefn(userProp.getName()));
        FilterAndSortParseTest.assertEquals((String)"valueProp1", (String)filter.getStringProperty(userProp.getName()));
        filter = (FilterConditionElementHandle)valueList.get(1);
        userProp = new UserPropertyDefn();
        userProp.setName("userProp2");
        userProp.setType(MetaDataDictionary.getInstance().getPropertyType(2));
        filter.addUserPropertyDefn(userProp);
        filter.setIntProperty(userProp.getName(), 12);
        this.save();
        FilterAndSortParseTest.assertTrue((boolean)this.compareFile("FilterAndSortParseTest_golden_1.xml"));
    }

    public void testPropertyHandleIterator() throws Exception {
        this.openDesign(FILE_NAME);
        DesignElementHandle testTable = this.designHandle.findElement("testTable");
        FilterAndSortParseTest.assertNotNull((Object)testTable);
        PropertyHandle propHandle = testTable.getPropertyHandle("filter");
        Iterator filters = propHandle.iterator();
        FilterAndSortParseTest.assertTrue((boolean)filters.hasNext());
        FilterAndSortParseTest.assertTrue((boolean)(filters.next() instanceof FilterConditionElementHandle));
        FilterAndSortParseTest.assertTrue((boolean)filters.hasNext());
        FilterAndSortParseTest.assertTrue((boolean)(filters.next() instanceof FilterConditionElementHandle));
        FilterAndSortParseTest.assertFalse((boolean)filters.hasNext());
    }
}

