/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataItemHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class CompoundExtendParserTest
extends BaseTestCase {
    private static final String INPUT1 = "CompoundExtendParserTest.xml";
    private static final String INPUT2 = "CompoundExtendParserTest2.xml";
    private static final String INPUT3 = "CompoundExtendParserTest3.xml";
    private static final String GOLDEN_FILE = "CompoundExtendParserTest_golden.xml";
    private static final String GOLDEN_FILE2 = "CompoundExtendParserTest_golden2.xml";
    private static final String semanticErrorCheckFileName = "CompoundExtendParserTest4.xml";

    public void testParser() throws Exception {
        this.openDesign(INPUT1, ULocale.ENGLISH);
        TableHandle baseTable = (TableHandle)this.designHandle.findElement("baseTable");
        CompoundExtendParserTest.assertEquals((Object)"green", (Object)baseTable.getHeader().get(0).getElement().getLocalProperty((Module)this.design, "color"));
        TableHandle interTable = (TableHandle)this.designHandle.findElement("innerTable");
        CompoundExtendParserTest.assertNotNull((Object)interTable);
        CompoundExtendParserTest.assertEquals((Object)"yellow", (Object)interTable.getHeader().get(0).getElement().getSlot(0).getContent(0).getLocalProperty((Module)this.design, "color"));
        TableHandle bodyTable = (TableHandle)this.designHandle.findElement("table1");
        CompoundExtendParserTest.assertEquals((String)"New Design Table", (String)bodyTable.getCaption());
        TableRow row = (TableRow)bodyTable.getElement().getSlot(0).getContent(0);
        CompoundExtendParserTest.assertEquals((Object)"blue", (Object)row.getLocalProperty((Module)this.design, "color"));
        CellHandle bodyCell = (CellHandle)bodyTable.getDetail().get(1).getSlot(0).get(0);
        TableHandle bodyInnerTable = (TableHandle)bodyCell.getContent().get(0);
        RowHandle bodyInnerRow = (RowHandle)bodyInnerTable.getHeader().get(0);
        CellHandle bodyInnerCell = (CellHandle)bodyInnerRow.getCells().get(0);
        CompoundExtendParserTest.assertEquals((Object)"lime", (Object)bodyInnerCell.getElement().getLocalProperty((Module)this.design, "color"));
    }

    public void testPropertySearch() throws DesignFileException {
        this.openDesign(INPUT3, ULocale.ENGLISH);
        GridHandle gridHandle = (GridHandle)this.designHandle.findElement("Grid1");
        CompoundExtendParserTest.assertEquals((String)"24pt", (String)gridHandle.getHeight().getStringValue());
        CompoundExtendParserTest.assertEquals((String)"40mm", (String)gridHandle.getWidth().getStringValue());
        RowHandle rowHandle1 = (RowHandle)gridHandle.getRows().get(0);
        CellHandle cellHandle1 = (CellHandle)rowHandle1.getCells().get(0);
        LabelHandle labelHandle = (LabelHandle)cellHandle1.getContent().get(0);
        LabelHandle labelHandle1 = (LabelHandle)cellHandle1.getContent().get(1);
        CompoundExtendParserTest.assertEquals((String)"28mm", (String)cellHandle1.getHeight().getStringValue());
        CompoundExtendParserTest.assertEquals((String)"64pt", (String)cellHandle1.getWidth().getStringValue());
        CompoundExtendParserTest.assertEquals((String)"New Address", (String)labelHandle.getText());
        CompoundExtendParserTest.assertEquals((String)"new_text_key", (String)labelHandle.getTextKey());
        CompoundExtendParserTest.assertEquals((String)"Child Label(Address)", (String)labelHandle.getName());
        CompoundExtendParserTest.assertEquals((String)"baseLabel21", (String)labelHandle1.getName());
        CompoundExtendParserTest.assertEquals(null, (Object)labelHandle1.getStyle());
        CompoundExtendParserTest.assertEquals((String)"style1", (String)labelHandle.getStyle().getName());
        CompoundExtendParserTest.assertEquals((String)"red", (String)labelHandle.getStringProperty("color"));
        CompoundExtendParserTest.assertEquals((String)"12mm", (String)labelHandle.getStringProperty("fontSize"));
        DataItemHandle dataHandle = (DataItemHandle)cellHandle1.getContent().get(2);
        CompoundExtendParserTest.assertEquals((String)"dataSetRow[\"STUDENT_ID\"]", (String)dataHandle.getResultSetExpression());
        CompoundExtendParserTest.assertEquals((long)9L, (long)labelHandle.getElement().getBaseId());
    }

    public void testSemanticWarning() throws Exception {
        this.openDesign(INPUT2, ULocale.ENGLISH);
        List errors = this.designHandle.getErrorList();
        CompoundExtendParserTest.assertEquals((int)4, (int)errors.size());
        ErrorDetail error1 = (ErrorDetail)errors.get(0);
        CompoundExtendParserTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)error1.getErrorCode());
        ErrorDetail error2 = (ErrorDetail)errors.get(1);
        CompoundExtendParserTest.assertEquals((String)"Error.ContentException.STRUCTURE_CHANGE_FORBIDDEN", (String)error2.getErrorCode());
        ErrorDetail error3 = (ErrorDetail)errors.get(2);
        CompoundExtendParserTest.assertEquals((String)"Error.DesignParserException.VIRTUAL_PARENT_NOT_FOUND", (String)error3.getErrorCode());
        ErrorDetail error4 = (ErrorDetail)errors.get(3);
        CompoundExtendParserTest.assertEquals((String)"Error.DesignParserException.VIRTUAL_PARENT_NOT_FOUND", (String)error4.getErrorCode());
        this.save();
        this.compareFile(GOLDEN_FILE2);
    }

    public void testSemanticWarning2() {
        try {
            this.openDesign(semanticErrorCheckFileName, ULocale.ENGLISH);
        }
        catch (DesignFileException e) {
            List errors = e.getErrorList();
            CompoundExtendParserTest.assertEquals((int)4, (int)errors.size());
            CompoundExtendParserTest.assertEquals((String)"Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN", (String)((ErrorDetail)errors.get(0)).getErrorCode());
            CompoundExtendParserTest.assertEquals((String)"Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN", (String)((ErrorDetail)errors.get(1)).getErrorCode());
            CompoundExtendParserTest.assertEquals((String)"Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN", (String)((ErrorDetail)errors.get(2)).getErrorCode());
            CompoundExtendParserTest.assertEquals((String)"Error.PropertyValueException.PROPERTY_CHANGE_FORBIDDEN", (String)((ErrorDetail)errors.get(3)).getErrorCode());
        }
    }

    public void testWriter() throws Exception {
        this.openDesign(INPUT1, ULocale.ENGLISH);
        TableHandle bodyTable = (TableHandle)this.designHandle.findElement("table1");
        CompoundExtendParserTest.assertEquals((String)"New Design Table", (String)bodyTable.getCaption());
        RowHandle bodyRow = (RowHandle)bodyTable.getDetail().get(1);
        bodyRow.getPrivateStyle().getColor().setStringValue("fuchsia");
        bodyRow.getHeight().setAbsolute(1.1);
        bodyRow.setBookmark("http://www.eclipse.org/birt");
        CellHandle bodyCell = (CellHandle)bodyRow.getCells().get(0);
        bodyCell.getPrivateStyle().getColor().setStringValue("red");
        TableHandle bodyInnerTable = (TableHandle)bodyCell.getContent().get(0);
        RowHandle bodyInnerRow = (RowHandle)bodyInnerTable.getHeader().get(0);
        CellHandle bodyInnerCell = (CellHandle)bodyInnerRow.getCells().get(0);
        bodyInnerCell.getPrivateStyle().getColor().setStringValue("navy");
        GridHandle grid1 = (GridHandle)this.designHandle.findElement("grid1");
        LabelHandle label1 = (LabelHandle)((CellHandle)((RowHandle)grid1.getRows().get(0)).getCells().get(0)).getContent().get(0);
        label1.setName("new label");
        label1.setStyleName("style1");
        this.save();
        CompoundExtendParserTest.assertTrue((boolean)this.compareFile(GOLDEN_FILE));
    }
}

