/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.MemberHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.StructureHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.metadata.DimensionValue;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ChoiceParseTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign("ChoiceParseTest.xml");
        ChoiceParseTest.assertNotNull((Object)this.design);
    }

    public void testChoiceWithProperty() throws Exception {
        StyleElement myStyle = this.design.findStyle("MyStyle");
        ChoiceParseTest.assertNotNull((Object)myStyle);
        StyleHandle styleHandle = (StyleHandle)myStyle.getHandle((Module)this.design);
        StyleElement style1 = this.design.findStyle("style1");
        ChoiceParseTest.assertNotNull((Object)style1);
        ChoiceParseTest.assertEquals((String)"x-small", (String)styleHandle.getFontSize().getStringValue());
        styleHandle.getFontSize().setStringValue("xx-small");
        ChoiceParseTest.assertEquals((String)"normal", (String)styleHandle.getFontWeight());
        styleHandle.setFontWeight("400");
        ChoiceParseTest.assertEquals((String)"400", (String)styleHandle.getFontWeight());
        styleHandle.setFontWeight("lighter");
        try {
            styleHandle.setFontWeight("450");
            ChoiceParseTest.fail();
        }
        catch (PropertyValueException e) {
            ChoiceParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        styleHandle = (StyleHandle)style1.getHandle((Module)this.design);
        style1.getHandle((Module)this.design).setProperty("fontSize", (Object)new DimensionValue(12.0, "mm"));
        ChoiceParseTest.assertEquals((String)"12mm", (String)style1.getHandle((Module)this.design).getStringProperty("fontSize").toString());
        try {
            style1.getHandle((Module)this.design).setProperty("fontSize", (Object)"asdf");
            ChoiceParseTest.fail();
        }
        catch (PropertyValueException e) {
            ChoiceParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.INVALID_VALUE");
        }
        style1.getHandle((Module)this.design).setProperty("fontSize", (Object)new DimensionValue(12.0, "cm"));
        ChoiceParseTest.assertEquals((String)style1.getProperty((Module)this.design, "fontSize").toString(), (String)"12cm");
        Label label2 = (Label)this.design.findElement("label2");
        ChoiceParseTest.assertNotNull((Object)label2);
        label2 = (Label)this.design.findElement("label2");
        ChoiceParseTest.assertNotNull((Object)label2);
        ChoiceParseTest.assertEquals((String)"12mm", (String)label2.getHandle((Module)this.design).getStringProperty("fontSize").toString());
        label2.getHandle((Module)this.design).setProperty("fontSize", (Object)new DimensionValue(12.0, "in"));
        this.save();
        ChoiceParseTest.assertTrue((boolean)this.compareFile("ChoiceParseTest_golden.xml"));
    }

    public void testChoiceWithMember() throws Exception {
        StyleElement myStyle = this.design.findStyle("MyStyle");
        ChoiceParseTest.assertNotNull((Object)myStyle);
        PropertyHandle propHandle = myStyle.getHandle((Module)this.design).getPropertyHandle("mapRules");
        StructureHandle strHandle = propHandle.getAt(0);
        ChoiceParseTest.assertNotNull((Object)strHandle);
        MemberHandle memberHandle = strHandle.getMember("operator");
        ChoiceParseTest.assertEquals((String)memberHandle.getStringValue(), (String)"eq");
        memberHandle.setValue((Object)"is-true");
        ChoiceParseTest.assertEquals((String)memberHandle.getStringValue(), (String)"is-true");
        strHandle = propHandle.getAt(1);
        ChoiceParseTest.assertNotNull((Object)strHandle);
        memberHandle = strHandle.getMember("operator");
        ChoiceParseTest.assertEquals((String)memberHandle.getStringValue(), (String)"like");
        try {
            memberHandle.setValue((Object)"nono");
        }
        catch (PropertyValueException e) {
            ChoiceParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.CHOICE_NOT_FOUND");
        }
        try {
            memberHandle.setIntValue(12);
        }
        catch (PropertyValueException e) {
            ChoiceParseTest.assertEquals((String)e.getErrorCode(), (String)"Error.PropertyValueException.INVALID_VALUE");
        }
        ChoiceParseTest.assertEquals((String)memberHandle.getStringValue(), (String)"like");
    }

    public void testVerticalAlign() throws Exception {
        StyleElement myStyle = this.design.findStyle("MyStyle");
        ChoiceParseTest.assertNotNull((Object)myStyle);
        String verticalAlign = (String)myStyle.getLocalProperty((Module)this.design, "verticalAlign");
        ChoiceParseTest.assertEquals((String)"middle", (String)verticalAlign);
        myStyle = this.design.findStyle("style1");
        verticalAlign = (String)myStyle.getLocalProperty((Module)this.design, "verticalAlign");
        ChoiceParseTest.assertEquals((String)"baseline", (String)verticalAlign);
        TableHandle tableHandle = (TableHandle)this.designHandle.getBody().get(0);
        GroupHandle groupHandle = (GroupHandle)tableHandle.getGroups().get(0);
        RowHandle rowHandle = (RowHandle)groupHandle.getHeader().get(0);
        CellHandle cellHandle = (CellHandle)rowHandle.getCells().get(0);
        verticalAlign = (String)cellHandle.getElement().getLocalProperty((Module)this.design, "verticalAlign");
        ChoiceParseTest.assertEquals((String)"baseline", (String)verticalAlign);
    }
}

