/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.library;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.DataSetHandle;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;
import org.eclipse.birt.report.model.api.ScriptDataSetHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.core.IDesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class LibraryHandleTest
extends BaseTestCase {
    public void testMakeUniqueName() throws Exception {
        this.libraryHandle = this.createLibrary(ULocale.ENGLISH);
        ElementFactory libFactory = this.libraryHandle.getElementFactory();
        TableHandle tableHandle = libFactory.newTableItem(null);
        LibraryHandleTest.assertEquals((String)"NewTable", (String)tableHandle.getName());
        tableHandle = libFactory.newTableItem(null);
        LibraryHandleTest.assertEquals((String)"NewTable1", (String)tableHandle.getName());
        tableHandle = libFactory.newTableItem("NewTable2");
        this.libraryHandle.getComponents().add((DesignElementHandle)tableHandle);
        tableHandle = libFactory.newTableItem("NewTable2");
        LibraryHandleTest.assertEquals((String)"NewTable21", (String)tableHandle.getName());
        this.libraryHandle.getComponents().add((DesignElementHandle)tableHandle);
        tableHandle = this.libraryHandle.getElementFactory().newTableItem(null);
        tableHandle.setName(null);
        LibraryHandleTest.assertNull((Object)tableHandle.getName());
        this.libraryHandle.rename((DesignElementHandle)tableHandle);
        LibraryHandleTest.assertEquals((String)"NewTable", (String)tableHandle.getName());
    }

    public void testGetStyleName() throws Exception {
        this.libraryHandle = this.createLibrary(ULocale.ENGLISH);
        SharedStyleHandle styleHandle = this.libraryHandle.getElementFactory().newStyle(null);
        LibraryHandleTest.assertEquals((String)"NewStyle", (String)styleHandle.getName());
    }

    public void testGetNamePrefix() throws SemanticException, DesignFileException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_namespace_test.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        ImageHandle libImage = (ImageHandle)this.libraryHandle.getComponents().get(0);
        LibraryHandleTest.assertNotNull((Object)libImage);
        ImageHandle designImage = (ImageHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libImage, "newDesignImage");
        this.designHandle.getComponents().add((DesignElementHandle)designImage);
        LibraryHandleTest.assertEquals((String)"image1", (String)libImage.getImageName());
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.image1", (String)designImage.getImageName());
        TableHandle libTable = (TableHandle)this.libraryHandle.getComponents().get(1);
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.dataSet1", (String)libTable.getDataSet().getQualifiedName());
        TableHandle designTable = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libTable, "designTable");
        this.designHandle.getComponents().add((DesignElementHandle)designTable);
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.dataSet1", (String)designTable.getDataSet().getQualifiedName());
        ScriptDataSetHandle dataSet = this.designHandle.getElementFactory().newScriptDataSet("scriptDataSet");
        this.designHandle.getDataSets().add((DesignElementHandle)dataSet);
        designTable.setDataSet((DataSetHandle)dataSet);
        LibraryHandleTest.assertEquals((Object)"scriptDataSet", (Object)designTable.getProperty("dataSet"));
        ScalarParameterHandle libParameter = (ScalarParameterHandle)this.libraryHandle.getParameters().get(0);
        LibraryHandleTest.assertNotNull((Object)libParameter);
        ScalarParameterHandle designParameter = (ScalarParameterHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libParameter, "designParameter");
        this.designHandle.getParameters().add((DesignElementHandle)designParameter);
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.dataSet1", (String)designParameter.getDataSetName());
    }

    public void testGetQualifiedName() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_2.xml", "libraryNameSpace");
        List list = this.designHandle.getAllDataSets();
        LibraryHandleTest.assertEquals((int)1, (int)list.size());
        list = this.designHandle.getAllDataSources();
        LibraryHandleTest.assertEquals((int)1, (int)list.size());
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        list = this.libraryHandle.getAllDataSets();
        DataSetHandle dataSet = (DataSetHandle)list.iterator().next();
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.dataSet1", (String)dataSet.getQualifiedName());
        list = this.libraryHandle.getAllDataSources();
        DataSourceHandle dataSource = (DataSourceHandle)list.iterator().next();
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.dataSource1", (String)dataSource.getQualifiedName());
        list = this.designHandle.getAllPages();
        MasterPageHandle page = (MasterPageHandle)list.iterator().next();
        LibraryHandleTest.assertEquals((String)"My Page", (String)page.getQualifiedName());
        list = this.libraryHandle.getAllPages();
        page = (MasterPageHandle)list.get(0);
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.My Page", (String)page.getQualifiedName());
    }

    public void testGetHostHandle() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_2.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        LibraryHandleTest.assertEquals((Object)this.designHandle, (Object)this.libraryHandle.getHostHandle());
    }

    public void testResolvCopyElementFromLibraryToDesign() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_namespace_test.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        DataSetHandle libDataSet = (DataSetHandle)this.libraryHandle.getDataSets().get(0);
        LibraryHandleTest.assertEquals((String)"dataSource1", (String)libDataSet.getDataSourceName());
        DataSetHandle designDataSet = (DataSetHandle)libDataSet.copy().getHandle(this.designHandle.getModule());
        this.designHandle.getDataSets().add((DesignElementHandle)designDataSet);
        LibraryHandleTest.assertEquals((String)"libraryNameSpace.dataSource1", (String)designDataSet.getDataSourceName());
    }

    public void testCopyPaste() throws Exception {
        this.openDesign("DesignCopyPaste.xml");
        TableHandle tHandle = (TableHandle)this.designHandle.findElement("table");
        TableHandle extended = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)tHandle, "extended");
        extended.setHeight(50.0);
        this.designHandle.getBody().paste((DesignElementHandle)extended);
        IDesignElement copied = extended.copy();
        this.designHandle.rename(copied.getHandle((Module)this.design));
        this.designHandle.getBody().paste(copied.getHandle((Module)this.design));
        this.save();
        LibraryHandleTest.assertTrue((boolean)this.compareFile("DesignCopyPaste_golden.xml"));
    }

    public void testCopyPasteLabel() throws Exception {
        this.openLibrary("LibraryWithImage.xml");
        LabelHandle original = this.libraryHandle.getElementFactory().newLabel("original");
        this.libraryHandle.getComponents().add((DesignElementHandle)original);
        LabelHandle copied = (LabelHandle)original.copy().getHandle(this.libraryHandle.getModule());
        this.libraryHandle.rename((DesignElementHandle)copied);
        this.libraryHandle.getComponents().add((DesignElementHandle)copied);
    }

    public void testLibraryNeedsSave() throws Exception {
        this.openDesign("DesignWithSaveStateTest.xml");
        this.openLibrary("LibraryWithSaveStateTest.xml");
        LibraryHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        LabelHandle labelHandle = this.designHandle.getElementFactory().newLabel("new test label");
        this.designHandle.getBody().add((DesignElementHandle)labelHandle);
        LibraryHandleTest.assertTrue((boolean)this.designHandle.getCommandStack().canUndo());
        LibraryHandleTest.assertTrue((boolean)this.designHandle.needsSave());
        ActivityStack stack = (ActivityStack)this.designHandle.getCommandStack();
        this.designHandle.reloadLibrary(this.libraryHandle);
        LibraryHandleTest.assertFalse((boolean)this.designHandle.needsSave());
        LibraryHandleTest.assertFalse((boolean)this.designHandle.getCommandStack().canUndo());
        LibraryHandleTest.assertFalse((boolean)this.designHandle.getCommandStack().canRedo());
        LibraryHandleTest.assertEquals((int)0, (int)stack.getCurrentTransNo());
    }

    public void testLibraryIncludeLibraryWriter() throws Exception {
        this.openLibrary("Library_1.xml");
        this.libraryHandle.includeLibrary("Library_2.xml", "lib2");
        this.saveLibrary();
        LibraryHandleTest.assertTrue((boolean)this.compareFile("LibraryIncludeLibrary_golden.xml"));
    }

    public void testCanEdit() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        List list = this.libraryHandle.getAllDataSets();
        LibraryHandleTest.assertEquals((int)1, (int)list.size());
        DataSetHandle dataSet = (DataSetHandle)list.iterator().next();
        LibraryHandleTest.assertFalse((boolean)dataSet.canEdit());
        DataSourceHandle dataSource = (DataSourceHandle)this.libraryHandle.getAllDataSources().iterator().next();
        LibraryHandleTest.assertFalse((boolean)dataSource.canEdit());
        ThemeHandle theme = (ThemeHandle)this.libraryHandle.getThemes().get(0);
        LibraryHandleTest.assertFalse((boolean)theme.canEdit());
        StyleHandle style = (StyleHandle)theme.getStyles().get(0);
        LibraryHandleTest.assertFalse((boolean)style.canEdit());
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        LabelHandle labelHandle = this.libraryHandle.getElementFactory().newLabel(null);
        LibraryHandleTest.assertFalse((boolean)labelHandle.canEdit());
        labelHandle = this.designHandle.getElementFactory().newLabel(null);
        LibraryHandleTest.assertTrue((boolean)labelHandle.canEdit());
    }

    public void testCanTransformToTemplate() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        TableHandle libTable = (TableHandle)this.libraryHandle.getComponents().get(1);
        LibraryHandleTest.assertFalse((boolean)libTable.canTransformToTemplate());
        TableHandle designTable = (TableHandle)this.designHandle.getElementFactory().newElementFrom((DesignElementHandle)libTable, "designTable");
        LibraryHandleTest.assertNotNull((Object)designTable);
        LabelHandle label = (LabelHandle)((CellHandle)((RowHandle)designTable.getDetail().get(0)).getCells().get(0)).getContent().get(0);
        LibraryHandleTest.assertFalse((boolean)label.canTransformToTemplate());
        LibraryHandleTest.assertTrue((boolean)designTable.canTransformToTemplate());
    }

    public void testCopyPasteAndClearNameSpace() throws Exception {
        this.openDesign("DesignCopyPaste.xml");
        this.libraryHandle = this.designHandle.getLibrary("new_library");
        TableHandle table = (TableHandle)this.libraryHandle.findElement("NewTable");
        TableHandle copiedLibTable = (TableHandle)table.copy().getHandle((Module)this.design);
        this.designHandle.rename((DesignElementHandle)copiedLibTable);
        ElementRefValue refValue = (ElementRefValue)copiedLibTable.getElement().getLocalProperty((Module)this.design, "dataSet");
        LibraryHandleTest.assertNotNull((Object)refValue);
        LibraryHandleTest.assertEquals((String)"new_library", (String)refValue.getLibraryNamespace());
        this.designHandle.getBody().paste((DesignElementHandle)copiedLibTable);
        refValue = (ElementRefValue)copiedLibTable.getElement().getLocalProperty((Module)this.design, "dataSet");
        LibraryHandleTest.assertNotNull((Object)refValue);
        LibraryHandleTest.assertNull((Object)refValue.getLibraryNamespace());
    }

    public void testCanContainCanDrop() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        ThemeHandle theme = (ThemeHandle)this.libraryHandle.getThemes().get(0);
        LibraryHandleTest.assertFalse((boolean)theme.canDrop());
        LibraryHandleTest.assertFalse((boolean)theme.canContain(0, "Style"));
        LibraryHandleTest.assertFalse((boolean)theme.canContain(0, (DesignElementHandle)this.libraryHandle.getElementFactory().newStyle("newCreatedStyle")));
        StyleHandle style = (StyleHandle)theme.getStyles().get(0);
        LibraryHandleTest.assertFalse((boolean)style.canDrop());
        LabelHandle labelHandle = this.libraryHandle.getElementFactory().newLabel(null);
        LibraryHandleTest.assertFalse((boolean)labelHandle.canDrop());
        theme = this.libraryHandle.getElementFactory().newTheme("newCreatedTheme");
        LibraryHandleTest.assertFalse((boolean)theme.canDrop());
        LibraryHandleTest.assertFalse((boolean)theme.canContain(0, "Style"));
        LibraryHandleTest.assertFalse((boolean)theme.canContain(0, (DesignElementHandle)this.libraryHandle.getElementFactory().newStyle("newCreatedStyle")));
    }

    public void testGetLibraryDisplayLabel() throws DesignFileException, SemanticException {
        this.openDesign("DesignWithoutLibrary.xml");
        this.designHandle.includeLibrary("Library_2.xml", "libraryNameSpace");
        this.libraryHandle = this.designHandle.getLibrary("libraryNameSpace");
        LibraryHandleTest.assertEquals((String)"libraryNameSpace", (String)this.libraryHandle.getDisplayLabel());
        LibraryHandleTest.assertEquals((String)"libraryNameSpace", (String)this.libraryHandle.getDisplayLabel(0));
        LibraryHandleTest.assertEquals((String)"libraryNameSpace", (String)this.libraryHandle.getDisplayLabel(1));
        LibraryHandleTest.assertEquals((String)"libraryNameSpace", (String)this.libraryHandle.getDisplayLabel(2));
    }

    public void testFindLibrary() throws Exception {
        this.openDesign("DesignWithRelativePathLibrary.xml");
        this.libraryHandle = this.designHandle.findLibrary("../golden/LibraryParseTest_golden.xml");
        LibraryHandleTest.assertNotNull((Object)this.libraryHandle);
        LibraryHandle libToCompare = this.designHandle.findLibrary(this.design.findResource("../golden/LibraryParseTest_golden.xml", 2).toExternalForm());
        LibraryHandleTest.assertNotNull((Object)libToCompare);
        LibraryHandleTest.assertSame((Object)libToCompare, (Object)this.libraryHandle);
    }
}

