/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportDesignCacheTest
extends BaseTestCase {
    public void testClearCacheFlag() throws Exception {
        this.createDesign();
        this.designHandle.cacheValues();
        ReportDesignCacheTest.assertTrue((boolean)this.design.isCached());
        LabelHandle label = this.designHandle.getElementFactory().newLabel("newLabel");
        this.designHandle.getBody().add((DesignElementHandle)label);
        ReportDesignCacheTest.assertFalse((boolean)this.design.isCached());
        this.designHandle.cacheValues();
        ReportDesignCacheTest.assertTrue((boolean)this.design.isCached());
        label.setText("abc");
        ReportDesignCacheTest.assertFalse((boolean)this.design.isCached());
    }

    public void testCacheStyles() throws Exception {
        this.createDesign();
        SharedStyleHandle tmpStyle = this.designHandle.getElementFactory().newStyle("style1");
        this.designHandle.getStyles().add((DesignElementHandle)tmpStyle);
        tmpStyle.setProperty("color", (Object)"red");
        LabelHandle label = this.designHandle.getElementFactory().newLabel("newLabel");
        label.setStyle(tmpStyle);
        this.designHandle.getBody().add((DesignElementHandle)label);
        this.designHandle.cacheValues();
        ReportDesignCacheTest.assertTrue((boolean)this.design.isCached());
        ReportDesignCacheTest.assertEquals((String)"red", (String)label.getStringProperty("color"));
    }
}

