/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.AbstractElementRecord;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.activity.ActivityTestUtil;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.NotificationRecordTask;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.OdaDataSourceHandle;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.api.activity.NotificationEvent;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.core.Listener;
import org.eclipse.birt.report.model.api.elements.table.LayoutTableModel;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ActivityStackTest
extends BaseTestCase {
    MockupActivityRecord record = null;
    ActivityStack as = null;
    MockupDesignElement designElement = null;
    private static final String mockupLabel = "MockupActivityRecord";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.designElement = new MockupDesignElement();
        this.record = new MockupActivityRecord(this.designElement);
        this.as = new ActivityStack(null);
    }

    @Override
    protected void tearDown() throws Exception {
        this.designElement = null;
        this.record = null;
        this.as = null;
    }

    public void testExecute() {
        ActivityStackTest.assertEquals((int)0, (int)this.record.getState());
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.record.executed);
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.record.sendNotification);
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((int)1, (int)this.record.getState());
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.record.executed);
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.record.sendNotification);
        ActivityStackTest.assertEquals((int)1, (int)this.designElement.counter);
        this.record = new MockupActivityRecord(this.designElement);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((int)2, (int)this.designElement.counter);
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
        this.as.undo();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canRedo());
        this.record = new MockupActivityRecord(this.designElement);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.startTrans(null);
        this.record = new MockupActivityRecord(this.designElement);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        ActivityStackTest.assertEquals((int)3, (int)this.designElement.counter);
        this.as.commit();
    }

    public void testUndo() {
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((int)1, (int)this.designElement.counter);
        this.as.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
    }

    public void testRedo() {
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((int)1, (int)this.designElement.counter);
        this.as.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.as.redo();
        ActivityStackTest.assertEquals((int)1, (int)this.designElement.counter);
    }

    public void testCanUndo() {
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
        this.as.undo();
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.startTrans("Trans1");
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement));
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.commit();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
    }

    public void testCanRedo() {
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.undo();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canRedo());
        this.as.redo();
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.startTrans("Tran2");
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement));
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.commit();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
    }

    public void testFlush() {
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.flush();
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement));
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
        this.as.undo();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canRedo());
        this.as.flush();
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
    }

    public void testGetRecords() {
        ActivityStackTest.assertEquals((int)0, (int)this.as.getRecords().length);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        ActivityStackTest.assertEquals((int)1, (int)this.as.getRecords().length);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        ActivityStackTest.assertEquals((int)2, (int)this.as.getRecords().length);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 3));
        ActivityStackTest.assertEquals((int)3, (int)this.as.getRecords().length);
        ActivityStackTest.assertEquals((int)1, (int)((MockupActivityRecord)((Object)this.as.getRecords()[0])).activityID);
        ActivityStackTest.assertEquals((int)2, (int)((MockupActivityRecord)((Object)this.as.getRecords()[1])).activityID);
        ActivityStackTest.assertEquals((int)3, (int)((MockupActivityRecord)((Object)this.as.getRecords()[2])).activityID);
    }

    public void testSetStackLimit() {
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.record = new MockupActivityRecord(this.designElement);
        this.as.execute((IActivityRecord)this.record);
        this.record = new MockupActivityRecord(this.designElement);
        this.as.execute((IActivityRecord)this.record);
        this.record = new MockupActivityRecord(this.designElement);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((int)3, (int)this.as.getRecords().length);
        this.as.setStackLimit(2);
        ActivityStackTest.assertEquals((int)2, (int)this.as.getRecords().length);
    }

    public void testGetRedoRecord() {
        ActivityStackTest.assertNull((Object)this.as.getRedoRecord());
        this.as.execute((IActivityRecord)this.record);
        this.as.undo();
        ActivityStackTest.assertEquals((Object)((Object)this.record), (Object)this.as.getRedoRecord());
    }

    public void testGetUndoRecord() {
        ActivityStackTest.assertNull((Object)this.as.getUndoRecord());
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((Object)((Object)this.record), (Object)this.as.getUndoRecord());
    }

    public void testGetUndoLabel() {
        ActivityStackTest.assertNull((Object)this.as.getUndoLabel());
        this.record.setLabel(mockupLabel);
        this.as.execute((IActivityRecord)this.record);
        ActivityStackTest.assertEquals((String)mockupLabel, (String)this.as.getUndoLabel());
    }

    public void testGetRedoLabel() {
        ActivityStackTest.assertNull((Object)this.as.getRedoLabel());
        this.record.setLabel(mockupLabel);
        this.as.execute((IActivityRecord)this.record);
        this.as.undo();
        ActivityStackTest.assertEquals((String)mockupLabel, (String)this.as.getRedoLabel());
    }

    public void teststartTrans() {
        this.as.execute((IActivityRecord)this.record);
        this.as.undo();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canRedo());
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.as.startTrans(null);
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canRedo());
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        ActivityStackTest.assertEquals((int)2, (int)this.designElement.counter);
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.commit();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
        this.as.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        this.as.commit();
        ActivityStackTest.assertEquals((boolean)false, (boolean)this.as.canUndo());
        this.as.commit();
        ActivityStackTest.assertEquals((boolean)true, (boolean)this.as.canUndo());
    }

    public void testGetCurrentTransNo() {
        ActivityStackTest.assertEquals((int)0, (int)this.as.getCurrentTransNo());
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        ActivityStackTest.assertEquals((int)2, (int)this.as.getCurrentTransNo());
        this.as.undo();
        ActivityStackTest.assertEquals((int)1, (int)this.as.getCurrentTransNo());
        this.as.redo();
        ActivityStackTest.assertEquals((int)2, (int)this.as.getCurrentTransNo());
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 3));
        ActivityStackTest.assertEquals((int)3, (int)this.as.getCurrentTransNo());
    }

    public void testNotification() {
        MockupDesignElement container = new MockupDesignElement();
        CoreTestUtil.setContainer((DesignElement)this.designElement, (DesignElement)container, (int)1);
        MyActivityStackListener listener = new MyActivityStackListener();
        this.as.addListener((ActivityStackListener)listener);
        MyElementListener elementListener = new MyElementListener();
        this.designElement.addListener(elementListener);
        MockupActivityRecord record1 = new MockupActivityRecord(this.designElement, 1);
        this.as.execute((IActivityRecord)record1);
        ActivityStackTest.assertEquals((int)1, (int)listener.action);
        listener.action = -1;
        this.as.undo();
        ActivityStackTest.assertEquals((int)3, (int)listener.action);
        listener.action = -1;
        this.as.redo();
        ActivityStackTest.assertEquals((int)2, (int)listener.action);
        record1 = new MockupActivityRecord(this.designElement, 1);
        MockupActivityRecord record2 = new MockupActivityRecord(this.designElement, 2);
        listener.action = -1;
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)record1);
        this.as.execute((IActivityRecord)record2);
        this.as.commit();
        ActivityStackTest.assertEquals((int)1, (int)listener.action);
        listener.action = -1;
        this.as.undo();
        ActivityStackTest.assertEquals((int)3, (int)listener.action);
        listener.action = -1;
        this.as.redo();
        ActivityStackTest.assertEquals((int)2, (int)listener.action);
        record1 = new MockupActivityRecord(this.designElement, 1);
        record2 = new MockupActivityRecord(this.designElement, 2);
        listener.action = -1;
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)record1);
        this.as.execute((IActivityRecord)record2);
        this.as.startTrans(null);
        record1 = new MockupActivityRecord(this.designElement, 1);
        this.as.execute((IActivityRecord)record1);
        this.as.rollback();
        ActivityStackTest.assertEquals((int)-1, (int)listener.action);
        this.as.rollback();
        ActivityStackTest.assertEquals((int)4, (int)listener.action);
    }

    public void testRedoUndoStack() {
        MockupActivityRecord record1 = new MockupActivityRecord(this.designElement, 1);
        this.as.execute((IActivityRecord)record1);
        ActivityStackTest.assertNull((Object)this.as.getRedoRecord());
        ActivityStackTest.assertNotNull((Object)this.as.getUndoRecord());
        this.as.undo();
        record1 = new MockupActivityRecord(this.designElement, 1);
        this.as.execute((IActivityRecord)record1);
        ActivityStackTest.assertNull((Object)this.as.getRedoRecord());
        ActivityStackTest.assertNotNull((Object)this.as.getUndoRecord());
        this.as.undo();
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        ActivityStackTest.assertEquals((int)2, (int)this.designElement.counter);
        ActivityStackTest.assertNotNull((Object)this.as.getRedoRecord());
        this.as.commit();
        ActivityStackTest.assertNull((Object)this.as.getRedoRecord());
        this.as.undo();
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        ActivityStackTest.assertEquals((int)2, (int)this.designElement.counter);
        ActivityStackTest.assertNotNull((Object)this.as.getRedoRecord());
        ActivityRecord record = (ActivityRecord)this.as.getRedoRecord();
        int transNo = record.getTransNo();
        this.as.rollback();
        ActivityStackTest.assertNotNull((Object)this.as.getRedoRecord());
        record = (ActivityRecord)this.as.getRedoRecord();
        ActivityStackTest.assertEquals((int)transNo, (int)record.getTransNo());
        ActivityStackTest.assertEquals((int)0, (int)this.designElement.counter);
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 1));
        this.as.startTrans(null);
        this.as.execute((IActivityRecord)new MockupActivityRecord(this.designElement, 2));
        ActivityStackTest.assertNotNull((Object)this.as.getRedoRecord());
        record = (ActivityRecord)this.as.getRedoRecord();
        transNo = record.getTransNo();
        this.as.commit();
        ActivityStackTest.assertNotNull((Object)this.as.getRedoRecord());
        record = (ActivityRecord)this.as.getRedoRecord();
        ActivityStackTest.assertEquals((int)transNo, (int)record.getTransNo());
        this.as.rollback();
        ActivityStackTest.assertNotNull((Object)this.as.getRedoRecord());
        record = (ActivityRecord)this.as.getRedoRecord();
        ActivityStackTest.assertEquals((int)transNo, (int)record.getTransNo());
    }

    public void testPersistentTransaction() throws Exception {
        this.createDesign();
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid", 3, 3);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        ActivityStack stack = this.designHandle.getModule().getActivityStack();
        stack.flush();
        stack.startTrans(null);
        grid.setComments("comments for grid");
        grid.setOnCreate("on create");
        stack.startPersistentTrans();
        grid.setName("New grid");
        stack.commit();
        stack.rollbackAll();
        ActivityStackTest.assertEquals((String)"New grid", (String)grid.getName());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        grid.clearAllProperties();
        stack.flush();
        stack.startTrans(null);
        grid.setComments("comments for grid");
        grid.setOnCreate("on create");
        stack.startPersistentTrans();
        grid.setName("New grid");
        stack.commit();
        stack.rollback();
        ActivityStackTest.assertEquals((String)"New grid", (String)grid.getName());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        grid.clearAllProperties();
        stack.flush();
        stack.startTrans(null);
        grid.setComments("comments for grid");
        grid.setOnCreate("on create");
        stack.startPersistentTrans();
        grid.setName("New grid");
        grid.setHeight(12.0);
        stack.commit();
        stack.rollback();
        ActivityStackTest.assertEquals((String)"New grid", (String)grid.getName());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        grid.clearAllProperties();
        stack.flush();
        stack.startTrans(null);
        grid.setComments("comments for grid");
        grid.setOnCreate("on create");
        stack.startPersistentTrans();
        grid.setName("New grid");
        grid.setHeight(12.0);
        stack.commit();
        stack.rollbackAll();
        ActivityStackTest.assertEquals((String)"New grid", (String)grid.getName());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        grid.clearAllProperties();
        stack.flush();
        stack.startTrans(null);
        grid.setComments("comments for grid");
        grid.setOnCreate("on create");
        stack.startPersistentTrans();
        grid.setName("New grid");
        grid.setHeight(12.0);
        stack.rollback();
        stack.commit();
        ActivityStackTest.assertNull((Object)grid.getName());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
    }

    public void testPersistentTransactionUndo() throws ContentException, NameException {
        this.createDesign();
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("mytable");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        OdaDataSetHandle dataset = this.designHandle.getElementFactory().newOdaDataSet("dataset", null);
        OdaDataSourceHandle datasource = this.designHandle.getElementFactory().newOdaDataSource("datasource", null);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        ActivityStack stack = this.designHandle.getModule().getActivityStack();
        stack.flush();
        stack.startTrans(null);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        stack.startTrans(null);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        stack.startTrans(null);
        this.designHandle.getComponents().add((DesignElementHandle)label);
        stack.startPersistentTrans();
        this.designHandle.getBody().add((DesignElementHandle)table);
        stack.commit();
        stack.startPersistentTrans();
        this.designHandle.getDataSets().add((DesignElementHandle)dataset);
        stack.startPersistentTrans();
        this.designHandle.getDataSources().add((DesignElementHandle)datasource);
        stack.commit();
        stack.rollback();
        stack.commit();
        stack.rollback();
        stack.commit();
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        ActivityStackTest.assertEquals((Object)style, (Object)this.designHandle.getStyles().get(0));
        ActivityStackTest.assertEquals((Object)table, (Object)this.designHandle.getBody().get(0));
        ActivityStackTest.assertEquals((Object)datasource, (Object)this.designHandle.getDataSources().get(0));
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getComponents().getCount());
        ActivityStackTest.assertEquals(null, (Object)this.designHandle.getDataSets().get(0));
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getDataSources().getCount());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getBody().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getStyles().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertFalse((boolean)stack.canUndo());
    }

    public void testPersistentTransactionUndo2() throws ContentException, NameException {
        this.createDesign();
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("mytable");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        OdaDataSetHandle dataset = this.designHandle.getElementFactory().newOdaDataSet("dataset", null);
        OdaDataSourceHandle datasource = this.designHandle.getElementFactory().newOdaDataSource("datasource", null);
        ActivityStack stack = this.designHandle.getModule().getActivityStack();
        stack.flush();
        stack.startTrans(null);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        stack.startTrans(null);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        stack.startPersistentTrans();
        this.designHandle.getBody().add((DesignElementHandle)table);
        stack.commit();
        stack.startPersistentTrans();
        this.designHandle.getDataSets().add((DesignElementHandle)dataset);
        stack.startPersistentTrans();
        this.designHandle.getDataSources().add((DesignElementHandle)datasource);
        stack.commit();
        stack.rollback();
        stack.rollback();
        stack.commit();
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        ActivityStackTest.assertEquals((Object)style, (Object)this.designHandle.getStyles().get(0));
        ActivityStackTest.assertEquals((Object)table, (Object)this.designHandle.getBody().get(0));
        ActivityStackTest.assertEquals((Object)datasource, (Object)this.designHandle.getDataSources().get(0));
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getComponents().getCount());
        ActivityStackTest.assertEquals(null, (Object)this.designHandle.getDataSets().get(0));
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getDataSources().getCount());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getBody().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getStyles().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertFalse((boolean)stack.canUndo());
    }

    public void testPersistentTransactionUndo3() throws ContentException, NameException {
        this.createDesign();
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("mytable");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        OdaDataSetHandle dataset = this.designHandle.getElementFactory().newOdaDataSet("dataset", null);
        OdaDataSourceHandle datasource = this.designHandle.getElementFactory().newOdaDataSource("datasource", null);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        ActivityStack stack = this.designHandle.getModule().getActivityStack();
        stack.flush();
        stack.startTrans(null);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        stack.startTrans(null);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        stack.startPersistentTrans();
        this.designHandle.getBody().add((DesignElementHandle)table);
        stack.commit();
        stack.startPersistentTrans();
        this.designHandle.getDataSets().add((DesignElementHandle)dataset);
        stack.startPersistentTrans();
        this.designHandle.getDataSources().add((DesignElementHandle)datasource);
        stack.commit();
        stack.startTrans(null);
        this.designHandle.getComponents().add((DesignElementHandle)label);
        stack.commit();
        stack.rollback();
        stack.rollback();
        stack.commit();
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        ActivityStackTest.assertEquals((Object)style, (Object)this.designHandle.getStyles().get(0));
        ActivityStackTest.assertEquals((Object)table, (Object)this.designHandle.getBody().get(0));
        ActivityStackTest.assertEquals((Object)datasource, (Object)this.designHandle.getDataSources().get(0));
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getComponents().getCount());
        ActivityStackTest.assertEquals(null, (Object)this.designHandle.getDataSets().get(0));
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getDataSources().getCount());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getBody().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getStyles().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertFalse((boolean)stack.canUndo());
    }

    public void testPersistentTransactionUndo4() throws ContentException, NameException {
        this.createDesign();
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("mytable");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        OdaDataSetHandle dataset = this.designHandle.getElementFactory().newOdaDataSet("dataset", null);
        OdaDataSourceHandle datasource = this.designHandle.getElementFactory().newOdaDataSource("datasource", null);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        ActivityStack stack = this.designHandle.getModule().getActivityStack();
        stack.flush();
        stack.startTrans(null);
        this.designHandle.getStyles().add((DesignElementHandle)style);
        stack.startTrans(null);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        stack.startPersistentTrans();
        this.designHandle.getBody().add((DesignElementHandle)table);
        stack.commit();
        stack.startPersistentTrans();
        this.designHandle.getDataSets().add((DesignElementHandle)dataset);
        stack.startPersistentTrans();
        this.designHandle.getDataSources().add((DesignElementHandle)datasource);
        stack.startTrans(null);
        this.designHandle.getComponents().add((DesignElementHandle)label);
        stack.commit();
        stack.commit();
        stack.rollback();
        stack.rollback();
        stack.commit();
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        ActivityStackTest.assertFalse((boolean)stack.canRedo());
        ActivityStackTest.assertEquals((Object)style, (Object)this.designHandle.getStyles().get(0));
        ActivityStackTest.assertEquals((Object)table, (Object)this.designHandle.getBody().get(0));
        ActivityStackTest.assertEquals((Object)datasource, (Object)this.designHandle.getDataSources().get(0));
        ActivityStackTest.assertEquals((int)1, (int)this.designHandle.getComponents().getCount());
        ActivityStackTest.assertEquals(null, (Object)this.designHandle.getDataSets().get(0));
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getDataSources().getCount());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getBody().getCount());
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getComponents().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
        stack.undo();
        ActivityStackTest.assertEquals((int)0, (int)this.designHandle.getStyles().getCount());
        ActivityStackTest.assertTrue((boolean)stack.canRedo());
        ActivityStackTest.assertFalse((boolean)stack.canUndo());
    }

    public void testPersistentTransactionUndo_1() throws Exception {
        this.createDesign();
        GridHandle grid = this.designHandle.getElementFactory().newGridItem("grid");
        TableHandle table = this.designHandle.getElementFactory().newTableItem("mytable");
        SharedStyleHandle style = this.designHandle.getElementFactory().newStyle("style");
        ActivityStack stack = this.designHandle.getModule().getActivityStack();
        stack.flush();
        stack.startTrans(null);
        this.designHandle.getBody().add((DesignElementHandle)grid);
        stack.startTrans(null);
        this.designHandle.getBody().add((DesignElementHandle)table);
        stack.startPersistentTrans();
        this.designHandle.getStyles().add((DesignElementHandle)style);
        stack.commit();
        stack.rollback();
        stack.rollback();
        ActivityStackTest.assertTrue((boolean)this.designHandle.needsSave());
        ActivityStackTest.assertTrue((boolean)stack.canUndo());
    }

    public void testLayoutTransaction() throws Exception {
        this.createDesign();
        TableHandle table = this.designHandle.getElementFactory().newTableItem("testTable", 3, 1, 1, 1);
        ElementListener elementListener = new ElementListener();
        table.addListener((Listener)elementListener);
        this.designHandle.getBody().add((DesignElementHandle)table);
        table.getColumns().get(0).setProperty("color", (Object)"blue");
        ((ActivityStack)this.designHandle.getCommandStack()).startSilentTrans(null);
        RowHandle row = this.designHandle.getElementFactory().newTableRow(3);
        table.getDetail().add((DesignElementHandle)row);
        ActivityStackTest.assertEquals((int)0, (int)elementListener.notifications.size());
        CellHandle cell = (CellHandle)row.getCells().get(0);
        ActivityStackTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().commit();
        ActivityStackTest.assertEquals((int)2, (int)elementListener.notifications.size());
        ActivityStackTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().undo();
        ActivityStackTest.assertEquals((int)4, (int)elementListener.notifications.size());
        ActivityStackTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().redo();
        ActivityStackTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
        ElementListener rowListener = new ElementListener();
        row.addListener((Listener)rowListener);
        ElementListener cellListener = new ElementListener();
        row.getCells().get(0).addListener((Listener)cellListener);
        row.drop();
        ActivityStackTest.assertEquals((int)0, (int)rowListener.notifications.size());
        ActivityStackTest.assertEquals((int)0, (int)cellListener.notifications.size());
        ActivityStackTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().undo();
        ActivityStackTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
        row.addListener((Listener)rowListener);
        ((ActivityStack)this.designHandle.getCommandStack()).startSilentTrans(null);
        row.drop();
        ActivityStackTest.assertEquals((int)0, (int)rowListener.notifications.size());
        LayoutTableModel model = table.getLayoutModel();
        ActivityStackTest.assertEquals((int)2, (int)model.getLayoutSlotDetail().getRowCount());
        ActivityStackTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        ((ActivityStack)this.designHandle.getCommandStack()).commit();
        ActivityStackTest.assertEquals((int)1, (int)model.getLayoutSlotDetail().getRowCount());
        ((ActivityStack)this.designHandle.getCommandStack()).undo();
        ActivityStackTest.assertEquals((int)2, (int)model.getLayoutSlotDetail().getRowCount());
        ActivityStackTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
        ((ActivityStack)this.designHandle.getCommandStack()).startSilentTrans(null);
        row.drop();
        ActivityStackTest.assertEquals((int)2, (int)model.getLayoutSlotDetail().getRowCount());
        ActivityStackTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        ((ActivityStack)this.designHandle.getCommandStack()).rollback();
        ActivityStackTest.assertEquals((int)2, (int)model.getLayoutSlotDetail().getRowCount());
        ActivityStackTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().startTrans(null);
        RowHandle row1 = this.designHandle.getElementFactory().newTableRow(3);
        RowHandle row2 = this.designHandle.getElementFactory().newTableRow(3);
        cell = (CellHandle)row1.getCells().get(0);
        table.getDetail().add((DesignElementHandle)row1);
        ((ActivityStack)this.designHandle.getCommandStack()).startSilentTrans(null);
        cell = (CellHandle)row2.getCells().get(0);
        table.getDetail().add((DesignElementHandle)row2);
        ActivityStackTest.assertEquals((Object)"black", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().commit();
        ActivityStackTest.assertEquals((Object)"blue", (Object)cell.getProperty("color"));
        this.designHandle.getCommandStack().commit();
    }

    public void testFilterEventTransaction() throws SemanticException {
        this.createDesign();
        ElementListener listener = new ElementListener();
        ElementFactory factory = new ElementFactory(this.designHandle.getModule());
        GridHandle gridHandle = factory.newGridItem("Grid1", 10, 10);
        this.designHandle.addListener((Listener)listener);
        gridHandle.addListener((Listener)listener);
        List columns = gridHandle.getColumns().getContents();
        Iterator iter = columns.iterator();
        while (iter.hasNext()) {
            ((ColumnHandle)iter.next()).addListener((Listener)listener);
        }
        List rows = gridHandle.getRows().getContents();
        for (RowHandle row : rows) {
            List cells = row.getCells().getContents();
            for (CellHandle cell : cells) {
                cell.addListener((Listener)listener);
            }
            row.addListener((Listener)listener);
        }
        this.designHandle.getBody().add((DesignElementHandle)gridHandle);
        listener.restart();
        gridHandle.drop();
        ActivityStackTest.assertEquals((int)124, (int)listener.notifications.size());
        listener.restart();
        this.designHandle.addListener((Listener)listener);
        gridHandle.addListener((Listener)listener);
        this.designHandle.getCommandStack().undo();
        ActivityStackTest.assertEquals((int)144, (int)listener.notifications.size());
    }

    public void testNestedFilterEventTransaction() throws SemanticException {
        GridHandle grid;
        TableHandle table;
        ElementListener listener;
        block2: {
            this.createDesign();
            listener = new ElementListener();
            ElementFactory factory = new ElementFactory(this.designHandle.getModule());
            table = factory.newTableItem("newTable");
            grid = factory.newGridItem("newGrid");
            try {
                this.designHandle.getBody().add((DesignElementHandle)table);
                this.designHandle.getBody().add((DesignElementHandle)grid);
            }
            catch (ContentException | NameException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.designHandle.addListener((Listener)listener);
        ActivityStack stack = (ActivityStack)this.designHandle.getCommandStack();
        stack.startTrans(null);
        stack.startFilterEventTrans("drop table");
        table.drop();
        stack.startFilterEventTrans("drop grids");
        grid.drop();
        stack.commit();
        ActivityStackTest.assertEquals((int)0, (int)listener.notifications.size());
        stack.commit();
        ActivityStackTest.assertEquals((int)4, (int)listener.notifications.size());
        stack.commit();
        ActivityStackTest.assertEquals((int)8, (int)listener.notifications.size());
    }

    public void testDispose() {
        MyActivityStackListener listener = new MyActivityStackListener();
        this.as.addListener((ActivityStackListener)listener);
        this.as.execute((IActivityRecord)this.record);
        this.as.undo();
        this.as.startTrans(null);
        this.as.clearListeners();
        this.as.flush();
        ActivityStackTest.assertFalse((boolean)this.as.canRedo());
        ActivityStackTest.assertFalse((boolean)this.as.canUndo());
        ActivityStackTest.assertEquals((int)0, (int)this.as.getRecords().length);
        ActivityStackTest.assertNull((Object)ActivityTestUtil.getActivityListener((ActivityStack)this.as));
    }

    private static class ElementListener
    implements Listener {
        List notifications = new ArrayList();

        private ElementListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.notifications.add(new Notification(focus, ev));
        }

        public void restart() {
            this.notifications.clear();
        }

        public static class Notification {
            Notification(DesignElementHandle element, NotificationEvent event) {
            }
        }
    }

    class MockupActivityRecord
    extends AbstractElementRecord {
        boolean executed = false;
        boolean sendNotification = false;
        boolean canUndo = false;
        boolean canRedo = false;
        MockupDesignElement target = null;
        int activityID;

        public MockupActivityRecord(MockupDesignElement target, int activityID) {
            this.target = target;
            this.activityID = activityID;
        }

        public MockupActivityRecord(MockupDesignElement target) {
            this.target = target;
        }

        public void execute() {
            this.executed = true;
            this.target.increase();
            this.canUndo = true;
            this.canRedo = false;
        }

        public void undo() {
            if (this.canUndo) {
                this.target.decrease();
                this.canRedo = true;
                this.canUndo = false;
            }
        }

        public void redo() {
            if (this.canRedo) {
                this.target.increase();
                this.canUndo = true;
                this.canRedo = false;
            }
        }

        public DesignElement getTarget() {
            return this.target;
        }

        public NotificationEvent getEvent() {
            return new MockupEvent();
        }

        protected List getPostTasks() {
            this.sendNotification = true;
            ArrayList<NotificationRecordTask> retList = new ArrayList<NotificationRecordTask>();
            retList.add(new NotificationRecordTask((DesignElement)this.target, this.getEvent()));
            return retList;
        }

        public void rollback() {
            this.undo();
        }

        protected final boolean holdEvent(Stack transStack) {
            CompoundRecord cr;
            return transStack != null && !transStack.isEmpty() && (cr = (CompoundRecord)transStack.peek()) instanceof FilterEventsCompoundRecord;
        }
    }

    class MockupDesignElement
    extends DesignElement {
        private int counter = 0;

        MockupDesignElement() {
        }

        public void increase() {
            ++this.counter;
        }

        public void decrease() {
            --this.counter;
        }

        public void apply(ElementVisitor visitor) {
        }

        public String getElementName() {
            return "Table";
        }

        public DesignElementHandle getHandle(Module rootElement) {
            return null;
        }
    }

    class MockupEvent
    extends NotificationEvent {
        MockupEvent() {
        }

        public int getEventType() {
            return 0;
        }
    }

    class MyActivityStackListener
    implements ActivityStackListener {
        ActivityStackEvent event = null;
        int action = -1;

        MyActivityStackListener() {
        }

        public void stackChanged(ActivityStackEvent event) {
            this.event = event;
            this.action = event.getAction();
        }
    }

    class MyElementListener
    implements Listener {
        NotificationEvent event = null;

        MyElementListener() {
        }

        public void elementChanged(DesignElementHandle focus, NotificationEvent ev) {
            this.event = ev;
            ActivityStackTest.assertNotNull((Object)this.event);
        }
    }
}

