/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.parser;

import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.ir.FreeFormItemDesign;
import org.eclipse.birt.report.engine.ir.LabelItemDesign;
import org.eclipse.birt.report.engine.ir.Report;
import org.eclipse.birt.report.engine.parser.ReportParser;

public class LabelItemDesignTest
extends TestCase {
    protected Report report = null;
    protected FreeFormItemDesign freeItem;

    public void setUp() throws Exception {
        String SAMPLE_DESIGN = "labelItem_test.xml";
        InputStream in = ((Object)((Object)this)).getClass().getResourceAsStream(SAMPLE_DESIGN);
        LabelItemDesignTest.assertTrue((in != null ? 1 : 0) != 0);
        ReportParser parser = new ReportParser();
        this.report = parser.parse("", in);
        LabelItemDesignTest.assertTrue((this.report != null ? 1 : 0) != 0);
        LabelItemDesignTest.assertTrue((boolean)this.report.getErrors().isEmpty());
        this.freeItem = (FreeFormItemDesign)this.report.getContent(0);
        LabelItemDesignTest.assertTrue((this.freeItem != null ? 1 : 0) != 0);
    }

    public void tearDown() {
    }

    public void testLabelItem() {
        LabelItemDesign label = (LabelItemDesign)this.freeItem.getItem(0);
        LabelItemDesignTest.assertTrue((label != null ? 1 : 0) != 0);
        LabelItemDesignTest.assertEquals((String)"0cm", (String)label.getX().toString());
        LabelItemDesignTest.assertEquals((String)"10cm", (String)label.getY().toString());
        LabelItemDesignTest.assertEquals((String)"1.2cm", (String)label.getHeight().toString());
        LabelItemDesignTest.assertEquals((String)"10cm", (String)label.getWidth().toString());
        LabelItemDesignTest.assertEquals((String)"myLabel", (String)label.getName());
        LabelItemDesignTest.assertEquals((String)"PAGE HEADER", (String)label.getText());
    }

    public void testLabelAction() {
        LabelItemDesign label = (LabelItemDesign)this.freeItem.getItem(0);
        LabelItemDesignTest.assertTrue((label != null ? 1 : 0) != 0);
        LabelItemDesignTest.assertEquals((String)"http://www.2t.cn", (String)label.getAction().getHyperlink().getScriptText());
    }
}

