/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import junit.framework.TestCase;
import org.eclipse.birt.report.engine.layout.pdf.font.CharSegment;

public class CharSegmentTest
extends TestCase {
    public void testMerge() {
        CharSegmentTest.assertEquals((String)"", (String)this.toString(CharSegment.merge((CharSegment[][])new CharSegment[][]{new CharSegment[0], new CharSegment[0]})));
        CharSegmentTest.assertEquals((String)"1[A]", (String)this.toString(CharSegment.merge((CharSegment[][])new CharSegment[][]{{new CharSegment(1, 1, "A")}, new CharSegment[0]})));
        CharSegmentTest.assertEquals((String)"1[B]", (String)this.toString(CharSegment.merge((CharSegment[][])new CharSegment[][]{new CharSegment[0], {new CharSegment(1, 1, "B")}})));
        CharSegmentTest.assertEquals((String)"0-1[B],2-8[A],9-11[B]", (String)this.toString(CharSegment.merge((CharSegment[][])new CharSegment[][]{{new CharSegment(2, 8, "A")}, {new CharSegment(0, 1, "B"), new CharSegment(3, 3, "B"), new CharSegment(5, 6, "B"), new CharSegment(8, 11, "B")}})));
        CharSegmentTest.assertEquals((String)"0-1[A],2[B],3[A],4[B],5-6[A],7[B],8-11[A]", (String)this.toString(CharSegment.merge((CharSegment[][])new CharSegment[][]{{new CharSegment(0, 1, "A"), new CharSegment(3, 3, "A"), new CharSegment(5, 6, "A"), new CharSegment(8, 11, "A")}, {new CharSegment(2, 8, "B")}})));
    }

    public void testSearch() {
        CharSegment[] segs = new CharSegment[]{new CharSegment(0, 1, "0-1"), new CharSegment(2, 2, "2"), new CharSegment(9, 11, "9-11"), new CharSegment(100, 100, "100")};
        CharSegmentTest.assertEquals((int)-1, (int)CharSegment.search((CharSegment[])segs, (int)-1));
        CharSegmentTest.assertEquals((int)0, (int)CharSegment.search((CharSegment[])segs, (int)0));
        CharSegmentTest.assertEquals((int)0, (int)CharSegment.search((CharSegment[])segs, (int)1));
        CharSegmentTest.assertEquals((int)1, (int)CharSegment.search((CharSegment[])segs, (int)2));
        CharSegmentTest.assertEquals((int)-1, (int)CharSegment.search((CharSegment[])segs, (int)3));
        CharSegmentTest.assertEquals((int)2, (int)CharSegment.search((CharSegment[])segs, (int)9));
        CharSegmentTest.assertEquals((int)2, (int)CharSegment.search((CharSegment[])segs, (int)10));
        CharSegmentTest.assertEquals((int)2, (int)CharSegment.search((CharSegment[])segs, (int)11));
        CharSegmentTest.assertEquals((int)-1, (int)CharSegment.search((CharSegment[])segs, (int)99));
        CharSegmentTest.assertEquals((int)3, (int)CharSegment.search((CharSegment[])segs, (int)100));
        CharSegmentTest.assertEquals((int)-1, (int)CharSegment.search((CharSegment[])segs, (int)101));
    }

    public void testSort() {
        CharSegment[] segs = new CharSegment[]{new CharSegment(10, 100, "10-100"), new CharSegment(4, 4, "4"), new CharSegment(7, 10, "7-10"), new CharSegment(0, 2, "0-2")};
        CharSegment.sort((CharSegment[])segs);
        CharSegmentTest.assertEquals((String)"0-2[0-2],4[4],7-10[7-10],10-100[10-100]", (String)this.toString(segs));
    }

    String toString(CharSegment[] segs) {
        StringBuilder buffer = new StringBuilder();
        int i = 0;
        while (i < segs.length) {
            buffer.append(segs[i].toString());
            buffer.append(",");
            ++i;
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return buffer.toString();
    }
}

