/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api;

import org.eclipse.birt.report.engine.EngineCase;
import org.eclipse.birt.report.engine.api.IReportDocument;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunTask;

public class CancelOnErrorTest
extends EngineCase {
    static final String REPORT_DESIGN_RESOURCE = "org/eclipse/birt/report/engine/api/cancel-on-error.rptdesign";

    public void testCancel() {
        this.copyResource(REPORT_DESIGN_RESOURCE, "design.rptdesign");
        this.removeFile("reportdocument");
        IReportEngine engine = this.createReportEngine();
        try {
            IReportRunnable report = engine.openReportDesign("design.rptdesign");
            IRunTask task = engine.createRunTask(report);
            task.run("reportdocument");
            task.close();
            IReportDocument doc = engine.openReportDocument("reportdocument");
            CancelOnErrorTest.assertEquals((long)3L, (long)doc.getPageCount());
            doc.close();
            task = engine.createRunTask(report);
            task.setErrorHandlingOption(1);
            task.run("reportdocument");
            task.close();
            doc = engine.openReportDocument("reportdocument");
            CancelOnErrorTest.assertTrue((3L > doc.getPageCount() ? 1 : 0) != 0);
            doc.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            CancelOnErrorTest.fail();
        }
        engine.shutdown();
        this.removeFile("design.rptdesign");
        this.removeFile("reportdocument");
    }
}

