/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.script;

import java.util.HashMap;
import junit.framework.TestCase;
import org.eclipse.birt.core.script.NativeJavaList;
import org.eclipse.birt.core.script.NativeJavaMap;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class NativeJavaMapTest
extends TestCase {
    Context cx;
    Scriptable scope;
    boolean hasException;
    NativeJavaList list;
    Integer count = new Integer(0);

    @Before
    public void setUp() throws Exception {
        this.cx = Context.enter();
        this.scope = this.cx.initStandardObjects();
        this.registerBeans();
    }

    @After
    public void tearDown() {
        Context.exit();
    }

    protected Object evaluate(String script) {
        try {
            this.hasException = false;
            return this.cx.evaluateString(this.scope, script, "inline", 1, null);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.hasException = true;
            return null;
        }
    }

    protected void registerBeans() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("a", new Integer(123));
        values.put("b", "STRING");
        values.put("c", new Long(599L));
        values.put("d", "ABC");
        NativeJavaMap map = new NativeJavaMap(this.scope, values, NativeJavaMap.class);
        this.scope.put("params", this.scope, (Object)map);
    }

    @Test
    public void testIn() {
        String script = "value = \"\"; for (var a in params) { value = value.concat(a) };";
        Object res = this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((int)4, (int)res.toString().length());
        script = "value = \"\"; for (var a in params) { value = value.concat( params[a] ); }";
        res = this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((int)15, (int)res.toString().length());
    }

    @Test
    public void testLength() {
        String script = "params.length";
        Object value = this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((int)4, (int)((Number)value).intValue());
    }

    @Test
    public void testNameAccess() {
        String script = "params['a'] + params.b";
        Object value = this.evaluate(script);
        NativeJavaMapTest.assertTrue((!this.hasException ? 1 : 0) != 0);
        NativeJavaMapTest.assertEquals((String)"123STRING", (String)value.toString());
    }
}

