/*
 * Decompiled with CFR 0.152.
 */
package utility;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Method;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import utility.ParserWrapper;

public class DomWriter {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String DEFAULT_PARSER_NAME = "dom.wrappers.Xerces";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected boolean fXML11;

    public DomWriter() {
    }

    public DomWriter(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setCanonical(boolean canonical) {
        this.fCanonical = canonical;
    }

    public void setOutput(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF8";
        }
        OutputStreamWriter writer = new OutputStreamWriter(stream, encoding);
        this.fOut = new PrintWriter(writer);
    }

    public void setOutput(Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void write(Node node) {
        if (node == null) {
            return;
        }
        short type = node.getNodeType();
        switch (type) {
            case 9: {
                Document document = (Document)node;
                this.fXML11 = "1.1".equals(this.getVersion(document));
                if (!this.fCanonical) {
                    if (this.fXML11) {
                        this.fOut.println("<?xml version=\"1.1\" encoding=\"UTF-8\"?>");
                    } else {
                        this.fOut.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    }
                    this.fOut.flush();
                    this.write(document.getDoctype());
                }
                this.write(document.getDocumentElement());
                break;
            }
            case 10: {
                DocumentType doctype = (DocumentType)node;
                this.fOut.print("<!DOCTYPE ");
                this.fOut.print(doctype.getName());
                String publicId = doctype.getPublicId();
                String systemId = doctype.getSystemId();
                if (publicId != null) {
                    this.fOut.print(" PUBLIC '");
                    this.fOut.print(publicId);
                    this.fOut.print("' '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                } else if (systemId != null) {
                    this.fOut.print(" SYSTEM '");
                    this.fOut.print(systemId);
                    this.fOut.print('\'');
                }
                String internalSubset = doctype.getInternalSubset();
                if (internalSubset != null) {
                    this.fOut.println(" [");
                    this.fOut.print(internalSubset);
                    this.fOut.print(']');
                }
                this.fOut.println('>');
                break;
            }
            case 1: {
                this.fOut.print('<');
                this.fOut.print(node.getNodeName());
                Attr[] attrs = this.sortAttributes(node.getAttributes());
                int i = 0;
                while (i < attrs.length) {
                    Attr attr = attrs[i];
                    this.fOut.print(' ');
                    this.fOut.print(attr.getNodeName());
                    this.fOut.print("=\"");
                    this.normalizeAndPrint(attr.getNodeValue(), true);
                    this.fOut.print('\"');
                    ++i;
                }
                this.fOut.print('>');
                this.fOut.flush();
                Node child = node.getFirstChild();
                while (child != null) {
                    this.write(child);
                    child = child.getNextSibling();
                }
                break;
            }
            case 5: {
                if (this.fCanonical) {
                    Node child = node.getFirstChild();
                    while (child != null) {
                        this.write(child);
                        child = child.getNextSibling();
                    }
                    break;
                }
                this.fOut.print('&');
                this.fOut.print(node.getNodeName());
                this.fOut.print(';');
                this.fOut.flush();
                break;
            }
            case 4: {
                if (this.fCanonical) {
                    this.normalizeAndPrint(node.getNodeValue(), false);
                } else {
                    this.fOut.print("<![CDATA[");
                    this.fOut.print(node.getNodeValue());
                    this.fOut.print("]]>");
                }
                this.fOut.flush();
                break;
            }
            case 3: {
                this.normalizeAndPrint(node.getNodeValue(), false);
                this.fOut.flush();
                break;
            }
            case 7: {
                this.fOut.print("<?");
                this.fOut.print(node.getNodeName());
                String data = node.getNodeValue();
                if (data != null && data.length() > 0) {
                    this.fOut.print(' ');
                    this.fOut.print(data);
                }
                this.fOut.print("?>");
                this.fOut.flush();
                break;
            }
            case 8: {
                if (this.fCanonical) break;
                this.fOut.print("<!--");
                String comment = node.getNodeValue();
                if (comment != null && comment.length() > 0) {
                    this.fOut.print(comment);
                }
                this.fOut.print("-->");
                this.fOut.flush();
            }
        }
        if (type == 1) {
            this.fOut.print("</");
            this.fOut.print(node.getNodeName());
            this.fOut.print('>');
            this.fOut.flush();
        }
    }

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        i = 0;
        while (i < len - 1) {
            String name = array[i].getNodeName();
            int index = i;
            int j = i + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i) {
                Attr temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            ++i;
        }
        return array;
    }

    protected void normalizeAndPrint(String s, boolean isAttValue) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char c = s.charAt(i);
            this.normalizeAndPrint(c, isAttValue);
            ++i;
        }
    }

    protected void normalizeAndPrint(char c, boolean isAttValue) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (isAttValue) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || isAttValue && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected String getVersion(Document document) {
        if (document == null) {
            return null;
        }
        String version = null;
        Method getXMLVersion = null;
        try {
            getXMLVersion = document.getClass().getMethod("getXmlVersion", new Class[0]);
            if (getXMLVersion != null) {
                version = (String)getXMLVersion.invoke((Object)document, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return version;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            System.exit(1);
        }
        DomWriter writer = null;
        ParserWrapper parser = null;
        boolean namespaces = true;
        boolean validation = false;
        boolean externalDTD = true;
        boolean schemaValidation = false;
        boolean schemaFullChecking = false;
        boolean honourAllSchemaLocations = false;
        boolean validateAnnotations = false;
        boolean generateSyntheticAnnotations = false;
        boolean dynamicValidation = false;
        boolean xincludeProcessing = false;
        boolean xincludeFixupBaseURIs = true;
        boolean xincludeFixupLanguage = true;
        boolean canonical = false;
        int i = 0;
        while (i < argv.length) {
            block41: {
                String arg;
                block42: {
                    String option;
                    block56: {
                        block55: {
                            block54: {
                                block53: {
                                    block52: {
                                        block51: {
                                            block50: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            block46: {
                                                                block45: {
                                                                    block44: {
                                                                        block43: {
                                                                            arg = argv[i];
                                                                            if (!arg.startsWith("-")) break block42;
                                                                            option = arg.substring(1);
                                                                            if (!option.equals("p")) break block43;
                                                                            if (++i == argv.length) {
                                                                                System.err.println("error: Missing argument to -p option.");
                                                                            }
                                                                            String parserName = argv[i];
                                                                            try {
                                                                                parser = (ParserWrapper)Class.forName(parserName).newInstance();
                                                                            }
                                                                            catch (Exception e) {
                                                                                parser = null;
                                                                                System.err.println("error: Unable to instantiate parser (" + parserName + ")");
                                                                            }
                                                                            break block41;
                                                                        }
                                                                        if (!option.equalsIgnoreCase("n")) break block44;
                                                                        namespaces = option.equals("n");
                                                                        break block41;
                                                                    }
                                                                    if (!option.equalsIgnoreCase("v")) break block45;
                                                                    validation = option.equals("v");
                                                                    break block41;
                                                                }
                                                                if (!option.equalsIgnoreCase("xd")) break block46;
                                                                externalDTD = option.equals("xd");
                                                                break block41;
                                                            }
                                                            if (!option.equalsIgnoreCase("s")) break block47;
                                                            schemaValidation = option.equals("s");
                                                            break block41;
                                                        }
                                                        if (!option.equalsIgnoreCase("f")) break block48;
                                                        schemaFullChecking = option.equals("f");
                                                        break block41;
                                                    }
                                                    if (!option.equalsIgnoreCase("hs")) break block49;
                                                    honourAllSchemaLocations = option.equals("hs");
                                                    break block41;
                                                }
                                                if (!option.equalsIgnoreCase("va")) break block50;
                                                validateAnnotations = option.equals("va");
                                                break block41;
                                            }
                                            if (!option.equalsIgnoreCase("ga")) break block51;
                                            generateSyntheticAnnotations = option.equals("ga");
                                            break block41;
                                        }
                                        if (!option.equalsIgnoreCase("dv")) break block52;
                                        dynamicValidation = option.equals("dv");
                                        break block41;
                                    }
                                    if (!option.equalsIgnoreCase("xi")) break block53;
                                    xincludeProcessing = option.equals("xi");
                                    break block41;
                                }
                                if (!option.equalsIgnoreCase("xb")) break block54;
                                xincludeFixupBaseURIs = option.equals("xb");
                                break block41;
                            }
                            if (!option.equalsIgnoreCase("xl")) break block55;
                            xincludeFixupLanguage = option.equals("xl");
                            break block41;
                        }
                        if (!option.equalsIgnoreCase("c")) break block56;
                        canonical = option.equals("c");
                        break block41;
                    }
                    if (option.equals("h")) break block41;
                }
                if (parser == null) {
                    try {
                        parser = (ParserWrapper)Class.forName(DEFAULT_PARSER_NAME).newInstance();
                    }
                    catch (Exception e) {
                        System.err.println("error: Unable to instantiate parser (dom.wrappers.Xerces)");
                        break block41;
                    }
                }
                try {
                    parser.setFeature(NAMESPACES_FEATURE_ID, namespaces);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                }
                try {
                    parser.setFeature(VALIDATION_FEATURE_ID, validation);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                }
                try {
                    parser.setFeature(LOAD_EXTERNAL_DTD_FEATURE_ID, externalDTD);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                }
                try {
                    parser.setFeature(SCHEMA_VALIDATION_FEATURE_ID, schemaValidation);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                }
                try {
                    parser.setFeature(SCHEMA_FULL_CHECKING_FEATURE_ID, schemaFullChecking);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                }
                try {
                    parser.setFeature(HONOUR_ALL_SCHEMA_LOCATIONS_ID, honourAllSchemaLocations);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                }
                try {
                    parser.setFeature(VALIDATE_ANNOTATIONS_ID, validateAnnotations);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
                }
                try {
                    parser.setFeature(GENERATE_SYNTHETIC_ANNOTATIONS_ID, generateSyntheticAnnotations);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                }
                try {
                    parser.setFeature(DYNAMIC_VALIDATION_FEATURE_ID, dynamicValidation);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                }
                try {
                    parser.setFeature(XINCLUDE_FEATURE_ID, xincludeProcessing);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
                }
                try {
                    parser.setFeature(XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID, xincludeFixupBaseURIs);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                }
                try {
                    parser.setFeature(XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID, xincludeFixupLanguage);
                }
                catch (SAXException e) {
                    System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
                }
                if (writer == null) {
                    writer = new DomWriter();
                    try {
                        writer.setOutput(System.out, "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.err.println("error: Unable to set output. Exiting.");
                        System.exit(1);
                    }
                }
                writer.setCanonical(canonical);
                try {
                    Document document = parser.parse(arg);
                    writer.write(document);
                }
                catch (SAXParseException document) {
                }
                catch (Exception e) {
                    Exception nested;
                    System.err.println("error: Parse error occurred - " + e.getMessage());
                    if (e instanceof SAXException && (nested = ((SAXException)e).getException()) != null) {
                        e = nested;
                    }
                    e.printStackTrace(System.err);
                }
            }
            ++i;
        }
    }
}

