/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.facttable;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.cursor.CubeUtility;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDatasetIterator;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.api.cube.IHierarchy;
import org.eclipse.birt.data.engine.olap.data.api.cube.ILevelDefn;
import org.eclipse.birt.data.engine.olap.data.document.DocumentManagerFactory;
import org.eclipse.birt.data.engine.olap.data.document.IDocumentManager;
import org.eclipse.birt.data.engine.olap.data.impl.NamingUtil;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionFactory;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionForTest;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.LevelDefinition;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTable;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableAccessor;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.FactTableRowIteratorWithFilter;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.LevelsAndFactTableDataset;
import org.eclipse.birt.data.engine.olap.data.util.BufferedPrimitiveDiskArray;
import org.eclipse.birt.data.engine.olap.data.util.IDiskArray;
import org.junit.Assert;
import org.junit.Test;

public class FactTableRowIteratorWithFilterTest {
    private static String[] distinct(String[] sValues) {
        Arrays.sort(sValues);
        ArrayList<String> tempList = new ArrayList<String>();
        tempList.add(sValues[0]);
        int i = 1;
        while (i < sValues.length) {
            if (!sValues[i].equals(sValues[i - 1])) {
                tempList.add(sValues[i]);
            }
            ++i;
        }
        String[] result = new String[tempList.size()];
        int i2 = 0;
        while (i2 < result.length) {
            result[i2] = (String)tempList.get(i2);
            ++i2;
        }
        return result;
    }

    @Test
    public void testFactTableSaveAndLoad1() throws IOException, BirtException {
        IDocumentManager documentManager = DocumentManagerFactory.createFileDocumentManager();
        this.testFactTableSaveAndLoad1(documentManager);
        documentManager.close();
    }

    private void testFactTableSaveAndLoad1(IDocumentManager documentManager) throws IOException, BirtException {
        Dimension[] dimensions = new Dimension[3];
        ILevelDefn[] levelDefs = new ILevelDefn[1];
        String[] levelNames = new String[]{"dimension1"};
        DimensionForTest iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableRowIteratorWithFilterTest.distinct(LevelsAndFactTableDataset.dimension1Col));
        levelDefs[0] = new LevelDefinition("dimension1", new String[]{"dimension1"}, null);
        dimensions[0] = (Dimension)DimensionFactory.createDimension((String)"dimension1", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        IHierarchy hierarchy = dimensions[0].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension1");
        levelNames = new String[]{"dimension2"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableRowIteratorWithFilterTest.distinct(LevelsAndFactTableDataset.dimension2Col));
        levelDefs[0] = new LevelDefinition("dimension2", new String[]{"dimension2"}, null);
        dimensions[1] = (Dimension)DimensionFactory.createDimension((String)"dimension2", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[1].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension2");
        levelNames = new String[]{"dimension3"};
        iterator = new DimensionForTest(levelNames);
        iterator.setLevelMember(0, FactTableRowIteratorWithFilterTest.distinct(LevelsAndFactTableDataset.dimension3Col));
        levelDefs[0] = new LevelDefinition("dimension3", new String[]{"dimension3"}, null);
        dimensions[2] = (Dimension)DimensionFactory.createDimension((String)"dimension3", (IDocumentManager)documentManager, (IDatasetIterator)iterator, (ILevelDefn[])levelDefs, (boolean)false, (StopSign)new StopSign());
        hierarchy = dimensions[2].getHierarchy();
        Assert.assertEquals((Object)hierarchy.getName(), (Object)"dimension3");
        LevelsAndFactTableDataset factTableIterator = new LevelsAndFactTableDataset();
        String[] measureColumnName = new String[]{"measure1", "measure2"};
        FactTableAccessor factTableConstructor = new FactTableAccessor(documentManager);
        FactTable factTable = factTableConstructor.saveFactTable(NamingUtil.getFactTableName((String)"threeDimensions"), CubeUtility.getKeyColNames((IDimension[])dimensions), CubeUtility.getKeyColNames((IDimension[])dimensions), (IDatasetIterator)factTableIterator, dimensions, measureColumnName, new StopSign());
        Assert.assertEquals((long)factTable.getSegmentCount(), (long)1L);
        factTable = factTableConstructor.load(NamingUtil.getFactTableName((String)"threeDimensions"), new StopSign());
        Assert.assertEquals((long)factTable.getSegmentCount(), (long)1L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[0].getDimensionName(), (Object)"dimension1");
        Assert.assertEquals((long)factTable.getDimensionInfo()[0].getDimensionLength(), (long)3L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[1].getDimensionName(), (Object)"dimension2");
        Assert.assertEquals((long)factTable.getDimensionInfo()[1].getDimensionLength(), (long)7L);
        Assert.assertEquals((Object)factTable.getDimensionInfo()[2].getDimensionName(), (Object)"dimension3");
        Assert.assertEquals((long)factTable.getDimensionInfo()[2].getDimensionLength(), (long)14L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[0].getMeasureName(), (Object)"measure1");
        Assert.assertEquals((long)factTable.getMeasureInfo()[0].getDataType(), (long)2L);
        Assert.assertEquals((Object)factTable.getMeasureInfo()[1].getMeasureName(), (Object)"measure2");
        Assert.assertEquals((long)factTable.getMeasureInfo()[1].getDataType(), (long)3L);
        String[] dimensionNames = new String[]{"dimension2"};
        IDiskArray[] dimensionPosition = new IDiskArray[]{new BufferedPrimitiveDiskArray()};
        dimensionPosition[0].add((Object)new Integer(1));
        dimensionPosition[0].add((Object)new Integer(2));
        FactTableRowIterator facttableRowIterator = new FactTableRowIterator(factTable, dimensionNames, dimensionPosition, new StopSign());
        facttableRowIterator = new FactTableRowIteratorWithFilter((IDimension[])dimensions, (IFactTableRowIterator)facttableRowIterator, new StopSign());
        Assert.assertTrue((facttableRowIterator != null ? 1 : 0) != 0);
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)0L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)3L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(121), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(121.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)0L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)4L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(122), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(122.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)5L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(211), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(211.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertTrue((boolean)facttableRowIterator.next());
        Assert.assertEquals((long)1L, (long)facttableRowIterator.getDimensionPosition(0));
        Assert.assertEquals((long)2L, (long)facttableRowIterator.getDimensionPosition(1));
        Assert.assertEquals((long)6L, (long)facttableRowIterator.getDimensionPosition(2));
        Assert.assertEquals((Object)new Integer(212), (Object)facttableRowIterator.getMeasure(0));
        Assert.assertEquals((Object)new Double(212.0), (Object)facttableRowIterator.getMeasure(1));
        Assert.assertFalse((boolean)facttableRowIterator.next());
        facttableRowIterator.close();
    }
}

