/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer.testdriver;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.eclipse.birt.data.engine.odaconsumer.testdriver.TestData;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;

class TestResultSetImpl
implements IResultSet {
    private IResultSetMetaData m_resultSetMetaData = null;
    private int m_currentRow = 0;
    private int m_numRows = 5;
    private int m_maxRows = 0;
    private boolean m_wasNull = false;
    private boolean m_isOpen = true;

    TestResultSetImpl(IQuery query, boolean isSmallResultSet) throws OdaException {
        this.m_resultSetMetaData = query.getMetaData();
        if (isSmallResultSet) {
            this.m_numRows = 1;
        }
    }

    TestResultSetImpl(boolean hasOneRow, IResultSetMetaData rsmd) {
        this.m_resultSetMetaData = rsmd;
        if (hasOneRow) {
            this.m_numRows = 1;
        }
    }

    public void close() throws OdaException {
        this.m_isOpen = false;
    }

    public int findColumn(String columnName) throws OdaException {
        int numCols = this.m_resultSetMetaData.getColumnCount();
        int i = 1;
        while (i <= numCols) {
            String name = this.m_resultSetMetaData.getColumnName(i);
            if (name.equals(columnName)) {
                return i;
            }
            ++i;
        }
        throw new OdaException("Unknown column name : " + columnName);
    }

    public boolean getBoolean(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createBooleanFalseData();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getBoolean(index);
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createBigDecimalData();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getBigDecimal(index);
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getBlob(index);
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getClob(index);
    }

    public Date getDate(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createDateData();
    }

    public Date getDate(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getDate(index);
    }

    public double getDouble(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createDoubleData();
    }

    public double getDouble(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getDouble(index);
    }

    public int getInt(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createIntData();
    }

    public int getInt(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getInt(index);
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        return this.m_resultSetMetaData;
    }

    public int getRow() throws OdaException {
        return this.m_currentRow;
    }

    public String getString(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createStringData();
    }

    public String getString(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getString(index);
    }

    public Time getTime(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createTimeData();
    }

    public Time getTime(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        return this.getTime(index);
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        this.checkColumnIndex(index);
        this.m_wasNull = false;
        return TestData.createTimestampData();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        int index = this.findColumn(columnName);
        this.m_wasNull = false;
        return this.getTimestamp(index);
    }

    public boolean next() throws OdaException {
        if (!this.m_isOpen) {
            throw new OdaException("Result set has been closed.");
        }
        if (this.m_currentRow < this.m_numRows && (this.m_maxRows == 0 || this.m_currentRow < this.m_maxRows)) {
            ++this.m_currentRow;
            return true;
        }
        return false;
    }

    public void setMaxRows(int max) throws OdaException {
        this.m_maxRows = max;
    }

    public boolean wasNull() throws OdaException {
        return this.m_wasNull;
    }

    private void checkColumnIndex(int index) throws OdaException {
        if (index < 1 || index > this.m_resultSetMetaData.getColumnCount()) {
            throw new OdaException("Invalid column index : " + index);
        }
    }

    public Object getObject(int index) throws OdaException {
        return null;
    }

    public Object getObject(String columnName) throws OdaException {
        return null;
    }
}

