/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.ColumnHint;
import org.eclipse.birt.data.engine.odaconsumer.PreparedStatement;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odaconsumer.testutil.OdaTestDriverCase;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

@Ignore(value="Ignore tests that require manual setup")
public class MultipleResultSetsTest
extends OdaTestDriverCase {
    private PreparedStatement getSequentialRSPreparedStatement() throws DataException {
        PreparedStatement hostStmt = this.getOpenedConnection().prepareStatement(null, "3");
        Assert.assertTrue((hostStmt != null ? 1 : 0) != 0);
        return hostStmt;
    }

    @Test
    public void testGetSequentialResultSetMetaData() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            hostStmt.execute();
            this.getSequentialResultSetMetaData(hostStmt, 1);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetSequentialResultSetMetaData failed: " + e1.toString()));
        }
    }

    @Test
    public void testGetMoreResultSetMetaData() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            hostStmt.execute();
            this.getSequentialResultSetMetaData(hostStmt, 3);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetMoreResultSetMetaData failed: " + e1.toString()));
        }
    }

    private void getSequentialResultSetMetaData(PreparedStatement hostStmt, int resultSetNum) throws Exception {
        IResultClass resultClass1 = hostStmt.getMetaData(resultSetNum);
        Assert.assertNotNull((Object)resultClass1);
        IResultClass resultClass2 = hostStmt.getMetaData(resultSetNum);
        Assert.assertEquals((Object)resultClass1, (Object)resultClass2);
        ResultSet rs = hostStmt.getResultSet(resultSetNum);
        resultClass2 = rs.getMetaData();
        Assert.assertEquals((Object)resultClass1, (Object)resultClass2);
    }

    @Test
    public void testGetSequentialResultSet() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            hostStmt.execute();
            this.getSequentialResultSet(hostStmt, 1);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetSequentialResultSet failed: " + e1.toString()));
        }
    }

    @Test
    public void testGetMoreResultSet() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            hostStmt.execute();
            this.getSequentialResultSet(hostStmt, 3);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetMoreResultSet failed: " + e1.toString()));
        }
    }

    private ResultSet getSequentialResultSet(PreparedStatement hostStmt, int resultSetNum) throws Exception {
        ResultSet rs1 = hostStmt.getResultSet(resultSetNum);
        Assert.assertNotNull((Object)rs1);
        ResultSet rs2 = hostStmt.getResultSet(resultSetNum);
        Assert.assertEquals((Object)rs1, (Object)rs2);
        IResultClass resultClass2 = hostStmt.getMetaData(resultSetNum);
        IResultClass resultClass1 = rs1.getMetaData();
        Assert.assertEquals((Object)resultClass1, (Object)resultClass2);
        return rs1;
    }

    private boolean hasCustomColumn(ResultSet rs, String customColumnName) throws Exception {
        IResultClass customMd = rs.getMetaData();
        return customMd.getFieldIndex(customColumnName) > 0;
    }

    @Test
    public void testGetSequentialResultSets() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            hostStmt.execute();
            this.getSequentialResultSet(hostStmt, 2);
            this.getSequentialResultSet(hostStmt, 3);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetSequentialResultSets failed: " + e1.toString()));
        }
    }

    @Test
    public void testGetFirstResultSetWithCustomColumn() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            int resultSetNum = 1;
            String customColumnName = "Custom1";
            hostStmt.declareCustomColumn(resultSetNum, customColumnName, String.class);
            hostStmt.execute();
            IResultClass metadata = hostStmt.getMetaData(resultSetNum);
            Assert.assertTrue((metadata.getFieldIndex(customColumnName) > 0 ? 1 : 0) != 0);
            ResultSet customRs = this.getSequentialResultSet(hostStmt, resultSetNum);
            Assert.assertTrue((boolean)this.hasCustomColumn(customRs, customColumnName));
            customRs = this.getSequentialResultSet(hostStmt, 3);
            Assert.assertFalse((boolean)this.hasCustomColumn(customRs, customColumnName));
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetFirstResultSetWithCustomColumn() failed: " + e1.toString()));
        }
    }

    @Test
    public void testGetSequentialResultSetsWithCustomColumn() throws Exception {
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            int resultSetNum = 2;
            String customColumnName = "Custom1";
            hostStmt.execute();
            hostStmt.declareCustomColumn(resultSetNum, customColumnName, String.class);
            IResultClass metadata = hostStmt.getMetaData(resultSetNum);
            Assert.assertTrue((metadata.getFieldIndex(customColumnName) > 0 ? 1 : 0) != 0);
            ResultSet customRs = this.getSequentialResultSet(hostStmt, resultSetNum);
            Assert.assertTrue((boolean)this.hasCustomColumn(customRs, customColumnName));
            customRs = this.getSequentialResultSet(hostStmt, 3);
            Assert.assertFalse((boolean)this.hasCustomColumn(customRs, customColumnName));
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetSequentialResultSetsWithCustomColumn() failed: " + e1.toString()));
        }
    }

    @Test
    public void testGetSequentialResultSetBeforeExecute() throws Exception {
        boolean hasExpectedException = false;
        try {
            PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
            ResultSet rs1 = hostStmt.getResultSet(2);
            Assert.assertNull((Object)rs1);
            hasExpectedException = true;
        }
        catch (DataException e1) {
            hasExpectedException = true;
        }
        assert (hasExpectedException);
    }

    @Test
    public void testGetOutOfRangeResultSet() throws Exception {
        String methodName = "testGetOutOfRangeResultSet";
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        hostStmt.execute();
        try {
            this.getSequentialResultSet(hostStmt, 2);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetOutOfRangeResultSet failed: " + e1.toString()));
        }
        boolean hasExpectedException = false;
        try {
            this.getSequentialResultSet(hostStmt, 4);
        }
        catch (DataException ex) {
            hasExpectedException = true;
        }
        assert (hasExpectedException);
    }

    @Test
    public void testGetReverseSequenceResultSets() throws Exception {
        String methodName = "testGetReverseSequenceResultSets";
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        hostStmt.execute();
        try {
            this.getSequentialResultSet(hostStmt, 3);
        }
        catch (DataException e1) {
            Assert.fail((String)("testGetReverseSequenceResultSets failed: " + e1.toString()));
        }
        boolean hasExpectedException = false;
        try {
            this.getSequentialResultSet(hostStmt, 1);
        }
        catch (DataException ex) {
            hasExpectedException = true;
        }
        assert (hasExpectedException);
    }

    @Test
    public void testProjectedColumnsResultSet() throws Exception {
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        hostStmt.execute();
        this.getProjectedColumnsResultSet(hostStmt, 2, false);
    }

    @Test
    public void testSetProjectedColumnsOnResultSet1BeforeExecute() throws Exception {
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        this.getProjectedColumnsResultSet(hostStmt, 1, true);
    }

    @Test
    public void testSetProjectedColumnsOnMoreResultSetBeforeExecute() throws Exception {
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        this.getProjectedColumnsResultSet(hostStmt, 3, true);
    }

    @Test
    public void testSetProjectedCustomColumnsOnMoreResultSetBeforeExecute() throws Exception {
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        int resultSetNum = 3;
        hostStmt.declareCustomColumn(resultSetNum, "Custom1", String.class);
        ColumnHint columnHint = new ColumnHint("Custom1");
        columnHint.setAlias("CustomAlias1");
        hostStmt.addColumnHint(resultSetNum, columnHint);
        hostStmt.setColumnsProjection(resultSetNum, new String[]{"StringCol", "CustomAlias1", "IntCol"});
        hostStmt.execute();
        IResultClass metadata1 = hostStmt.getMetaData(resultSetNum);
        Assert.assertNotNull((Object)metadata1);
        ResultSet rs = hostStmt.getResultSet(resultSetNum);
        IResultClass metadata2 = rs.getMetaData();
        Assert.assertEquals((Object)metadata1, (Object)metadata2);
    }

    @Test
    public void testProjectedMoreColumnsResultSetBeforeExecute() throws Exception {
        PreparedStatement hostStmt = this.getSequentialRSPreparedStatement();
        boolean hasExpectedException = false;
        try {
            this.getProjectedColumnsResultSet(hostStmt, 2, false);
        }
        catch (DataException ex) {
            hasExpectedException = true;
        }
        assert (hasExpectedException);
    }

    private void getProjectedColumnsResultSet(PreparedStatement hostStmt, int resultSetNum, boolean executeAfterSetProjections) throws Exception {
        hostStmt.setColumnsProjection(resultSetNum, this.getTestProjectedColumns());
        if (executeAfterSetProjections) {
            hostStmt.execute();
        }
        IResultClass metadata1 = hostStmt.getMetaData(resultSetNum);
        Assert.assertNotNull((Object)metadata1);
        ResultSet rs = hostStmt.getResultSet(resultSetNum);
        IResultClass metadata2 = rs.getMetaData();
        Assert.assertEquals((Object)metadata1, (Object)metadata2);
    }

    private String[] getTestProjectedColumns() {
        return new String[]{"StringCol", "IntCol"};
    }
}

