/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import org.eclipse.birt.data.engine.api.APITestCase;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.junit.Assert;
import org.junit.Test;
import testutil.ConfigText;

public class ScriptTest
extends APITestCase {
    private static String dumpDataSourceScript = ConfigText.getString("Script.DumpDataSource");
    private static final String dumpDataSetScript = ConfigText.getString("Script.DumpDataSet");

    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo("ScriptTestTable", "CREATE TABLE ScriptTestTable (COUNTRY varchar(10), CITY varchar(10), SALE_DATE timestamp, AMOUNT int, ORDERED int, NULL_COLUMN varchar(10))", ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    @Test
    public void test1_ReadDataSource() throws Exception {
        this.dataSource.setBeforeOpenScript("testPrintln(\"DataSource.beforeOpen:\"); " + dumpDataSourceScript);
        this.dataSource.setAfterOpenScript("testPrintln(\"DataSource.afterOpen:\"); " + dumpDataSourceScript);
        this.dataSource.setBeforeCloseScript("testPrintln(\"DataSource.beforeClose:\"); " + dumpDataSourceScript);
        this.dataSource.setAfterCloseScript("testPrintln(\"DataSource.afterClose:\"); " + dumpDataSourceScript);
        this.createAndRunQuery();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void test2_UpdateDataSource() throws Exception {
        String INVALID_USER = "fake_user";
        this.dataSource.setBeforeOpenScript("extensionProperties.odaUser=\"fake_user\"; this.extensionID=\"invalid_extension\"; testPrintln(\"DataSource.beforeOpen:\"); " + dumpDataSourceScript);
        try {
            this.createAndRunQuery();
            Assert.assertTrue((boolean)false);
        }
        catch (DataException dataException) {
            // empty catch block
        }
        this.checkOutputFile();
    }

    @Test
    public void test3_ReadDataSet() throws Exception {
        this.dataSet.setBeforeOpenScript("testPrintln(\"DataSet.beforeOpen:\"); " + dumpDataSetScript);
        this.dataSet.setAfterOpenScript("testPrintln(\"DataSet.AfterOpen:\"); " + dumpDataSetScript);
        this.dataSet.setBeforeCloseScript("testPrintln(\"DataSet.beforeClose:\"); " + dumpDataSetScript);
        this.dataSet.setAfterCloseScript("testPrintln(\"DataSet.afterClose:\"); " + dumpDataSetScript);
        this.dataSet.setOnFetchScript(ConfigText.getString("Script.OnFetch"));
        this.createAndRunQuery();
        this.dataEngine.shutdown();
        this.checkOutputFile();
    }

    @Test
    public void test4_UpdateQueryText() throws Exception {
        this.dataSet.setBeforeOpenScript("queryText = queryText + \" WHERE COUNTRY = 'US' \"; extensionID = \"bad_id\"; testPrintln(\"DataSet.beforeOpen:\"); " + dumpDataSetScript);
        this.createAndRunQuery();
        this.checkOutputFile();
    }

    @Test
    public void test5_UpdateProps() throws Exception {
        String badPropertyName = "fake_property";
        String badPropertyValue = "fake_prop_value";
        this.dataSet.setBeforeOpenScript("extensionProperties[\"" + badPropertyName + "\"] = \"" + badPropertyValue + "\";testPrintln(\"DataSet.beforeOpen:\"); " + dumpDataSetScript);
        try {
            this.createAndRunQuery();
        }
        catch (DataException e) {
            Assert.assertTrue((e.getMessage().indexOf(badPropertyName) >= 0 ? 1 : 0) != 0);
        }
        this.checkOutputFile();
    }

    private void createAndRunQuery() throws Exception {
        QueryDefinition queryDefn = this.newReportQuery();
        String[] names = new String[]{"_COUNTRY"};
        ScriptExpression expression = new ScriptExpression("dataSetRow.COUNTRY", 5);
        Binding binding = new Binding(names[0]);
        binding.setExpression((IBaseExpression)expression);
        queryDefn.addBinding((IBinding)binding);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator it = queryResults.getResultIterator();
        this.outputQueryResult(it, names);
        it.close();
        queryResults.close();
    }
}

