/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.engine.api;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.IRenderOption;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.RenderOptionBase;
import org.eclipse.birt.report.tests.engine.EngineCase;

public class RunAndRenderTaskTest
extends EngineCase {
    static final String cancelMessage = "This task has been cancelled in testCancelRunAndRenderTask";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyResource_INPUT("report_engine.rptdesign", "report_engine.rptdesign");
        this.copyResource_INPUT("pages9.rptdesign", "pages9.rptdesign");
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        this.removeResource();
    }

    public void testRunAndRenderTask() throws EngineException {
        String input = this.genInputFile("report_engine.rptdesign");
        try {
            IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(input)));
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            RunAndRenderTaskTest.assertTrue((boolean)task.validateParameters());
            RenderOptionBase option = new RenderOptionBase();
            task.setRenderOption((IRenderOption)option);
            RenderOptionBase optionGet = (RenderOptionBase)task.getRenderOption();
            RunAndRenderTaskTest.assertEquals((String)"set/getRenderOption fail", (Object)option, (Object)optionGet);
            HashMap hm = new HashMap();
            task.setParameterValues(hm);
            HashMap hmGet = task.getParameterValues();
            RunAndRenderTaskTest.assertEquals((String)"set/getParameterValues(hashmap) fail", hm, (Object)hmGet);
            task.setParameterValue("p1", (Object)"p1value");
            RunAndRenderTaskTest.assertEquals((String)"Set/getParameterValues fail", task.getParameterValues().get("p1"), (Object)"p1value");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void testCancelRunAndRenderTask() {
        String input = this.genInputFile("pages9.rptdesign");
        try {
            IReportRunnable runnable = this.engine.openReportDesign((InputStream)new FileInputStream(new File(input)));
            IRunAndRenderTask task = this.engine.createRunAndRenderTask(runnable);
            HTMLRenderOption option = new HTMLRenderOption();
            option.setOutputFormat("html");
            int i = 0;
            while (i < 3) {
                task = this.engine.createRunAndRenderTask(runnable);
                task.setRenderOption((IRenderOption)option);
                task.setAppContext(new HashMap());
                task.run();
                task.close();
                RunAndRenderTaskTest.assertEquals((int)2, (int)task.getStatus());
                RunAndRenderTaskTest.assertEquals((int)0, (int)task.getErrors().size());
                ++i;
            }
            task = this.engine.createRunAndRenderTask(runnable);
            task.setRenderOption((IRenderOption)option);
            task.setAppContext(new HashMap());
            this.engine.getConfig().getAppContext().put("taskToCancel", task);
            this.engine.getConfig().getAppContext().put("taskToCancelWithSignal", null);
            CancelTask cancelThread = new CancelTask("cancelThread", task);
            cancelThread.start();
            task.run();
            RunAndRenderTaskTest.assertEquals((int)4, (int)task.getStatus());
            RunAndRenderTaskTest.assertEquals((int)0, (int)task.getErrors().size());
            task.close();
            task = this.engine.createRunAndRenderTask(runnable);
            this.engine.getConfig().getAppContext().put("taskToCancel", null);
            this.engine.getConfig().getAppContext().put("taskToCancelWithSignal", task);
            task.setRenderOption((IRenderOption)option);
            CancelWithFlagTask cancelWithFlagTask = new CancelWithFlagTask("cancelWithFlagTask", task);
            cancelWithFlagTask.start();
            task.run();
            RunAndRenderTaskTest.assertEquals((int)4, (int)task.getStatus());
            RunAndRenderTaskTest.assertEquals((int)1, (int)task.getErrors().size());
            RunAndRenderTaskTest.assertEquals((String)((EngineException)((Object)task.getErrors().get(0))).getMessage(), (String)cancelMessage);
            task.close();
            task = this.engine.createRunAndRenderTask(runnable);
            this.engine.getConfig().getAppContext().put("taskToCancel", null);
            this.engine.getConfig().getAppContext().put("taskToCancelWithSignal", null);
            task.setRenderOption((IRenderOption)option);
            task.run();
            RunAndRenderTaskTest.assertEquals((int)2, (int)task.getStatus());
            RunAndRenderTaskTest.assertEquals((int)0, (int)task.getErrors().size());
            task.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            RunAndRenderTaskTest.fail((String)"RunAndRenderTask.cancel() failed!");
        }
    }

    private class CancelTask
    extends Thread {
        private IRunAndRenderTask runTask;

        public CancelTask(String threadName, IRunAndRenderTask task) {
            super(threadName);
            this.runTask = task;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                this.runTask.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
                RunAndRenderTaskTest.fail((String)"RunAndRenderTask.cancel() failed!");
            }
        }
    }

    private class CancelWithFlagTask
    extends Thread {
        private IRunAndRenderTask runTask;

        public CancelWithFlagTask(String threadName, IRunAndRenderTask task) {
            super(threadName);
            this.runTask = task;
        }

        @Override
        public void run() {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
                this.runTask.cancel(RunAndRenderTaskTest.cancelMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
                RunAndRenderTaskTest.fail((String)"RunAndRenderTask.cancel(String) failed!");
            }
        }
    }
}

