/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.regression;

import com.ibm.icu.util.ULocale;
import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.MasterPageHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class Regression_134018
extends BaseTestCase {
    private static final String INPUT = "regression_134018.xml";
    private static final String LIBRARY = "regression_134018_lib.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/regression_134018.xml");
        this.copyInputToFile("input/regression_134018_lib.xml");
    }

    public void test_regression_134018() throws DesignFileException, SemanticException, IOException {
        String report = this.getTempFolder() + "/input/regression_134018.xml";
        String libA = this.getTempFolder() + "/input/regression_134018_lib.xml";
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        this.designHandle = this.sessionHandle.openDesign(report);
        this.designHandle.includeLibrary(LIBRARY, "regression_134018_lib");
        this.libraryHandle = this.designHandle.getLibrary("regression_134018_lib");
        MasterPageHandle basePage = this.libraryHandle.findMasterPage("basePage");
        Regression_134018.assertNotNull((Object)basePage);
        ElementFactory factory = this.designHandle.getElementFactory();
        SimpleMasterPageHandle newPage = (SimpleMasterPageHandle)factory.newElementFrom((DesignElementHandle)basePage, "rBasePage");
        Regression_134018.assertNotNull((Object)newPage);
        this.designHandle.getMasterPages().add((DesignElementHandle)newPage);
        this.designHandle.saveAs(report);
        this.libraryHandle = this.sessionHandle.openLibrary(libA);
        LabelHandle baseLabel = (LabelHandle)((SimpleMasterPageHandle)this.libraryHandle.findMasterPage("basePage")).getPageHeader().get(0);
        Regression_134018.assertNotNull((Object)baseLabel);
        Regression_134018.assertEquals((String)"baseLabel", (String)baseLabel.getName());
        Regression_134018.assertEquals((String)"aaa", (String)baseLabel.getText());
        baseLabel.setText("bbb");
        this.libraryHandle.saveAs(this.getTempFolder() + "/input/regression_134018_lib.xml");
        this.designHandle.reloadLibrary(this.libraryHandle);
        LabelHandle baseLabel1 = (LabelHandle)((SimpleMasterPageHandle)this.libraryHandle.findMasterPage("basePage")).getPageHeader().get(0);
        Regression_134018.assertNotNull((Object)baseLabel1);
        Regression_134018.assertEquals((String)"bbb", (String)baseLabel1.getText());
    }
}

