/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model.api;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.tests.model.BaseTestCase;

public class LibraryAddTest
extends BaseTestCase {
    private String fileName = "Library_Addin_Test.xml";
    private String LibImpFile = "Library_Import_Test.xml";
    private String inputLibraryName = "LibraryCreatLib.xml";
    private String libname = "LibA.xml";
    private String outFileName = "Library_Addin_Test_out.xml";
    private String goldenFileName = "Library_Addin_Test_golden.xml";
    String LibFile = this.inputLibraryName;
    String LibFileError1 = this.getTempFolder() + "/input/LibY.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.removeResource();
        this.copyInputToFile("input/" + this.fileName);
        this.copyInputToFile("input/" + this.inputLibraryName);
        this.copyInputToFile("input/" + this.libname);
        this.copyInputToFile("input/" + this.LibImpFile);
        this.copyGoldenToFile("golden/" + this.goldenFileName);
    }

    @Override
    public void tearDown() {
        this.removeResource();
    }

    public LibraryAddTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(LibraryAddTest.class);
    }

    public void testAddinLibrary() throws Exception {
        this.openDesign(this.LibImpFile);
        this.designHandle.includeLibrary(this.LibFile, "LibB");
        this.designHandle.includeLibrary(this.libname, "");
        String TempFile = this.genOutputFile(this.outFileName);
        this.designHandle.saveAs(TempFile);
        LibraryAddTest.assertTrue((boolean)this.compareTextFile(this.goldenFileName, this.outFileName));
        try {
            this.designHandle.includeLibrary(this.LibFileError1, "LibY");
        }
        catch (Exception e) {
            LibraryAddTest.assertNotNull((Object)e);
        }
        try {
            this.designHandle.includeLibrary("../inputLibZ.xml", "LibZ");
        }
        catch (Exception e) {
            LibraryAddTest.assertNotNull((Object)e);
        }
    }

    public void testRemoveLibrary() throws Exception {
        this.openDesign(this.LibImpFile);
        this.designHandle.includeLibrary(this.LibFile, "LibB");
        this.designHandle.includeLibrary("../input/LibA.xml", "");
        LibraryHandle lib1 = this.designHandle.findLibrary("LibraryCreatLib.xml");
        LibraryHandle lib2 = this.designHandle.findLibrary("LibA.xml");
        LibraryAddTest.assertNotNull((Object)lib1);
        LibraryAddTest.assertNotNull((Object)lib2);
        this.designHandle.dropLibrary(lib1);
        LibraryAddTest.assertEquals((int)1, (int)this.designHandle.getListProperty("libraries").size());
        this.designHandle.dropLibrary(lib2);
        LibraryAddTest.assertNull((Object)this.designHandle.getListProperty("libraries"));
    }
}

