/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.tests.model;

import com.ibm.icu.util.ULocale;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.ReportDesignHandle;
import org.eclipse.birt.report.model.api.SessionHandle;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.i18n.ThreadResources;
import org.eclipse.core.runtime.FileLocator;

public abstract class BaseTestCase
extends TestCase {
    protected ByteArrayOutputStream os = null;
    protected ReportDesignHandle designHandle = null;
    protected LibraryHandle libraryHandle = null;
    protected SessionHandle sessionHandle = null;
    protected ReportDesign design = null;
    protected Library library = null;
    protected static final String ROM_DEF_NAME = "rom.def";
    protected static final String PLUGIN_NAME = "org.eclipse.birt.report.tests.model";
    protected static final String PLUGINLOC = "/org.eclipse.birt.report.tests.model/";
    protected static final String PLUGIN_PATH = System.getProperty("user.dir") + "/plugins/" + "/org.eclipse.birt.report.tests.model/".substring("/org.eclipse.birt.report.tests.model/".indexOf("/") + 1) + "bin/";
    protected static final String TEST_FOLDER = "src/";
    protected static final String OUTPUT_FOLDER = "output";
    protected static final String INPUT_FOLDER = "input";
    protected static final String GOLDEN_FOLDER = "golden";
    protected static final ULocale TEST_LOCALE = new ULocale("aa");

    public BaseTestCase() {
        this(null);
    }

    public BaseTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        ThreadResources.setLocale((ULocale)ULocale.ENGLISH);
    }

    protected void tearDown() throws Exception {
        if (this.designHandle != null) {
            this.designHandle.close();
            this.designHandle = null;
        }
        super.tearDown();
    }

    protected void setCase(String caseName) {
    }

    protected final void copyFile(String from, String to) throws IOException {
        BufferedInputStream bis = null;
        FilterOutputStream bos = null;
        try {
            new File(to).createNewFile();
            bis = new BufferedInputStream(new FileInputStream(from));
            bos = new BufferedOutputStream(new FileOutputStream(to));
            int nextByte = 0;
            while ((nextByte = bis.read()) != -1) {
                ((BufferedOutputStream)bos).write(nextByte);
            }
        }
        finally {
            try {
                if (bis != null) {
                    bis.close();
                }
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String tempFolder() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        return tempDir;
    }

    public String getInputResourceFolder() {
        String resourceFolder = this.tempFolder() + "org.eclipse.birt.report.tests.model.RESOURCE";
        return resourceFolder;
    }

    public String getOutputResourceFolder() {
        String outputFolder = this.tempFolder() + "org.eclipse.birt.report.tests.model.OUTPUT";
        return outputFolder;
    }

    protected void copyResource(String src, String tgt, String folder) {
        InputStream in;
        String className = this.getFullQualifiedClassName();
        tgt = this.getInputResourceFolder() + File.separator + className + "/" + folder + "/" + (String)tgt;
        className = className.replace('.', '/');
        src = className + "/" + folder + "/" + (String)src;
        File parent = new File((String)tgt).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        BaseTestCase.assertTrue(((in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream((String)src)) != null ? 1 : 0) != 0);
        try {
            FileOutputStream fos = new FileOutputStream((String)tgt);
            byte[] fileData = new byte[5120];
            int readCount = -1;
            while ((readCount = in.read(fileData)) != -1) {
                fos.write(fileData, 0, readCount);
            }
            fos.close();
            in.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BaseTestCase.fail();
        }
    }

    protected void copyResource_INPUT(String input_resource, String input) {
        this.copyResource(input_resource, input, INPUT_FOLDER);
    }

    protected void copyResource_GOLDEN(String input_resource, String golden) {
        this.copyResource(input_resource, golden, GOLDEN_FOLDER);
    }

    protected void copyResource_OUTPUT(String output_resource, String output) {
        this.copyResource(output_resource, output, OUTPUT_FOLDER);
    }

    public void removeFile(File file) {
        if (file.isDirectory()) {
            File[] children = file.listFiles();
            int i = 0;
            while (i < children.length) {
                this.removeFile(children[i]);
                ++i;
            }
        }
        if (file.exists() && !file.delete()) {
            System.out.println(file.toString() + " can't be removed");
        }
    }

    protected String copyInputToFile(String resourceName) throws Exception {
        File tmpFolder;
        URL url = this.getResource(resourceName);
        InputStream is = url.openStream();
        Object folder = this.getTempFolder();
        int index = resourceName.lastIndexOf(INPUT_FOLDER);
        if (index > 0) {
            String relateDir = resourceName.substring(0, index - 1);
            folder = (String)folder + "/" + relateDir;
        }
        if (!(tmpFolder = new File((String)(folder = (String)folder + "/input/"))).exists()) {
            tmpFolder.mkdirs();
        }
        String filename = "";
        int lastSlash = resourceName.lastIndexOf("/");
        if (lastSlash != -1) {
            filename = resourceName.substring(lastSlash + 1);
        }
        FileOutputStream fos = new FileOutputStream((String)folder + filename);
        byte[] fileData = new byte[5120];
        int readCount = -1;
        while ((readCount = is.read(fileData)) != -1) {
            fos.write(fileData, 0, readCount);
        }
        fos.close();
        is.close();
        return (String)folder + filename;
    }

    protected String copyGoldenToFile(String resourceName) throws Exception {
        URL url = this.getResource(resourceName);
        InputStream is = url.openStream();
        Object folder = this.getTempFolder();
        File tmpFolder = new File((String)(folder = (String)folder + "/golden/"));
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        String filename = "";
        int lastSlash = resourceName.lastIndexOf("/");
        if (lastSlash != -1) {
            filename = resourceName.substring(lastSlash + 1);
        }
        FileOutputStream fos = new FileOutputStream((String)folder + filename);
        byte[] fileData = new byte[5120];
        int readCount = -1;
        while ((readCount = is.read(fileData)) != -1) {
            fos.write(fileData, 0, readCount);
        }
        fos.close();
        is.close();
        return (String)folder + filename;
    }

    protected URL getResource(String name) {
        return ((Object)((Object)this)).getClass().getResource(name);
    }

    public void removeFile(String file) {
        this.removeFile(new File(file));
    }

    public void removeResource() {
        String className = this.getFullQualifiedClassName();
        this.removeFile(className);
    }

    protected ReportDesignHandle createDesign() {
        return this.createDesign(null);
    }

    protected ReportDesignHandle createDesign(ULocale locale) {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        return this.designHandle;
    }

    protected LibraryHandle createLibrary() {
        return this.createLibrary(null);
    }

    protected LibraryHandle createLibrary(ULocale locale) {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        this.libraryHandle = this.sessionHandle.createLibrary();
        return this.libraryHandle;
    }

    protected void openDesignAsResource(Class theClass, String fileName, ULocale locale) throws DesignFileException {
        fileName = PLUGIN_PATH + this.getFullQualifiedClassName() + INPUT_FOLDER + (String)fileName;
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        InputStream stream = theClass.getResourceAsStream((String)fileName);
        this.designHandle = this.sessionHandle.openDesign((String)fileName, stream);
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected void openDesign(String fileName) throws DesignFileException {
        this.openDesign(fileName, true);
    }

    protected void openDesign(String fileName, boolean inSingleJarMode) throws DesignFileException {
        this.openDesign(fileName, ULocale.getDefault(), inSingleJarMode);
    }

    protected void openDesign(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        Object file = inSingleJarMode ? "input/" + fileName : fileName;
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        if (inSingleJarMode) {
            URL url = this.getResource((String)file);
            try {
                System.out.println("URL = " + String.valueOf(FileLocator.resolve((URL)url)));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.designHandle = this.sessionHandle.openDesign(url.toString());
        } else {
            this.designHandle = this.sessionHandle.openDesign((String)file);
        }
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected void openDesign(String fileName, ULocale locale) throws DesignFileException {
        this.openDesign(fileName, locale, true);
    }

    protected void openLibrary(String fileName) throws DesignFileException {
        this.openLibrary(fileName, true);
    }

    protected void openLibrary(String fileName, boolean inSingleJarMode) throws DesignFileException {
        this.openLibrary(fileName, ULocale.getDefault(), inSingleJarMode);
    }

    protected void openLibrary(String fileName, ULocale locale) throws DesignFileException {
        this.openLibrary(fileName, locale, true);
    }

    protected void openLibrary(String fileName, ULocale locale, boolean inSingleJarMode) throws DesignFileException {
        if (inSingleJarMode) {
            fileName = "input/" + (String)fileName;
        }
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        BaseTestCase.assertNotNull((Object)this.sessionHandle);
        this.libraryHandle = inSingleJarMode ? this.sessionHandle.openLibrary(this.getResource((String)fileName).toString(), this.getResourceAStream((String)fileName)) : this.sessionHandle.openLibrary((String)fileName);
    }

    protected void openDesign(String fileName, InputStream is) throws DesignFileException {
        this.openDesign(fileName, is, ULocale.getDefault());
    }

    protected void openDesign(String fileName, InputStream is, ULocale locale) throws DesignFileException {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(locale);
        this.designHandle = this.sessionHandle.openDesign(fileName, is);
        this.design = (ReportDesign)this.designHandle.getModule();
    }

    protected String getTempFolder() {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        String outputPath = (String)tempDir + PLUGIN_NAME + this.getFullQualifiedClassName();
        return outputPath;
    }

    protected InputStream getResourceAStream(String name) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(name);
    }

    private boolean compareFile(Reader goldenReader, Reader outputReader) throws Exception {
        StringBuilder errorText = new StringBuilder();
        BufferedReader lineReaderA = null;
        BufferedReader lineReaderB = null;
        boolean same = true;
        int lineNo = 1;
        try {
            lineReaderA = new BufferedReader(goldenReader);
            lineReaderB = new BufferedReader(outputReader);
            String strA = lineReaderA.readLine().trim();
            String strB = lineReaderB.readLine().trim();
            while (strA != null) {
                same = strA.trim().equals(strB.trim());
                if (!same) {
                    StringBuilder message = new StringBuilder();
                    message.append("line=");
                    message.append(lineNo);
                    message.append(" is different:\n");
                    message.append(" The line from golden file: ");
                    message.append(strA);
                    message.append("\n");
                    message.append(" The line from output file: ");
                    message.append(strB);
                    message.append("\n");
                    throw new Exception(message.toString());
                }
                strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                ++lineNo;
            }
            same = strB == null;
        }
        finally {
            try {
                if (lineReaderA != null) {
                    lineReaderA.close();
                }
                if (lineReaderB != null) {
                    lineReaderB.close();
                }
            }
            catch (Exception e) {
                lineReaderA = null;
                lineReaderB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareFile(String goldenFileName, String outputFileName) throws Exception {
        Reader readerA = null;
        InputStreamReader readerB = null;
        boolean same = true;
        StringBuilder errorText = new StringBuilder();
        try {
            try {
                goldenFileName = "golden/" + (String)goldenFileName;
                outputFileName = this.getTempFolder() + "/output/" + (String)outputFileName;
                readerA = new InputStreamReader(this.getResourceAStream((String)goldenFileName));
                readerB = new FileReader((String)outputFileName);
                same = this.compareFile(readerA, readerB);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    if (readerA != null) {
                        readerA.close();
                    }
                    if (readerB != null) {
                        readerB.close();
                    }
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                if (readerA != null) {
                    readerA.close();
                }
                if (readerB != null) {
                    readerB.close();
                }
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareFile(String goldenFileName) throws Exception {
        goldenFileName = "golden/" + (String)goldenFileName;
        InputStream streamA = this.getResourceAStream((String)goldenFileName);
        if (this.os == null) {
            return false;
        }
        ByteArrayInputStream streamB = new ByteArrayInputStream(this.os.toByteArray());
        InputStreamReader readerA = new InputStreamReader(streamA);
        InputStreamReader readerB = new InputStreamReader(streamB);
        return this.compareFile(readerA, readerB);
    }

    protected boolean compareTextFile(String goldenFileName, String outputFileName) throws Exception {
        InputStreamReader readerA = null;
        InputStreamReader readerB = null;
        boolean same = true;
        StringBuilder errorText = new StringBuilder();
        try {
            try {
                String resourceName = GOLDEN_FOLDER + File.separator + (String)goldenFileName;
                String folder = this.getTempFolder();
                goldenFileName = folder + "/" + resourceName;
                outputFileName = this.genOutputFile(outputFileName);
                readerA = new FileReader((String)goldenFileName);
                readerB = new FileReader(outputFileName);
                same = this.compareTextFile(readerA, readerB);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    readerA.close();
                    readerB.close();
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                readerA.close();
                readerB.close();
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected boolean compareTextFileAsResource(Class theClass, String goldenFileName, String outputFileName) throws Exception {
        InputStreamReader readerA = null;
        InputStreamReader readerB = null;
        StringBuilder errorText = new StringBuilder();
        boolean same = false;
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        try {
            try {
                goldenFileName = this.getFullQualifiedClassName() + "/golden/" + (String)goldenFileName;
                InputStream goldenStream = theClass.getResourceAsStream((String)goldenFileName);
                outputFileName = (String)tempDir + "org.eclipse.birt.report.model" + this.getFullQualifiedClassName() + "/output/" + (String)outputFileName;
                readerA = new InputStreamReader(goldenStream);
                readerB = new FileReader((String)outputFileName);
                same = this.compareTextFile(readerA, readerB);
            }
            catch (IOException e) {
                errorText.append(e.toString());
                errorText.append("\n");
                e.printStackTrace();
                try {
                    readerA.close();
                    readerB.close();
                }
                catch (Exception e2) {
                    readerA = null;
                    readerB = null;
                    errorText.append(e2.toString());
                    throw new Exception(errorText.toString());
                }
            }
        }
        finally {
            try {
                readerA.close();
                readerB.close();
            }
            catch (Exception e) {
                readerA = null;
                readerB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    private boolean compareTextFile(Reader goldenReader, Reader outputReader) throws Exception {
        StringBuilder errorText = new StringBuilder();
        BufferedReader lineReaderA = null;
        BufferedReader lineReaderB = null;
        boolean same = true;
        int lineNo = 1;
        try {
            lineReaderA = new BufferedReader(goldenReader);
            lineReaderB = new BufferedReader(outputReader);
            String strA = lineReaderA.readLine().trim();
            String strB = lineReaderB.readLine().trim();
            while (strA != null) {
                if (strA.startsWith("<report xmlns=") && strA.indexOf("version=") != -1 || strA.startsWith("<library xmlns=") && strA.indexOf("version=") != -1 || strA.startsWith("<property name=\"fileName\">")) {
                    strA = lineReaderA.readLine();
                    strB = lineReaderB.readLine();
                    if (strA != null) {
                        strA = strA.trim();
                    }
                    if (strB != null) {
                        strB = strB.trim();
                    }
                    ++lineNo;
                    continue;
                }
                same = strA.equals(strB);
                if (!same) {
                    StringBuilder message = new StringBuilder();
                    message.append("line=");
                    message.append(lineNo);
                    message.append(" is different:\n");
                    message.append(" The line from golden file: ");
                    message.append(strA);
                    message.append("\n");
                    message.append(" The line from output file: ");
                    message.append(strB);
                    message.append("\n");
                    throw new Exception(message.toString());
                }
                strA = lineReaderA.readLine();
                strB = lineReaderB.readLine();
                if (strA != null) {
                    strA = strA.trim();
                }
                if (strB != null) {
                    strB = strB.trim();
                }
                ++lineNo;
            }
            same = strA == null && strB == null;
        }
        finally {
            try {
                lineReaderA.close();
                lineReaderB.close();
            }
            catch (Exception e) {
                lineReaderA = null;
                lineReaderB = null;
                errorText.append(e.toString());
                throw new Exception(errorText.toString());
            }
        }
        return same;
    }

    protected void printSemanticErrors() {
        this.printSemanticError(this.design);
    }

    protected void printSemanticError(ReportDesign design) {
        if (design != null) {
            this.printErrorList(design.getAllErrors());
        }
    }

    protected void printSyntaxError(DesignFileException e) {
        if (e != null) {
            this.printErrorList(e.getErrorList());
        }
    }

    private void printErrorList(List errors) {
        if (errors != null && !errors.isEmpty()) {
            for (ErrorDetail ex : errors) {
                System.out.println(ex);
            }
        }
    }

    protected void dumpErrors(String filename) throws Exception {
        String outputFolder = PLUGIN_PATH + this.getClassFolder() + OUTPUT_FOLDER;
        File f = new File(outputFolder);
        if (!f.exists() && !f.mkdir()) {
            throw new Exception("Can not create the output folder!");
        }
        filename = outputFolder + (String)filename;
        if (this.design == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(new FileOutputStream((String)filename));
        List errors = this.design.getAllErrors();
        ErrorDetail ex = null;
        int i = 0;
        while (i < errors.size()) {
            ex = (ErrorDetail)errors.get(i);
            writer.print(this.design.getFileName());
            writer.println(ex);
            ++i;
        }
        writer.close();
    }

    protected void save() throws IOException {
        this.save((ModuleHandle)this.designHandle);
    }

    protected void save(ModuleHandle moduleHandle) throws IOException {
        this.os = new ByteArrayOutputStream();
        if (moduleHandle != null) {
            moduleHandle.serialize((OutputStream)this.os);
        }
        this.os.close();
    }

    protected void saveLibrary() throws IOException {
        this.save((ModuleHandle)this.libraryHandle);
    }

    protected void saveAs(String filename) throws IOException {
        this.saveAs((ModuleHandle)this.designHandle, filename);
    }

    protected void saveAs(ModuleHandle moduleHandle, String filename) throws IOException {
        if (moduleHandle == null) {
            return;
        }
        moduleHandle.saveAs(this.genOutputFile(filename));
    }

    protected void makeOutputDir() throws IOException {
        File outputFolder;
        String outputPath = this.getFullQualifiedClassName() + "/output";
        File parent = new File(outputPath).getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        if (!(outputFolder = new File(outputPath = String.valueOf(parent) + "/output")).exists() && !outputFolder.mkdir()) {
            throw new IOException("Can not create the output folder");
        }
    }

    protected void saveLibraryAs(String filename) throws IOException {
        if (this.libraryHandle == null) {
            return;
        }
        String outputPath = this.getTempFolder() + "/output";
        File outputFolder = new File(outputPath);
        if (!outputFolder.exists() && !outputFolder.mkdir()) {
            throw new IOException("Can not create the output folder");
        }
        this.libraryHandle.saveAs(outputPath + "/" + filename);
    }

    protected void saveAsInTempDir(String filename) throws IOException {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        if (this.designHandle == null) {
            return;
        }
        String outputPath = (String)tempDir + "org.eclipse.birt.report.model" + this.getFullQualifiedClassName() + OUTPUT_FOLDER;
        File outputFolder = new File(outputPath);
        if (!outputFolder.exists() && !outputFolder.mkdirs()) {
            throw new IOException("Can not create the output folder");
        }
        this.designHandle.saveAs(outputPath + filename);
    }

    protected String getClassFolder() {
        CodeSource source;
        Object pathBase = null;
        ProtectionDomain domain = ((Object)((Object)this)).getClass().getProtectionDomain();
        if (domain != null && (source = domain.getCodeSource()) != null) {
            URL url = source.getLocation();
            pathBase = url.getPath();
            if (((String)pathBase).endsWith("bin/")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 4);
            }
            if (((String)pathBase).endsWith("bin")) {
                pathBase = ((String)pathBase).substring(0, ((String)pathBase).length() - 3);
            }
        }
        pathBase = pathBase + TEST_FOLDER;
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = (String)pathBase + ((String)className).replace('.', '/');
        return className;
    }

    protected String getFullQualifiedClassName() {
        Object className = ((Object)((Object)this)).getClass().getName();
        int lastDotIndex = ((String)className).lastIndexOf(".");
        className = ((String)className).substring(0, lastDotIndex);
        className = "/" + ((String)className).replace('.', '/');
        return className;
    }

    protected byte[] streamToBytes(InputStream is) throws IOException {
        int len;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buffer = new byte[100];
        while ((len = is.read(buffer)) > 0) {
            bos.write(buffer, 0, len);
        }
        byte[] bytes = bos.toByteArray();
        return bytes;
    }

    protected void compareErrors(String filename) throws Exception {
        filename = this.genOutputFile(filename);
        if (this.design == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        List errors = this.design.getAllErrors();
        String msg = null;
        String msgLine = null;
        ErrorDetail ex = null;
        int i = 0;
        while (i < errors.size()) {
            ex = (ErrorDetail)errors.get(i);
            msg = this.design.getFileName() + String.valueOf(ex);
            msgLine = reader.readLine();
            BaseTestCase.assertTrue((msgLine != null && msg.equals(msgLine) ? 1 : 0) != 0);
            ++i;
        }
        reader.close();
    }

    protected String genOutputFile(String output) {
        String SEPARATOR = File.separator;
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (!((String)tempDir).endsWith(File.separator)) {
            tempDir = (String)tempDir + File.separator;
        }
        String outputFileName = (String)tempDir + this.getFullQualifiedClassName() + SEPARATOR + OUTPUT_FOLDER + SEPARATOR + output;
        File outputFile = new File(outputFileName);
        try {
            outputFile.getParentFile().mkdirs();
            if (!outputFile.exists()) {
                outputFile.createNewFile();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BaseTestCase.fail();
        }
        return outputFileName;
    }

    protected void saveOutputFile(String fileName) throws Exception {
        String folder = this.getTempFolder() + OUTPUT_FOLDER;
        File tmpFolder = new File(folder);
        if (!tmpFolder.exists()) {
            tmpFolder.mkdirs();
        }
        String strDesign = this.os.toString();
        FileOutputStream fos = new FileOutputStream(folder + "/" + fileName);
        fos.write(strDesign.getBytes("UTF-8"));
        fos.close();
    }

    public void createBlankDesign() {
        SessionHandle session = new DesignEngine(new DesignConfig()).newSessionHandle(ULocale.ENGLISH);
        ModuleOption options = new ModuleOption();
        options.setProperty("blankCreation", (Object)true);
        this.designHandle = session.createDesign(null, options);
    }
}

