/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf.font;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.report.engine.layout.pdf.font.CompositeFontConfig;

public class FontMappingConfig {
    protected Set<String> fontPaths = new HashSet<String>();
    protected HashMap<String, String> fontAliases = new HashMap();
    protected HashMap<String, String> fontEncodings = new HashMap();
    protected HashMap<String, String[]> searchSequences = new HashMap();
    protected HashMap<String, CompositeFontConfig> compositeFonts = new HashMap();
    protected boolean fontKerningAndLigaturesUsage = false;

    public void merge(FontMappingConfig config) {
        this.fontPaths.addAll(config.fontPaths);
        for (Map.Entry<String, String> entry : config.fontAliases.entrySet()) {
            this.addFontAlias(entry.getKey(), entry.getValue());
        }
        this.fontEncodings.putAll(config.fontEncodings);
        this.searchSequences.putAll(config.searchSequences);
        for (Map.Entry<String, Object> entry : config.compositeFonts.entrySet()) {
            String fontName = entry.getKey();
            CompositeFontConfig newConfig = (CompositeFontConfig)entry.getValue();
            CompositeFontConfig oldConfig = this.compositeFonts.get(fontName);
            if (oldConfig != null) {
                oldConfig.merge(newConfig);
                continue;
            }
            this.compositeFonts.put(fontName, new CompositeFontConfig(newConfig));
        }
    }

    public void addFontPath(String fontPath) {
        this.fontPaths.add(fontPath);
    }

    public void addFontAlias(String alias, String fontName) {
        this.fontAliases.put(alias.toLowerCase(), fontName);
    }

    public void addFontEncoding(String fontName, String fontEncoding) {
        this.fontEncodings.put(fontName, fontEncoding);
    }

    public void addSearchSequence(String localeKey, String[] sequence) {
        this.searchSequences.put(localeKey, sequence);
    }

    public HashMap<String, String[]> getSearchSequences() {
        return this.searchSequences;
    }

    public void addCompositeFont(CompositeFontConfig fontConfig) {
        this.compositeFonts.put(fontConfig.fontName, fontConfig);
    }

    public Collection<CompositeFontConfig> getAllCompositeFonts() {
        return this.compositeFonts.values();
    }

    public void setFontKerningAndLigatures(boolean useKerningLigatures) {
        this.fontKerningAndLigaturesUsage = useKerningLigatures;
    }

    public boolean getFontKerningAndLigatures() {
        return this.fontKerningAndLigaturesUsage;
    }
}

