/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.static_html;

import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class StaticHTMLPrviewPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.birt.report.designer.ui.preview.static_html";
    public static final String IMG_NAV_FIRST = "FirstPage.gif";
    public static final String IMG_NAV_PRE = "PreviousPage.gif";
    public static final String IMG_NAV_NEXT = "NextPage.gif";
    public static final String IMG_NAV_LAST = "LastPage.gif";
    public static final String IMG_NAV_GO = "Go.gif";
    public static final String IMG_PARAMS = "parameter.gif";
    public static final String IMG_TOC = "Toc.gif";
    public static final String IMG_FORM_TITLE = "form_title.gif";
    public static final String IMG_TOC_LEAF = "Leaf.gif";
    public static final String IMG_RE_RUN = "preview.gif";
    private static StaticHTMLPrviewPlugin plugin;

    public StaticHTMLPrviewPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (this.isCleanTempfolder()) {
            this.deleteTempFile();
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        if (this.isCleanTempfolder()) {
            this.deleteFile(new File(this.getTempFolder()));
        }
    }

    private void deleteFile(File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                this.deleteFolder(children[i]);
                ++i;
            }
        }
    }

    private void deleteFolder(File dir) {
        File[] children = dir.listFiles();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                if (children[i].isDirectory()) {
                    this.deleteFile(children[i]);
                } else {
                    children[i].delete();
                }
                ++i;
            }
        }
        dir.delete();
    }

    private void deleteTempFile() {
        Job deleteJob = new Job("Delete temporary files"){

            protected IStatus run(IProgressMonitor monitor) {
                StaticHTMLPrviewPlugin.this.deleteFile(new File(StaticHTMLPrviewPlugin.this.getTempFolder()));
                return Status.OK_STATUS;
            }
        };
        deleteJob.setSystem(true);
        deleteJob.schedule();
    }

    public static StaticHTMLPrviewPlugin getDefault() {
        return plugin;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        this.registerImage(registry, IMG_NAV_FIRST, IMG_NAV_FIRST);
        this.registerImage(registry, IMG_NAV_PRE, IMG_NAV_PRE);
        this.registerImage(registry, IMG_NAV_NEXT, IMG_NAV_NEXT);
        this.registerImage(registry, IMG_NAV_LAST, IMG_NAV_LAST);
        this.registerImage(registry, IMG_NAV_GO, IMG_NAV_GO);
        this.registerImage(registry, IMG_PARAMS, IMG_PARAMS);
        this.registerImage(registry, IMG_TOC, IMG_TOC);
        this.registerImage(registry, IMG_FORM_TITLE, IMG_FORM_TITLE);
        this.registerImage(registry, IMG_TOC_LEAF, IMG_TOC_LEAF);
        this.registerImage(registry, IMG_RE_RUN, IMG_RE_RUN);
    }

    private void registerImage(ImageRegistry registry, String key, String fileName) {
        try {
            Path path = new Path("icons/" + fileName);
            URL url = this.find((IPath)path);
            if (url != null) {
                ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
                registry.put(key, desc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getTempFolder() {
        return this.getPreferenceStore().getString("tempPathPreference");
    }

    public boolean isCleanTempfolder() {
        return this.getPreferenceStore().getBoolean("cleanTempPreference");
    }
}

