/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.core.model.schematic;

import org.eclipse.birt.report.designer.core.model.IModelAdapterHelper;
import org.eclipse.birt.report.designer.core.model.ReportItemtHandleAdapter;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.designer.util.ImageManager;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.ExpressionHandle;
import org.eclipse.birt.report.model.api.ImageHandle;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ImageHandleAdapter
extends ReportItemtHandleAdapter {
    private Rectangle imageFigureSize = null;

    public ImageHandleAdapter(ImageHandle image, IModelAdapterHelper mark) {
        super((ReportItemHandle)image, mark);
    }

    public void setImageFigureDimension(Rectangle imageFigureSize) {
        this.imageFigureSize = imageFigureSize;
    }

    public Image getImage() {
        ImageHandle imageHandel = this.getImageHandle();
        String imageSource = imageHandel.getSource();
        PropertyHandle uriPropertyHandle = imageHandel.getPropertyHandle("uri");
        ExpressionHandle expression = imageHandel.getExpressionProperty("uri");
        String url = imageHandel.getURI();
        if (uriPropertyHandle != null && uriPropertyHandle.isLocal() && expression != null && !"constant".equals(expression.getType())) {
            url = this.removeQuoteString(url);
        }
        if ("embed".equalsIgnoreCase(imageSource)) {
            return ImageManager.getInstance().getEmbeddedImage(imageHandel.getModuleHandle(), imageHandel.getImageName());
        }
        if ("file".equalsIgnoreCase(imageSource)) {
            if (URIUtil.isValidResourcePath((String)url)) {
                return ImageManager.getInstance().getImage(imageHandel.getModuleHandle(), URIUtil.getLocalPath((String)url));
            }
            return ImageManager.getInstance().getImage(imageHandel.getModuleHandle(), url);
        }
        if ("url".equalsIgnoreCase(imageSource)) {
            return ImageManager.getInstance().getURIImage(imageHandel.getModuleHandle(), url);
        }
        "expr".equalsIgnoreCase(imageSource);
        return null;
    }

    private String removeQuoteString(String value) {
        if (value != null && value.length() > 1 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
            return value.substring(1, value.length() - 1);
        }
        return value;
    }

    private ImageHandle getImageHandle() {
        return (ImageHandle)this.getHandle();
    }

    @Override
    public Dimension getSize() {
        return this.evaluateSize(false);
    }

    public Dimension getRawSize() {
        return this.evaluateSize(true);
    }

    private Dimension evaluateSize(boolean getRawSize) {
        int px = 0;
        int py = 0;
        DimensionHandle widthHandle = this.getImageHandle().getWidth();
        px = this.imageFigureSize != null && "%".equals(widthHandle.getUnits()) ? (int)DEUtil.convertToPixel(widthHandle, this.imageFigureSize.width, "px") : (int)DEUtil.convertoToPixel(widthHandle);
        DimensionHandle heightHandle = this.getImageHandle().getHeight();
        py = this.imageFigureSize != null && "%".equals(heightHandle.getUnits()) ? (int)DEUtil.convertToPixel(heightHandle, this.imageFigureSize.height, "px") : (int)DEUtil.convertoToPixel(heightHandle);
        if (DEUtil.isFixLayout(this.getHandle())) {
            if (px == 0 && widthHandle.isSet()) {
                px = 1;
            }
            if (py == 0 && heightHandle.isSet()) {
                py = 1;
            }
        }
        if (widthHandle.getUnits() != null && this.getImageHandle().isProportionalScale()) {
            py = px;
        }
        if (getRawSize) {
            return new Dimension(Math.max(px, 0), Math.max(py, 0));
        }
        if (px != 0 && py != 0) {
            return new Dimension(px, py);
        }
        return null;
    }

    @Override
    public void setSize(Dimension size) throws SemanticException {
        if (size.width >= 0) {
            this.getImageHandle().setWidth(size.width + "px");
        }
        if (size.height >= 0) {
            this.getImageHandle().setHeight(size.height + "px");
        }
    }
}

