/*******************************************************************************
 * Copyright (c) 2008 Actuate Corporation.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * https://www.eclipse.org/legal/epl-2.0/.
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 *
 * Contributors:
 *  Actuate Corporation  - initial API and implementation
 *******************************************************************************/

package org.eclipse.birt.report.designer.ui.widget;

/**
 * Constants for widget creation
 *
 * @since 2.5
 */
public interface WidgetConstants {

	/**
	 * The number of pixels between the edge of one control and the edge of its
	 * neighbouring control.
	 */
	int SPACING = 8;

	/**
	 * Default height of Text control
	 */
	int TEXT_HEIGHT = 12;

	/**
	 * Default width of Text control
	 */
	int TEXT_WIDTH = 40;

	/**
	 * Default Height of Combo control
	 */
	int COMBO_HEIGHT = 8;

	/**
	 * Default width of Combo control
	 */
	int COMBO_WIDTH = 18;

	/**
	 * The height of margin.
	 */
	int MARGIN_HEIGHT = 7;

	/**
	 * The width of margin.
	 */
	int MARGIN_WIDTH = 7;

	/**
	 * The minimum width for a text control
	 */
	int MIN_TEXT_WIDTH = 80;

}
