/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.birt.data.engine.olap.data.util.BufferedRandomAccessFile;
import org.junit.Assert;
import org.junit.Test;

public class BufferedRandomAccessFileTest {
    private static final String tmpPath = System.getProperty("java.io.tmpdir");

    @Test
    public void testBytes() throws IOException {
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        file.seek(0L);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        file.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        file.seek(0L);
        Assert.assertEquals((long)file.read(bytes, 0, bytes.length), (long)1024L);
        Assert.assertEquals((long)bytes[0], (long)1L);
        Assert.assertEquals((long)bytes[1], (long)2L);
        file.close();
    }

    @Test
    public void testBytes11() throws IOException {
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "Buffer123"), "rw", 1000, -1000);
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        file.seek(0L);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        file.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        file.seek(0L);
        Assert.assertEquals((long)file.read(bytes, 0, bytes.length), (long)1024L);
        Assert.assertEquals((long)bytes[0], (long)1L);
        Assert.assertEquals((long)bytes[1], (long)2L);
        file.close();
    }

    @Test
    public void testBytes2() throws IOException {
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 100, -100);
        byte[] bytes = new byte[1024];
        bytes[0] = 1;
        bytes[1] = 2;
        file.seek(0L);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        file.write(bytes, 0, bytes.length);
        bytes = new byte[932];
        file.write(bytes, 0, bytes.length);
        bytes = new byte[1024];
        file.seek(0L);
        Assert.assertEquals((long)file.read(bytes, 0, bytes.length), (long)1024L);
        Assert.assertEquals((long)bytes[0], (long)1L);
        Assert.assertEquals((long)bytes[1], (long)2L);
        file.close();
    }

    @Test
    public void testInteger() throws IOException {
        int objectNumber = 1001;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeInt(i);
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)file.readInt(), (long)i);
            ++i;
        }
        file.seek(400L);
        Assert.assertEquals((long)file.readInt(), (long)100L);
        file.seek(804L);
        Assert.assertEquals((long)file.readInt(), (long)201L);
        Assert.assertEquals((long)file.readInt(), (long)202L);
        file.seek(2804L);
        file.writeInt(1000001);
        Assert.assertEquals((long)file.readInt(), (long)702L);
        file.seek(2804L);
        Assert.assertEquals((long)file.readInt(), (long)1000001L);
        file.close();
    }

    @Test
    public void testString() throws IOException {
        int objectNumber = 3000;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeUTF("string" + i);
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)file.readUTF(), (Object)("string" + i));
            ++i;
        }
        file.close();
    }

    @Test
    public void testBigDecimal() throws IOException {
        int objectNumber = 3000;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeBigDecimal(new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)file.readBigDecimal(), (Object)new BigDecimal("1010101010101010101010" + i));
            ++i;
        }
        file.close();
    }

    @Test
    public void testDate() throws IOException {
        int objectNumber = 4101;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeDate(new Date(1900100000 + i * 1000));
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((Object)file.readDate(), (Object)new Date(1900100000 + i * 1000));
            ++i;
        }
        file.close();
    }

    @Test
    public void testMixed() throws IOException {
        int objectNumber = 1001;
        BufferedRandomAccessFile file = new BufferedRandomAccessFile(new File(tmpPath + File.separatorChar + "BufferedRandomAccessFile"), "rw", 1000);
        int i = 0;
        while (i < objectNumber) {
            file.writeInt(i);
            ++i;
        }
        file.seek(0L);
        i = 0;
        while (i < objectNumber) {
            Assert.assertEquals((long)file.readInt(), (long)i);
            ++i;
        }
        file.writeBigDecimal(new BigDecimal("1010101010101"));
        file.writeDate(new Date(12202000L));
        file.writeUTF("testString");
        file.writeShort(1300);
        file.writeLong(300000111L);
        file.seek(0L);
        file.skipBytes(objectNumber * 4);
        Assert.assertEquals((Object)file.readBigDecimal(), (Object)new BigDecimal("1010101010101"));
        Assert.assertEquals((Object)file.readDate(), (Object)new Date(12202000L));
        Assert.assertEquals((Object)file.readUTF(), (Object)"testString");
        Assert.assertEquals((long)file.readShort(), (long)1300L);
        Assert.assertEquals((long)file.readLong(), (long)300000111L);
        file.close();
    }
}

