/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.odaconsumer;

import java.math.BigDecimal;
import java.sql.Date;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.odaconsumer.QueryTest;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.junit.Assert;
import org.junit.Before;

public class ResultSetMetaDataTest
extends QueryTest {
    private IResultClass m_metadata;

    @Before
    public void resultSetMetaDataSetUp() throws Exception {
        this.m_metadata = this.getStatement().getMetaData();
    }

    public final void testGetColumnCount() {
        this.checkColumnCount(this.m_metadata);
    }

    public final void testGetColumnCount1() throws DataException {
        IResultClass metadata = this.getMetaDataFromResult();
        this.checkColumnCount(metadata);
    }

    public final void testGetColumnName() throws Exception {
        this.checkColumnNames(this.m_metadata);
    }

    public final void testGetColumnName1() throws Exception {
        IResultClass metadata = this.getMetaDataFromResult();
        this.checkColumnNames(metadata);
    }

    public final void testGetColumnType() throws Exception {
        this.checkColumnTypes(this.m_metadata);
    }

    public final void testGetColumnType1() throws Exception {
        IResultClass metadata = this.getMetaDataFromResult();
        this.checkColumnTypes(metadata);
    }

    private IResultClass getMetaDataFromResult() throws DataException {
        this.getStatement().execute();
        ResultSet resultset = this.getStatement().getResultSet();
        IResultClass metadata = resultset.getMetaData();
        return metadata;
    }

    private void checkColumnCount(IResultClass metadata) {
        Assert.assertEquals((long)5L, (long)metadata.getFieldCount());
    }

    private void checkColumnNames(IResultClass metadata) throws Exception {
        int i = 1;
        int n = metadata.getFieldCount();
        while (i <= n) {
            String colName = metadata.getFieldName(i);
            switch (i) {
                case 1: {
                    Assert.assertEquals((Object)"intColumn", (Object)colName);
                    break;
                }
                case 2: {
                    Assert.assertEquals((Object)"doubleColumn", (Object)colName);
                    break;
                }
                case 3: {
                    Assert.assertEquals((Object)"stringColumn", (Object)colName);
                    break;
                }
                case 4: {
                    Assert.assertEquals((Object)"dateColumn", (Object)colName);
                    break;
                }
                case 5: {
                    Assert.assertEquals((Object)"decimalColumn", (Object)colName);
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
            ++i;
        }
    }

    private void checkColumnTypes(IResultClass metadata) throws Exception {
        int i = 1;
        int n = metadata.getFieldCount();
        while (i <= n) {
            Class colType = metadata.getFieldValueClass(i);
            switch (i) {
                case 1: {
                    Assert.assertEquals(Integer.class, (Object)colType);
                    break;
                }
                case 2: {
                    Assert.assertEquals(Double.class, (Object)colType);
                    break;
                }
                case 3: {
                    Assert.assertEquals(String.class, (Object)colType);
                    break;
                }
                case 4: {
                    Assert.assertEquals(Date.class, (Object)colType);
                    break;
                }
                case 5: {
                    Assert.assertEquals(BigDecimal.class, (Object)colType);
                    break;
                }
                default: {
                    Assert.assertTrue((boolean)false);
                }
            }
            ++i;
        }
    }
}

