/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.util.ArrayList;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.cache.MemoryCache;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MemoryCacheTest {
    private IResultObject[] resultObjects;

    @Before
    public void memoryCacheSetUp() throws DataException {
        ArrayList<ResultFieldMetadata> columnsList = new ArrayList<ResultFieldMetadata>();
        ResultFieldMetadata columnMetaData = new ResultFieldMetadata(1, "col1", "col1", DataType.getClass((int)5), "String", true);
        columnsList.add(columnMetaData);
        this.resultObjects = new ResultObject[]{new ResultObject((IResultClass)new ResultClass(columnsList), new Object[]{"abc"}), new ResultObject((IResultClass)new ResultClass(columnsList), new Object[]{"def"})};
    }

    @Test
    public void testNext() throws DataException {
        MemoryCache memoryCache = new MemoryCache(this.resultObjects, this.resultObjects[0].getResultClass(), null);
        int i = 0;
        Assert.assertEquals((long)memoryCache.getCurrentIndex(), (long)-1L);
        while (memoryCache.next()) {
            if (i == 0) {
                Assert.assertEquals((long)memoryCache.getCurrentIndex(), (long)0L);
                Assert.assertEquals((Object)memoryCache.getCurrentResult().getFieldValue(1).toString(), (Object)"abc");
            } else if (i == 1) {
                Assert.assertEquals((long)memoryCache.getCurrentIndex(), (long)1L);
                Assert.assertEquals((Object)memoryCache.getCurrentResult().getFieldValue(1).toString(), (Object)"def");
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            Assert.assertEquals((Object)memoryCache.next(), (Object)false);
            Assert.assertEquals((long)memoryCache.getCurrentIndex(), (long)2L);
            Assert.assertEquals((Object)memoryCache.getCurrentResult(), null);
            ++i;
        }
    }

    @Test
    public void testFetch() throws DataException {
        MemoryCache memoryCache = new MemoryCache(this.resultObjects, this.resultObjects[0].getResultClass(), null);
        int i = 0;
        while (memoryCache.fetch() != null) {
            if (i == 0) {
                Assert.assertEquals((Object)memoryCache.getCurrentResult().getFieldValue(1).toString(), (Object)"abc");
            } else if (i == 1) {
                Assert.assertEquals((Object)memoryCache.getCurrentResult().getFieldValue(1).toString(), (Object)"def");
            }
            ++i;
        }
        Assert.assertEquals((long)i, (long)2L);
    }
}

