/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.binding;

import com.ibm.icu.text.DateFormat;
import java.lang.invoke.CallSite;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IBinding;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.api.IFilterDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IParameterDefinition;
import org.eclipse.birt.data.engine.api.IParameterMetaData;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryExecutionHints;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.Binding;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.api.querydefn.ConditionalExpression;
import org.eclipse.birt.data.engine.api.querydefn.FilterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.GroupDefinition;
import org.eclipse.birt.data.engine.api.querydefn.OdaDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ParameterDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryExecutionHints;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.SortDefinition;
import org.eclipse.birt.data.engine.api.querydefn.SubqueryDefinition;
import org.eclipse.birt.data.engine.binding.APITestCase;
import org.eclipse.birt.data.engine.core.DataException;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import testutil.ConfigText;

public class FeaturesTest
extends APITestCase {
    @Override
    protected APITestCase.DataSourceInfo getDataSourceInfo() {
        return new APITestCase.DataSourceInfo(ConfigText.getString("Api.TestData.TableName"), ConfigText.getString("Api.TestData.TableSQL"), ConfigText.getString("Api.TestData.TestDataFileName"));
    }

    @Test
    public void test1() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_SALE_DATE");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_AMOUNT > 100"))};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test2() throws Exception {
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setExpression("row[\"__rownum\"]");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(null, null, null, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test3() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test31() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_TOTAL_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.Sum(row.ROW_AMOUNT, null, \"group0\")")};
        QueryDefinition query = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        QueryExecutionHints hints = new QueryExecutionHints();
        hints.setSortBeforeGrouping(false);
        query.setQueryExecutionHints((IQueryExecutionHints)hints);
        this.executeQuery(query, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void test4() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SALE_SORT"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("row.SALE_SORT");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        try {
            this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, bindingExprRow);
            Assert.fail((String)"Should throw DteException!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test6() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test7() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameFilter = new String[]{"SALE_FILTER"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMONT && 100")};
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.SALE_FILTER_E"))};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        try {
            this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, bindingNameFilter, bindingExprFilter, filters, bindingNameRow, bindingExprRow);
            Assert.fail((String)"Should throw DteException!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void test8() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_SALE_DATE");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_2", "ROW_CITY_2", "ROW_CITY_3", "ROW_SALE_DATE_2", "ROW_AMOUNT_4"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ConditionalExpression("dataSetRow.AMOUNT", 6, "5"), new ConditionalExpression("dataSetRow.CITY", 1, "'Beijing'"), new ConditionalExpression("dataSetRow.CITY", 2, "'Beijing'"), new ConditionalExpression("dataSetRow.SALE_DATE", 5, "'01/01/2004'"), new ConditionalExpression("dataSetRow.AMOUNT", 7, "5", "100")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test19() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setExpression((IScriptExpression)new ScriptExpression("row[\"foo\"]"));
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_2", "ROW_CITY_2", "ROW_CITY_3", "ROW_SALE_DATE_2", "ROW_AMOUNT_4"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ConditionalExpression("dataSetRow.AMOUNT", 6, "5"), new ConditionalExpression("dataSetRow.CITY", 1, "'Beijing'"), new ConditionalExpression("dataSetRow.CITY", 2, "'Beijing'"), new ConditionalExpression("dataSetRow.SALE_DATE", 5, "'01/01/2004'"), new ConditionalExpression("dataSetRow.AMOUNT", 7, "5", "100")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    public void regressionTest78568() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_SALE_DATE");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameFilter = new String[]{"FILTER_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_SALE_DATE", 5, "'2004-03-20 00:00:00.0'"))};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test9() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameSort = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprSort = new IBaseExpression[]{new ScriptExpression("dataSetRow.SALE_DATE")};
        SortDefinition[] sortDefn = new SortDefinition[]{new SortDefinition()};
        sortDefn[0].setColumn("SORT_SALE_DATE");
        sortDefn[0].setSortDirection(1);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.FILTER_AMOUNT", 6, "400"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, bindingNameSort, bindingExprSort, sortDefn, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test10_DuplicateColName() throws Exception {
        String testSQL = "select COUNTRY, COUNTRY, CITY from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIt = queryResults.getResultIterator();
        Assert.assertTrue((boolean)resultIt.next());
        resultIt.getValue(bindingNameRow[0]);
        resultIt.getValue(bindingNameRow[1]);
    }

    @Test
    public void test11() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_2", "ROW_AMOUNT_3"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("Total.sum(row.ROW_AMOUNT,row.ROW_COUNTRY == \"US\",0)", 0), new ScriptExpression("Total.sum(row.ROW_AMOUNT,row.ROW_COUNTRY == \"CHINA\",0)", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test12() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_2", "ROW_AMOUNT_3", "ROW_AMOUNT_4", "ROW_AMOUNT_5", "ROW_AMOUNT_6", "ROW_AMOUNT_7", "ROW_AMOUNT_8", "ROW_AMOUNT_9", "ROW_AMOUNT_10", "ROW_AMOUNT_11", "ROW_AMOUNT_12", "ROW_AMOUNT_13", "ROW_AMOUNT_14", "ROW_AMOUNT_15", "ROW_AMOUNT_16", "ROW_AMOUNT_17", "ROW_AMOUNT_18", "ROW_AMOUNT_19", "ROW_AMOUNT_20", "ROW_AMOUNT_21", "ROW_AMOUNT_22", "ROW_AMOUNT_23", "ROW_AMOUNT_24"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ScriptExpression("Total.Rank(row.ROW_AMOUNT,true,null,2)", 0), new ScriptExpression("Total.Rank(row.ROW_AMOUNT,true,null,1)", 0), new ScriptExpression("Total.Rank(row.ROW_AMOUNT,true,null,Total.OVERALL)", 0), new ScriptExpression("Total.Sum(row.ROW_AMOUNT,null,2)", 0), new ScriptExpression("Total.isTopN(row.ROW_AMOUNT,1,null,2)", 0), new ScriptExpression("Total.isBottomN(row.ROW_AMOUNT,1,null,2)", 0), new ScriptExpression("Total.isTopNPercent(row.ROW_AMOUNT,50,null,2)", 0), new ScriptExpression("Total.isBottomNPercent(row.ROW_AMOUNT,50,null,2)", 0), new ScriptExpression("Total.Percentile(row.ROW_AMOUNT,0)", 0), new ScriptExpression("Total.Percentile(row.ROW_AMOUNT,1)", 0), new ScriptExpression("Total.Percentile(row.ROW_AMOUNT,0.5)", 0), new ScriptExpression("Total.Quartile(row.ROW_AMOUNT,0)", 0), new ScriptExpression("Total.Quartile(row.ROW_AMOUNT,1)", 0), new ScriptExpression("Total.Quartile(row.ROW_AMOUNT,0.5)", 0), new ScriptExpression("Total.PercentSum(row.ROW_AMOUNT,null,2)", 0), new ScriptExpression("Total.PercentSum(row.ROW_AMOUNT,null,1)", 0), new ScriptExpression("Total.PercentSum(row.ROW_AMOUNT,null,Total.OVERALL)", 0), new ScriptExpression("Total.PercentRank(row.ROW_AMOUNT,null,2)", 0), new ScriptExpression("Total.PercentRank(row.ROW_AMOUNT,null,1)", 0), new ScriptExpression("Total.PercentRank(row.ROW_AMOUNT,null,Total.OVERALL)", 0), new ScriptExpression("Total.RunningCount(null,2)", 0), new ScriptExpression("Total.RunningCount(null,1)", 0), new ScriptExpression("Total.RunningCount(null,Total.OVERALL)", 0)};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test14() throws Exception {
        this.dataSet.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row.AMOUNT", 15, "7")));
        this.dataSet.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row.AMOUNT", 4, "600")));
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_2", "ROW_AMOUNT_3"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,dataSetRow.COUNTRY == \"US\",0)", 0), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,dataSetRow.COUNTRY == \"CHINA\",0)", 0)};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COUNTRY", 1, "\"CHINA\"")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_AMOUNT", 15, "4")), new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_AMOUNT", 14, "5"))};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, filterDefn, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test15() throws Exception {
        this.dataSet.addFilter((IFilterDefinition)new FilterDefinition((IBaseExpression)new ConditionalExpression("row.AMOUNT", 15, "7")));
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_AMOUNT_2", "ROW_AMOUNT_3"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,dataSetRow.COUNTRY == \"US\",0)", 0), new ScriptExpression("Total.sum(dataSetRow.AMOUNT,dataSetRow.COUNTRY == \"CHINA\",0)", 0)};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_COUNTRY", 1, "\"CHINA\""))};
        QueryDefinition queryDefn = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, filterDefn, bindingNameRow, bindingExprRow);
        queryDefn.setMaxRows(2);
        this.executeQuery(queryDefn, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    @Ignore(value="This test is time zone dependent, and Derby does not seem to support time zones")
    public void test16() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0"), new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        String[] bindingNameFilter = new String[]{"SORT_SALE_DATE"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("row.ROW_FILTER")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_FILTER", 1, "\"Date:\"+dataSetRow.SALE_DATE"))};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_FILTER"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT"), new ScriptExpression("\"Date:\"+row.ROW_SALE_DATE")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void test17() {
        try {
            QueryDefinition query = new QueryDefinition(true);
            query.setDataSetName(this.dataSet.getName());
            GroupDefinition group = new GroupDefinition("G1");
            group.setKeyExpression("row.SALE_DATE");
            query.addGroup((IGroupDefinition)group);
            GroupDefinition group1 = new GroupDefinition("G2");
            group1.setKeyExpression("row.COUNTRY");
            query.addGroup((IGroupDefinition)group1);
            SubqueryDefinition subQuery = new SubqueryDefinition("Sub1", (IBaseQueryDefinition)query);
            Binding binding = new Binding("COUNTRY_1", (IBaseExpression)new ScriptExpression("dataSetRow.COUNTRY"));
            subQuery.addBinding((IBinding)binding);
            GroupDefinition gd = new GroupDefinition("G2");
            gd.setKeyExpression("row.COUNTRY_1");
            subQuery.addGroup((IGroupDefinition)gd);
            group.addSubquery(subQuery);
            IResultIterator it = this.executeQuery((IQueryDefinition)query);
            it.next();
            it = it.getSecondaryIterator("Sub1", null);
        }
        catch (Exception e) {
            Assert.fail((String)"Should not throw exception");
        }
    }

    @Test
    public void test18() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY + \"ABC\"");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        this.createAndRunQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void testSummaryTable() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        QueryDefinition query = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        query.setIsSummaryQuery(true);
        this.executeQuery(query, bindingNameRow);
        this.checkOutputFile();
    }

    @Test
    public void testSummaryTableWithSub() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group0")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        QueryDefinition query = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        query.setIsSummaryQuery(true);
        SubqueryDefinition sub = new SubqueryDefinition("Sub", (IBaseQueryDefinition)query);
        sub.addBinding((IBinding)new Binding("b1", bindingExprRow[2]));
        query.addSubquery(sub);
        IResultIterator resultIt = this.executeQuery((IQueryDefinition)query);
        this.testPrintln("*****A new Report Start!*****");
        while (resultIt.next()) {
            this.testPrint("S:");
            this.testPrint(Integer.toString(resultIt.getStartingGroupLevel()));
            this.testPrint(" E:");
            this.testPrint(Integer.toString(resultIt.getEndingGroupLevel()));
            this.testPrint(" ");
            int i = 0;
            while (i < bindingNameRow.length) {
                this.testPrint(this.evalAsString(bindingNameRow[i], resultIt));
                this.testPrint("    ");
                ++i;
            }
            this.testPrintln("");
            IResultIterator subIt = resultIt.getSecondaryIterator(null, "Sub");
            while (subIt.next()) {
                this.testPrintln("          " + String.valueOf(subIt.getValue("ROW_COUNTRY")));
            }
            subIt.close();
        }
        this.testPrintln("");
        this.checkOutputFile();
    }

    @Test
    public void testBasicGetParameterMetaData() throws Exception {
        String sql = "select COUNTRY, CITY from " + this.getTestTableName() + " where city = ?";
        ((OdaDataSetDesign)this.dataSet).setQueryText(sql);
        QueryDefinition queryDefn = this.newReportQuery();
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        Collection parameterMetaData = preparedQuery.getParameterMetaData();
        Assert.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (IParameterMetaData paramMd : parameterMetaData) {
            Assert.assertEquals((long)1L, (long)paramMd.getPosition());
            Assert.assertEquals((long)5L, (long)paramMd.getDataType());
            Assert.assertEquals(null, (Object)paramMd.getName());
            Assert.assertEquals((Object)"VARCHAR", (Object)paramMd.getNativeTypeName());
            Assert.assertEquals((long)0L, (long)paramMd.getScale());
            Assert.assertEquals((long)10L, (long)paramMd.getPrecision());
        }
    }

    @Test
    public void testBasicGetParameterMetaData1() throws Exception {
        String sql = "select COUNTRY, CITY from " + this.getTestTableName() + " where city = ?";
        ((OdaDataSetDesign)this.dataSet).setQueryText(sql);
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 4, true, false);
        inputParamDefn.setPosition(1);
        inputParamDefn.setDefaultInputValue("0");
        ((OdaDataSetDesign)this.dataSet).addParameter((IParameterDefinition)inputParamDefn);
        QueryDefinition queryDefn = this.newReportQuery();
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        Collection parameterMetaData = preparedQuery.getParameterMetaData();
        Assert.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (IParameterMetaData paramMd : parameterMetaData) {
            Assert.assertEquals((long)1L, (long)paramMd.getPosition());
            Assert.assertEquals((long)5L, (long)paramMd.getDataType());
            Assert.assertEquals((Object)"param1", (Object)paramMd.getName());
            Assert.assertEquals((Object)"VARCHAR", (Object)paramMd.getNativeTypeName());
            Assert.assertEquals((long)0L, (long)paramMd.getScale());
            Assert.assertEquals((long)10L, (long)paramMd.getPrecision());
        }
    }

    @Test
    public void testBasicGetParameterMetaDataDefaultValue() throws Exception {
        String sql = "select COUNTRY, CITY from " + this.getTestTableName() + " where city = ?";
        ((OdaDataSetDesign)this.dataSet).setQueryText(sql);
        ParameterDefinition inputParamDefn = new ParameterDefinition("param1", 4);
        inputParamDefn.setInputMode(true);
        inputParamDefn.setDefaultInputValue("123");
        inputParamDefn.setPosition(1);
        ((OdaDataSetDesign)this.dataSet).addParameter((IParameterDefinition)inputParamDefn);
        QueryDefinition queryDefn = this.newReportQuery();
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        Collection parameterMetaData = preparedQuery.getParameterMetaData();
        Assert.assertTrue((parameterMetaData != null && parameterMetaData.size() == 1 ? 1 : 0) != 0);
        for (IParameterMetaData paramMd : parameterMetaData) {
            Assert.assertEquals((long)1L, (long)paramMd.getPosition());
            Assert.assertEquals((long)5L, (long)paramMd.getDataType());
            Assert.assertEquals((Object)"param1", (Object)paramMd.getName());
            Assert.assertEquals((Object)"VARCHAR", (Object)paramMd.getNativeTypeName());
            Assert.assertEquals((long)0L, (long)paramMd.getScale());
            Assert.assertEquals((long)10L, (long)paramMd.getPrecision());
            Assert.assertEquals((Object)"123", (Object)paramMd.getDefaultInputValue());
        }
    }

    @Test
    public void testPassThruContext() throws Exception {
        String testSQL = "select COUNTRY, CITY from " + this.getTestTableName();
        ((OdaDataSetDesign)this.dataSet).setQueryText(testSQL);
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0)};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        HashMap<String, CallSite> appContext = new HashMap<String, CallSite>();
        appContext.put(this.dataSet.getDataSourceName(), (CallSite)((Object)testSQL));
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn, appContext);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIt = queryResults.getResultIterator();
        Assert.assertTrue((boolean)resultIt.next());
        resultIt.getValue(bindingNameRow[0]);
        resultIt.getValue(bindingNameRow[1]);
    }

    @Test
    public void testAggrExprAndInconvertibleDataType() throws Exception {
        Object[] expectedValue = new Object[]{"CHINA", Timestamp.valueOf("2004-01-01 00:00:00.0"), Integer.class};
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 5), new ScriptExpression("dataSetRow.SALE_DATE", -1), new ScriptExpression("Total.sum(dataSetRow.AMOUNT)", 2)};
        IBaseExpression[] expressions = new IBaseExpression[]{new ScriptExpression("row.COUNTRY", 5), new ScriptExpression("row.SALE_DATE", -1), new ScriptExpression("Total.sum(row.AMOUNT)", 2)};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIt = queryResults.getResultIterator();
        resultIt.next();
        int i = 0;
        while (i < expressions.length) {
            Object value = expectedValue[i];
            if (value instanceof Class) {
                Assert.assertTrue((boolean)((Class)value).isInstance(resultIt.getValue(bindingNameRow[i])));
            } else {
                Assert.assertEquals((Object)value, (Object)resultIt.getValue(bindingNameRow[i]));
            }
            ++i;
        }
        queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, new String[]{"ROW_CITY"}, new IBaseExpression[]{new ScriptExpression("dataSetRow.CITY", 2)});
        preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        queryResults = preparedQuery.execute(null);
        try {
            queryResults.getResultIterator();
            Assert.fail((String)"expected error here");
        }
        catch (DataException e) {
            Assert.assertEquals((Object)e.getErrorCode(), (Object)"data.engine.BirtException");
        }
    }

    @Test
    public void testRow0() throws Exception {
        String[] bindingNameFilter = new String[]{"ROW_0"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]", 0)};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ConditionalExpression("row.ROW_0", 6, "400"))};
        try {
            this.createAndRunQuery(null, null, null, null, null, null, bindingNameFilter, bindingExprFilter, filterDefn, null, null);
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    @Test
    public void testExprTiming() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_ORDERED", "ROW_ORDERED_2"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 5), new ScriptExpression("Total.Sum(dataSetRow.ORDERED)", 2), new ScriptExpression("Total.Sum(dataSetRow.ORDERED * 2)", 2)};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults results = preparedQuery.execute(null);
        IResultIterator it = results.getResultIterator();
        int totalOrdered = 4;
        int total1 = it.getInteger(bindingNameRow[1]);
        Assert.assertEquals((long)total1, (long)4L);
        int count = 0;
        while (it.next()) {
            ++count;
            String country = it.getString(bindingNameRow[0]);
            Assert.assertTrue((country.length() > 0 ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)count, (long)8L);
        int total2 = it.getInteger(bindingNameRow[2]);
        Assert.assertEquals((long)total2, (long)8L);
        it.close();
        try {
            it.getValue(bindingNameRow[2]);
            Assert.fail((String)"Failed: evaluation should fail after IResultIterator.close()");
        }
        catch (BirtException birtException) {
            // empty catch block
        }
        results.close();
    }

    @Test
    public void testMoveto() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0)};
        QueryDefinition queryDefn = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)queryDefn);
        IQueryResults queryResults = preparedQuery.execute(null);
        IResultIterator resultIterator = queryResults.getResultIterator();
        int destIndex = 3;
        resultIterator.next();
        resultIterator.moveTo(1);
        resultIterator.moveTo(2);
        resultIterator.moveTo(2);
        this.testPrint(this.evalAsString(bindingNameRow[0], resultIterator));
        while (resultIterator.next()) {
            int i = 0;
            while (i < bindingNameRow.length) {
                this.testPrint(this.evalAsString(bindingNameRow[i], resultIterator));
                this.testPrint("    ");
                ++i;
            }
            this.testPrintln("");
        }
        this.checkOutputFile();
    }

    @Test
    public void testResultIteratorFindGroup() throws Exception {
        ComputedColumn computedColumn = new ComputedColumn("\"doubleQuo\"", "row.CITY", 5);
        this.dataSet.addComputedColumn((IComputedColumn)computedColumn);
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_CITY", "GROUP_NULL_COLUMN"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]"), new ScriptExpression("dataSetRow[\"\\\"doubleQuo\\\"\"]"), new ScriptExpression("dataSetRow.NULL_COLUMN")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2"), new GroupDefinition("group3")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_CITY");
        groupDefn[2].setKeyExpression("row.GROUP_NULL_COLUMN");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT", "ROW_NULL_COLUMN"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0), new ScriptExpression("dataSetRow.NULL_COLUMN")};
        QueryDefinition queryDefn = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IResultIterator it = this.executeQuery((IQueryDefinition)queryDefn);
        it.next();
        this.testFindGroup(it, new Object[]{"CHINA"}, 8);
        this.testFindGroup(it, new Object[]{"CHINA", "Beijing"}, 8);
        this.testFindGroup(it, new Object[]{"CHINA", "Shanghai"}, 6);
        this.testFindGroup(it, new Object[]{"US"}, 4);
        this.testFindGroup(it, new Object[]{"US", "New York"}, 2);
        this.testFindGroup(it, new Object[]{"US", "Chicago"}, 4);
        Assert.assertFalse((boolean)it.findGroup(new Object[2]));
        Object[] objectArray = new Object[2];
        objectArray[1] = "Chicago";
        Assert.assertFalse((boolean)it.findGroup(objectArray));
        Assert.assertFalse((boolean)it.findGroup(new Object[]{"CHINA", "Chicago"}));
        Assert.assertFalse((boolean)it.findGroup(new Object[]{"Chicago"}));
        Assert.assertFalse((boolean)it.findGroup(new Object[]{"CHINA", "Shanghai", "not null"}));
        try {
            it.findGroup(new Object[4]);
            Assert.fail((String)"Should not arrive here");
        }
        catch (DataException dataException) {
            // empty catch block
        }
    }

    @Test
    public void testResultIteratorFindGroup2() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_COUNTRY", "GROUP_AMOUNT"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2")};
        groupDefn[0].setKeyExpression("row.GROUP_COUNTRY");
        groupDefn[1].setKeyExpression("row.GROUP_AMOUNT");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0)};
        QueryDefinition queryDefn = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IResultIterator it = this.executeQuery((IQueryDefinition)queryDefn);
        it.next();
        this.testFindGroup(it, new Object[]{"CHINA"}, 8);
        this.testFindGroup(it, new Object[]{"CHINA", "100"}, 8);
        this.testFindGroup(it, new Object[]{"CHINA", new Integer(100)}, 8);
        this.testFindGroup(it, new Object[]{"CHINA", "400"}, 6);
        try {
            this.testFindGroup(it, new Object[]{"CHINA", "abc"}, 6);
            Assert.fail((String)"Should convert fails");
        }
        catch (BirtException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    @Test
    public void testResultIteratorFindGroup3() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_SALE_DATE", "GROUP_AMOUNT"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"SALE_DATE\"]"), new ScriptExpression("dataSetRow.AMOUNT")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1"), new GroupDefinition("group2")};
        groupDefn[0].setKeyExpression("row.GROUP_SALE_DATE");
        groupDefn[1].setKeyExpression("row.GROUP_AMOUNT");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0)};
        QueryDefinition queryDefn = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IResultIterator it = this.executeQuery((IQueryDefinition)queryDefn);
        it.next();
        DateFormat df = DateFormat.getDateInstance((int)3, (Locale)Locale.US);
        this.testFindGroup(it, new Object[]{df.format(df.parse("05/01/2004"))}, 5);
        this.testFindGroup(it, new Object[]{df.format(df.parse("06/01/2004")), "100"}, 3);
        this.testFindGroup(it, new Object[]{df.format(df.parse("06/01/2004")), new Integer(100)}, 3);
        this.testFindGroup(it, new Object[]{df.format(df.parse("06/05/2004")), "400"}, 1);
        try {
            this.testFindGroup(it, new Object[]{"CHINA", "abc"}, 6);
            Assert.fail((String)"Should convert fails");
        }
        catch (BirtException e) {
            System.out.println(e.getLocalizedMessage());
        }
    }

    @Test
    public void testResultSetIteratorIsEmptyFalse() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        QueryDefinition queryDefination = this.createQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        IResultIterator result = this.executeQuery((IQueryDefinition)queryDefination);
        Assert.assertFalse((boolean)result.isEmpty());
    }

    @Test
    public void testResultSetIteratorIsEmptyTrue() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_AMOUNT < 0"))};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        QueryDefinition queryDefination = this.createQuery(null, null, null, null, null, null, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow);
        IResultIterator result = this.executeQuery((IQueryDefinition)queryDefination);
        Assert.assertTrue((boolean)result.isEmpty());
    }

    @Test
    public void testNestedDummyQuery() throws Exception {
        String[] bindingNameFilter = new String[]{"FILTER_AMOUNT"};
        IBaseExpression[] bindingExprFilter = new IBaseExpression[]{new ScriptExpression("dataSetRow.AMOUNT")};
        FilterDefinition[] filterDefn = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.FILTER_AMOUNT < 0"))};
        String[] bindingNameRow = new String[]{"ROW_0", "ROW_rowPosition", "ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[0]"), new ScriptExpression("dataSetRow._rowPosition"), new ScriptExpression("dataSetRow.COUNTRY"), new ScriptExpression("dataSetRow.CITY"), new ScriptExpression("dataSetRow.SALE_DATE"), new ScriptExpression("dataSetRow.AMOUNT")};
        QueryDefinition queryDefination = this.createQuery(null, null, null, null, null, null, bindingNameFilter, bindingExprFilter, filterDefn, bindingNameRow, bindingExprRow);
        IResultIterator result = this.executeQuery((IQueryDefinition)queryDefination);
        IQueryResults outer = result.getQueryResults();
        QueryDefinition dummyQd = new QueryDefinition();
        IPreparedQuery preparedQuery = this.dataEngine.prepare((IQueryDefinition)dummyQd);
        IQueryResults queryResults = preparedQuery.execute((IBaseQueryResults)outer, null);
        Assert.assertNotNull((Object)queryResults);
    }

    @Test
    public void testGroupWithNoDetails() throws Exception {
        String[] bindingNameGroup = new String[]{"GROUP_ROW_COUNTRY"};
        IBaseExpression[] bindingExprGroup = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]")};
        GroupDefinition[] groupDefn = new GroupDefinition[]{new GroupDefinition("group1")};
        groupDefn[0].setKeyExpression("row.ROW_COUNTRY");
        String[] bindingNameRow = new String[]{"ROW_COUNTRY", "ROW_CITY", "ROW_SALE_DATE", "ROW_AMOUNT"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow[\"COUNTRY\"]", 0), new ScriptExpression("dataSetRow.CITY", 0), new ScriptExpression("dataSetRow.SALE_DATE", 0), new ScriptExpression("dataSetRow.AMOUNT", 0)};
        QueryDefinition queryDefn = this.createQuery(bindingNameGroup, bindingExprGroup, groupDefn, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
        queryDefn.setUsesDetails(false);
        IResultIterator it = this.executeQuery((IQueryDefinition)queryDefn);
        while (it.next()) {
            int start1 = it.getStartingGroupLevel();
            it.getEndingGroupLevel();
            int start2 = it.getStartingGroupLevel();
            Assert.assertEquals((long)start1, (long)start2);
        }
    }

    private void testFindGroup(IResultIterator it, Object[] keyValues, int restRowCount) throws DataException, BirtException {
        Assert.assertTrue((boolean)it.findGroup(keyValues));
        int i = 1;
        while (it.next()) {
            ++i;
        }
        Assert.assertEquals((long)i, (long)restRowCount);
    }

    @Test
    public void testRowIndex() throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow._rowPosition")};
        this.createAndRunQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
    }

    @Test
    public void testFetchRowLimit1() throws Exception {
        this.fetchRowLimit(0);
    }

    @Test
    public void testFetchRowLimit2() throws Exception {
        this.fetchRowLimit(3);
    }

    @Test
    public void testFetchRowLimit3() throws Exception {
        this.fetchRowLimit(-10);
    }

    private void fetchRowLimit(int limit) throws Exception {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.COUNTRY")};
        this.dataSet.setRowFetchLimit(limit);
        FilterDefinition[] filters = new FilterDefinition[]{new FilterDefinition((IBaseExpression)new ScriptExpression("row.ROW_COUNTRY != \"CHINA\""))};
        this.createAndRunQuery(null, null, null, null, null, null, null, null, filters, bindingNameRow, bindingExprRow);
        this.checkOutputFile();
    }

    @Test
    public void testRefToInvalidDataSetColumn() {
        String[] bindingNameRow = new String[]{"ROW_COUNTRY"};
        IBaseExpression[] bindingExprRow = new IBaseExpression[]{new ScriptExpression("dataSetRow.invalid")};
        try {
            this.createAndRunQuery(null, null, null, null, null, null, null, null, null, bindingNameRow, bindingExprRow);
            Assert.fail((String)"Should not arrive here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

