/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.pojo.ui.impl.dialogs;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.data.oda.pojo.querymodel.PojoQuery;
import org.eclipse.birt.data.oda.pojo.ui.Activator;
import org.eclipse.birt.data.oda.pojo.ui.i18n.Messages;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.ClassInputDialog;
import org.eclipse.birt.data.oda.pojo.ui.impl.dialogs.ColumnMappingWizardPage;
import org.eclipse.birt.data.oda.pojo.ui.util.HelpUtil;
import org.eclipse.birt.data.oda.pojo.ui.util.Utils;
import org.eclipse.birt.data.oda.pojo.util.ClassLister;
import org.eclipse.birt.data.oda.pojo.util.PojoQueryParser;
import org.eclipse.datatools.connectivity.internal.ui.dialogs.ExceptionHandler;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.ui.wizards.DataSetWizardPage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DataSetPropertiesWizardPage
extends DataSetWizardPage {
    private static final String APP_CONTEXT_KEY_PREFIX = "APP_CONTEXT_KEY_";
    private static Logger logger = Logger.getLogger(DataSetPropertiesWizardPage.class.getName());
    private Text txtPojoDataSetClass;
    private Text txtAppContextKey;
    private DataSetDesign design;
    private URLClassLoader classLoader;
    private String[] filteredClassNames;

    private URL[] getPojoDataSetClassPath() {
        if (this.design == null) {
            return null;
        }
        DataSourceDesign dataSource = this.design.getDataSourceDesign();
        String classPath = Utils.getPublicProperty(dataSource, "pojoDataSetClassPath");
        try {
            return Utils.createURLParser(this.getHostResourceIdentifiers()).parse(classPath);
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, "Failed to parse POJO Class Path", e);
            return null;
        }
    }

    protected DataSetDesign collectDataSetDesign(DataSetDesign design) {
        if (this.getControl() == null) {
            return super.collectDataSetDesign(design);
        }
        PojoQuery pq = null;
        String query = design.getQueryText();
        if (query != null && query.length() > 0) {
            try {
                pq = PojoQueryParser.parse((String)query);
            }
            catch (OdaException e) {
                logger.log(Level.WARNING, "Failed to parse original query text:" + query, e);
            }
        }
        if (pq == null) {
            pq = new PojoQuery("1.0", this.txtPojoDataSetClass.getText().trim(), this.txtAppContextKey.getText().trim());
            Utils.savePojoQuery(pq, design, this.getControl().getShell());
        } else if (!this.txtAppContextKey.getText().trim().equals(pq.getAppContextKey()) || !this.txtPojoDataSetClass.getText().trim().equals(pq.getDataSetClass())) {
            pq.setAppContextKey(this.txtAppContextKey.getText().trim());
            pq.setDataSetClass(this.txtPojoDataSetClass.getText().trim());
            Utils.savePojoQuery(pq, design, this.getControl().getShell());
        }
        return design;
    }

    protected void refresh(DataSetDesign dataSetDesign) {
        super.refresh(dataSetDesign);
        this.design = dataSetDesign;
        this.txtAppContextKey.setText("");
        this.txtPojoDataSetClass.setText("");
        String query = dataSetDesign.getQueryText();
        PojoQuery pq = null;
        if (query != null && query.length() > 0) {
            try {
                pq = PojoQueryParser.parse((String)query);
            }
            catch (OdaException e) {
                ExceptionHandler.showException((Shell)this.getControl().getShell(), (String)Messages.getString("FailedParseQueryTitle"), (String)Messages.getFormattedString("FailedParseQueryMsg", new String[]{query}), (Throwable)e);
                this.setMessage(Messages.getString("FailedParseQueryTitle"), 3);
            }
        }
        if (pq != null) {
            if (pq.getAppContextKey() != null) {
                this.txtAppContextKey.setText(pq.getAppContextKey().trim());
            }
            if (pq.getDataSetClass() != null) {
                this.txtPojoDataSetClass.setText(pq.getDataSetClass().trim());
            }
        }
        if (this.classLoader == null) {
            this.initPageInfos();
        }
    }

    public DataSetPropertiesWizardPage(String pageName) {
        super(pageName);
        this.setMessage(Messages.getString("DataSet.PropertyPageMsg"));
        this.setPageComplete(false);
    }

    public DataSetPropertiesWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setMessage(Messages.getString("DataSet.PropertyPageMsg"));
        this.setPageComplete(false);
    }

    public void createPageCustomControl(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        topComposite.setLayout((Layout)new FillLayout(512));
        Group group = new Group(topComposite, 0);
        group.setText(Messages.getString("DataSource.RuntimeProperty"));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DataSet.PojoDataSetClass"));
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.txtPojoDataSetClass = new Text((Composite)group, 2048);
        this.txtPojoDataSetClass.setLayoutData((Object)new GridData(768));
        this.setPageComplete(false);
        this.txtPojoDataSetClass.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                this.virifyClassName();
            }

            private void virifyClassName() {
                String name = DataSetPropertiesWizardPage.this.txtPojoDataSetClass.getText().trim();
                DataSetPropertiesWizardPage.this.setMessage(Messages.getString("DataSet.PropertyPageMsg"));
                if (name.trim().length() == 0) {
                    DataSetPropertiesWizardPage.this.setMessage(Messages.getString("error.PojoDataSet.emptyClassName"), 3);
                    DataSetPropertiesWizardPage.this.setPageComplete(false);
                }
                DataSetPropertiesWizardPage.this.setPageComplete(true);
            }
        });
        Button browseButton = new Button((Composite)group, 0);
        browseButton.setText(Messages.getString("DataSet.Browse"));
        browseButton.setToolTipText(Messages.getString("DataSet.Browse.tooltip"));
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (DataSetPropertiesWizardPage.this.classLoader == null || DataSetPropertiesWizardPage.this.filteredClassNames == null) {
                    DataSetPropertiesWizardPage.this.initPageInfos();
                }
                ClassInputDialog cid = new ClassInputDialog(DataSetPropertiesWizardPage.this.getControl().getShell(), DataSetPropertiesWizardPage.this.filteredClassNames, DataSetPropertiesWizardPage.this.txtPojoDataSetClass.getText().trim());
                cid.open();
                if (cid.getInput() != null) {
                    DataSetPropertiesWizardPage.this.txtPojoDataSetClass.setText(cid.getInput().trim());
                }
            }
        });
        label = new Label((Composite)group, 0);
        label.setText(Messages.getString("DataSet.AppContextKey"));
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        this.txtAppContextKey = new Text((Composite)group, 2048);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.txtAppContextKey.setLayoutData((Object)gd);
        this.txtAppContextKey.setText(APP_CONTEXT_KEY_PREFIX + this.getInitializationDesign().getName().toUpperCase());
        this.setControl((Control)topComposite);
        this.design = this.getInitializationDesign();
        HelpUtil.setSystemHelp((Control)topComposite, "org.eclipse.birt.cshelp.Wizard_POJO_Dataset_Props_ID");
    }

    private void initPageInfos() {
        URL[] allClassPaths = this.getPojoDataSetClassPath();
        this.classLoader = new URLClassLoader(allClassPaths, Activator.class.getClassLoader());
        this.filteredClassNames = this.getFilteredClassNames(ClassLister.listClasses((URL[])allClassPaths));
    }

    private String[] getFilteredClassNames(String[] allClassNames) {
        if (allClassNames == null || allClassNames.length == 0) {
            return new String[0];
        }
        ArrayList<String> filteredClassList = new ArrayList<String>();
        int i = 0;
        while (i < allClassNames.length) {
            try {
                if (org.eclipse.birt.data.oda.pojo.util.Utils.isPojoDataSetClass(this.classLoader.loadClass(allClassNames[i]))) {
                    filteredClassList.add(allClassNames[i]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ++i;
        }
        return filteredClassList.toArray(new String[0]);
    }

    public IWizardPage getNextPage() {
        ColumnMappingWizardPage cmw;
        String pojoDataSetClass = this.txtPojoDataSetClass.getText().trim();
        IWizardPage page = super.getNextPage();
        if (page instanceof ColumnMappingWizardPage && ((cmw = (ColumnMappingWizardPage)page).getPojoDataSetClass() == null || !cmw.getPojoDataSetClass().trim().equals(pojoDataSetClass))) {
            cmw.setPojoDataSetClass(pojoDataSetClass);
            try {
                cmw.initClassStructure(this.getInitializationDesign());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.setPageComplete(true);
        return page;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete() && this.getMessageType() != 3;
    }
}

