/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.data.ui.datasource;

import org.eclipse.birt.report.designer.data.ui.util.Utility;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.model.api.DataSourceHandle;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExportDataSourceDialog
extends StatusDialog {
    private DataSourceHandle dataSourceHandle;
    private boolean doesCreateStore = false;
    private boolean isExternalToCP = true;
    private Text nameText;
    private String fileName;

    protected ExportDataSourceDialog(Shell parentShell, String title) {
        super(parentShell);
        this.setHelpAvailable(false);
        this.setTitle(title);
    }

    public ExportDataSourceDialog(Shell parentShell, String title, DataSourceHandle selection) {
        this(parentShell, title);
        this.dataSourceHandle = selection;
        this.initProfileName();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.validate();
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout parentLayout = new GridLayout();
        parentLayout.marginRight = 10;
        parentLayout.marginTop = 10;
        parentLayout.marginLeft = 10;
        parentLayout.marginBottom = 5;
        composite.setLayout((Layout)parentLayout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        Label message = new Label(composite, 1);
        message.setText(Messages.getFormattedString((String)"datasource.exportToCP.message", (Object[])new Object[]{this.dataSourceHandle.getQualifiedName()}));
        this.createSeparator(composite, 1);
        Composite content = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.numColumns = 2;
        content.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        content.setLayoutData((Object)layoutData);
        this.createCheckboxArea(content);
        this.createSeparator(content, 2);
        this.createNameText(content);
        return parent;
    }

    private void createSeparator(Composite composite, int span) {
        Label separator = new Label(composite, 258);
        GridData gd = new GridData(768);
        gd.verticalIndent = 5;
        gd.horizontalSpan = span;
        separator.setLayoutData((Object)gd);
    }

    private void createNameText(Composite content) {
        Label nameLabel = new Label(content, 32);
        nameLabel.setText(Messages.getString((String)"datasource.exportToCP.label.specifyName"));
        GridData labelData = new GridData();
        labelData.horizontalSpan = 1;
        labelData.verticalIndent = 5;
        nameLabel.setLayoutData((Object)labelData);
        this.nameText = new Text(content, 2048);
        GridData textGd = new GridData(768);
        textGd.verticalIndent = 5;
        textGd.horizontalIndent = 10;
        this.nameText.setLayoutData((Object)textGd);
        this.nameText.setText(this.fileName == null ? "" : this.fileName);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportDataSourceDialog.this.fileName = ExportDataSourceDialog.this.nameText.getText().trim();
                ExportDataSourceDialog.this.validate();
            }
        });
    }

    private void createCheckboxArea(Composite content) {
        GridData btnData1 = new GridData();
        btnData1.horizontalSpan = 2;
        Button externalButton = new Button(content, 32);
        externalButton.setText(Messages.getString((String)"datasource.exportToCP.externalCheckBox"));
        externalButton.setLayoutData((Object)btnData1);
        externalButton.setSelection(true);
        externalButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ExportDataSourceDialog.this.isExternalToCP = !ExportDataSourceDialog.this.isExternalToCP;
            }
        });
        GridData btnData2 = new GridData();
        btnData2.horizontalSpan = 2;
        Button button = new Button(content, 32);
        button.setText(Messages.getString((String)"datasource.exportToCP.checkBox"));
        button.setLayoutData((Object)btnData2);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                ExportDataSourceDialog.this.doesCreateStore = !ExportDataSourceDialog.this.doesCreateStore;
            }
        });
    }

    public boolean isExternalToCP() {
        return this.isExternalToCP;
    }

    public boolean doesCreateProfileStore() {
        return this.doesCreateStore;
    }

    public String getProfileName() {
        return this.fileName;
    }

    private void initProfileName() {
        this.fileName = this.dataSourceHandle.getQualifiedName();
        int count = 1;
        if (this.isDuplicatedName()) {
            this.fileName = String.valueOf(this.fileName) + "_" + count;
            while (this.isDuplicatedName()) {
                this.fileName = this.fileName.substring(0, this.fileName.length() - 1) + ++count;
            }
        }
    }

    private void validate() {
        Status status = this.fileName == null || this.fileName.trim().length() == 0 ? this.getMiscStatus(4, Messages.getString((String)"datasource.exportToCP.error.emptyFileName")) : (this.containInvalidCharactor(this.fileName) ? this.getMiscStatus(4, Messages.getString((String)"datasource.exportToCP.error.invalidFileName")) : (this.isDuplicatedName() ? this.getMiscStatus(4, Messages.getString((String)"datasource.exportToCP.error.duplicatedFileName")) : this.getOKStatus()));
        this.updateStatus((IStatus)status);
    }

    private boolean isDuplicatedName() {
        return !this.fileName.equals(this.dataSourceHandle.getName()) && Utility.checkDataSourceName((String)this.fileName) || OdaProfileExplorer.isProfileNameUsed((String)this.fileName);
    }

    private boolean containInvalidCharactor(String name) {
        if (name == null) {
            return false;
        }
        return name.indexOf(".") > -1 || name.indexOf("\\") > -1 || name.indexOf("/") > -1 || name.indexOf("!") > -1 || name.indexOf(";") > -1 || name.indexOf(",") > -1;
    }

    protected Status getOKStatus() {
        return this.getMiscStatus(0, "");
    }

    protected Status getMiscStatus(int severity, String message) {
        return new Status(severity, "org.eclipse.ui", severity, message, null);
    }
}

