/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core;

import java.io.IOException;
import org.eclipse.birt.report.model.api.DesignConfig;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DesignEngine;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.FactoryPropertyHandle;
import org.eclipse.birt.report.model.api.LabelHandle;
import org.eclipse.birt.report.model.api.LibraryHandle;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.BackRef;
import org.eclipse.birt.report.model.core.CoreTestUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyleElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyledElementTest
extends BaseTestCase {
    StyledElement styledElement;
    ElementRefValue styleRef;
    Style style;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.styledElement = new Label();
        this.style = new Style();
        this.styleRef = new ElementRefValue(null, (DesignElement)this.style);
    }

    public void testSetStyle() {
        StyledElementTest.assertNull((Object)this.styledElement.getStyle((Module)this.design));
        this.styledElement.setStyle((StyleElement)this.style);
        StyledElementTest.assertEquals((Object)this.style, (Object)this.styledElement.getStyle((Module)this.design));
        StyledElementTest.assertEquals((Object)this.styledElement, (Object)((BackRef)this.style.getClientList().get(0)).getElement());
    }

    public void testGetIntrinsicProperty() {
        this.styledElement.setName("styled element");
        Object o = CoreTestUtil.getIntrinsicProperty((DesignElement)this.styledElement, (String)"name");
        StyledElementTest.assertEquals((Object)"styled element", (Object)o);
        this.style.setName("style");
        o = CoreTestUtil.getIntrinsicProperty((DesignElement)this.styledElement, (String)"style");
        StyledElementTest.assertNull((Object)o);
        this.styledElement.setStyle((StyleElement)this.style);
        o = CoreTestUtil.getIntrinsicProperty((DesignElement)this.styledElement, (String)"style");
        StyledElementTest.assertEquals((Object)this.style, (Object)((ElementRefValue)o).getElement());
        Label label1 = new Label();
        Label label2 = new Label();
        label2.setName("hexingjie");
        label1.setExtendsElement((DesignElement)label2);
        ElementRefValue elementRefValue = (ElementRefValue)CoreTestUtil.getIntrinsicProperty((DesignElement)label1, (String)"extends");
        StyledElementTest.assertEquals((String)"hexingjie", (String)elementRefValue.getElement().getName());
    }

    public void testStyleProperty() throws Exception {
        this.sessionHandle = new DesignEngine(new DesignConfig()).newSessionHandle(null);
        this.designHandle = this.sessionHandle.createDesign();
        this.design = (ReportDesign)this.designHandle.getModule();
        SharedStyleHandle style1 = this.designHandle.getElementFactory().newStyle("style-one");
        SharedStyleHandle style2 = this.designHandle.getElementFactory().newStyle("style-two");
        this.designHandle.getStyles().add((DesignElementHandle)style1);
        this.designHandle.getStyles().add((DesignElementHandle)style2);
        LabelHandle label = this.designHandle.getElementFactory().newLabel("label");
        LabelHandle parent = this.designHandle.getElementFactory().newLabel("parent");
        this.designHandle.getBody().add((DesignElementHandle)label);
        this.designHandle.getComponents().add((DesignElementHandle)parent);
        StyledElementTest.assertNull((Object)label.getStyle());
        StyledElementTest.assertNull((Object)((StyledElement)label.getElement()).getStyle((Module)this.design));
        StyledElementTest.assertNull((Object)((StyledElement)label.getElement()).getStyleName());
        label.setStyle(style1);
        StyledElementTest.assertEquals((Object)style1, (Object)label.getStyle());
        StyledElementTest.assertEquals((Object)style1.getElement(), (Object)((StyledElement)label.getElement()).getStyle((Module)this.design));
        StyledElementTest.assertEquals((String)style1.getName(), (String)((StyledElement)label.getElement()).getStyleName());
        style1.drop();
        StyledElementTest.assertNull((Object)this.designHandle.findStyle(style1.getName()));
        StyledElementTest.assertNull((Object)label.getStyle());
        StyledElementTest.assertNull((Object)((StyledElement)label.getElement()).getStyle((Module)this.design));
        StyledElementTest.assertEquals((String)style1.getName(), (String)((StyledElement)label.getElement()).getStyleName());
        label.setStyle(null);
        StyledElementTest.assertNull((Object)label.getStyle());
        StyledElementTest.assertNull((Object)((StyledElement)label.getElement()).getStyle((Module)this.design));
        StyledElementTest.assertNull((Object)((StyledElement)label.getElement()).getStyleName());
    }

    public void testGetFactoryProperty() throws DesignFileException, SemanticException, IOException {
        this.openDesign("StyledElementTest.xml");
        LabelHandle label1 = (LabelHandle)this.designHandle.findElement("insideLabel1");
        LabelHandle label2 = (LabelHandle)this.designHandle.findElement("insideLabel2");
        LabelHandle label3 = (LabelHandle)this.designHandle.findElement("insideLabel3");
        LabelHandle label4 = (LabelHandle)this.designHandle.findElement("insideLabel4");
        FactoryPropertyHandle factoryColorPropHandle1 = label1.getFactoryPropertyHandle("color");
        FactoryPropertyHandle factoryColorPropHandle2 = label2.getFactoryPropertyHandle("color");
        FactoryPropertyHandle factoryColorPropHandle3 = label3.getFactoryPropertyHandle("color");
        FactoryPropertyHandle factoryColorPropHandle4 = label4.getFactoryPropertyHandle("color");
        StyledElementTest.assertEquals((Object)"yellow", (Object)factoryColorPropHandle1.getValue());
        StyledElementTest.assertEquals((Object)"green", (Object)factoryColorPropHandle2.getValue());
        StyledElementTest.assertEquals((Object)"red", (Object)factoryColorPropHandle3.getValue());
        StyledElementTest.assertEquals((Object)"blue", (Object)factoryColorPropHandle4.getValue());
        StyledElementTest.assertEquals((Object)"yellow", (Object)label1.getProperty("color"));
        StyledElementTest.assertEquals((Object)"green", (Object)label2.getProperty("color"));
        StyledElementTest.assertEquals((Object)"red", (Object)label3.getProperty("color"));
        this.designHandle.getStyles().drop((DesignElementHandle)this.designHandle.findStyle("label"));
        StyledElementTest.assertEquals((Object)"gray", (Object)label3.getProperty("color"));
        StyledElementTest.assertEquals(null, (Object)label3.getFactoryPropertyHandle("color"));
        this.designHandle.includeLibrary("Library_1.xml", "newLib");
        LibraryHandle lib = this.designHandle.getLibrary("newLib");
        StyledElementTest.assertNotNull((Object)lib);
        ThemeHandle theme = (ThemeHandle)lib.getThemes().get(0);
        this.designHandle.setTheme(theme);
        StyleHandle style = (StyleHandle)theme.getStyles().get(0);
        StyledElementTest.assertEquals((String)"style1", (String)style.getName());
        TableHandle table = this.designHandle.getElementFactory().newTableItem("myTable");
        this.designHandle.getBody().add((DesignElementHandle)table);
        table.setStyle((SharedStyleHandle)style);
        StyledElementTest.assertEquals((Object)"red", (Object)table.getProperty("color"));
        StyledElementTest.assertEquals((Object)"red", (Object)table.getFactoryPropertyHandle("color").getValue());
        TableHandle parentTable = this.designHandle.getElementFactory().newTableItem("parent");
        this.designHandle.getComponents().add((DesignElementHandle)parentTable);
        parentTable.setProperty("backgroundColor", (Object)"red");
        TableHandle childTable = this.designHandle.getElementFactory().newTableItem("child");
        this.designHandle.getBody().add((DesignElementHandle)childTable);
        StyledElementTest.assertNull((Object)childTable.getFactoryPropertyHandle("backgroundColor"));
        childTable.setExtends((DesignElementHandle)parentTable);
        StyledElementTest.assertEquals((Object)"red", (Object)childTable.getFactoryPropertyHandle("backgroundColor").getValue());
    }
}

