/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import org.eclipse.birt.report.model.api.AutoTextHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.SharedStyleHandle;
import org.eclipse.birt.report.model.api.SimpleMasterPageHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class AutoTextHandleTest
extends BaseTestCase {
    private static final String INPUT_FILE = "AutoTextHandleTest.xml";
    private static final String OUTPUT_FILE = "AutoTextHandleTest_golden.xml";
    private static final String INPUT_FILE_ONE = "AutoTextHandleTest_1.xml";
    private static final String INPUT_FILE_TWO = "AutoTextHandleTest_2.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testAutoTextValue() throws Exception {
        this.openDesign(INPUT_FILE_ONE);
        AutoTextHandle autoText = (AutoTextHandle)this.designHandle.findElement("sf1");
        String autotext = autoText.getAutoTextType();
        AutoTextHandleTest.assertEquals((String)"page-number", (String)autotext);
        String displayName = autoText.getDisplayLabel(2);
        AutoTextHandleTest.assertEquals((String)"Page Number", (String)displayName);
        autoText.setAutoTextType("total-page");
        displayName = autoText.getDisplayLabel();
        AutoTextHandleTest.assertEquals((String)"Total Page", (String)displayName);
        AutoTextHandleTest.assertEquals((String)"Total Page", (String)autoText.getDisplayLabel(2));
        AutoTextHandleTest.assertEquals((String)"test", (String)autoText.getPageVariable());
    }

    public void testAddNewAutoText() throws Exception {
        this.openDesign(INPUT_FILE);
        ElementFactory factory = new ElementFactory((Module)this.design);
        AutoTextHandle sf = factory.newAutoText("sf1");
        sf.setAutoTextType("page-variable");
        SimpleMasterPageHandle smpHandle = (SimpleMasterPageHandle)this.designHandle.findMasterPage("My Page");
        smpHandle.addElement((DesignElementHandle)sf, 0);
        SharedStyleHandle reportSelector = factory.newStyle("myStyle");
        reportSelector.setNumberFormat("hexingjie");
        reportSelector.setNumberFormatCategory("Currency");
        this.designHandle.getStyles().add((DesignElementHandle)reportSelector);
        sf.setStyleName("myStyle");
        sf.setPageVariable("test");
        this.save();
        AutoTextHandleTest.assertTrue((boolean)this.compareFile(OUTPUT_FILE));
    }

    public void testAutoTextDisplayValue() throws Exception {
        this.openDesign(INPUT_FILE_TWO);
        AutoTextHandle autoText = (AutoTextHandle)this.designHandle.findElement("sf1");
        String displayName = autoText.getDisplayLabel(2);
        AutoTextHandleTest.assertEquals((String)"page-variable", (String)autoText.getAutoTextType());
        AutoTextHandleTest.assertEquals((String)"Report Variable(a)", (String)displayName);
        autoText = (AutoTextHandle)this.designHandle.findElement("sf2");
        displayName = autoText.getDisplayLabel(2);
        AutoTextHandleTest.assertEquals((String)"page-variable", (String)autoText.getAutoTextType());
        AutoTextHandleTest.assertEquals((String)"Page Variable(b)", (String)displayName);
    }
}

