/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.odf;

import java.util.HashSet;
import org.eclipse.birt.report.engine.content.IAutoTextContent;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.css.engine.value.FloatValue;
import org.eclipse.birt.report.engine.emitter.EmitterUtil;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.w3c.dom.css.CSSValue;

public class OdfUtil {
    private static HashSet<Character> splitChar = new HashSet();
    public static final float INCH_PT = 72.0f;
    public static final double PT_TWIPS = 20.0;
    public static final double INCH_TWIPS = 1440.0;

    static {
        splitChar.add(Character.valueOf(' '));
        splitChar.add(Character.valueOf('\r'));
        splitChar.add(Character.valueOf('\n'));
    }

    public static String validBookmarkName(String name) {
        return name.replace('\"', '_');
    }

    public static int convertTo(DimensionType value, int prefValue, int dpi) {
        if (value == null) {
            return prefValue;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return (int)((double)prefValue * value.getMeasure() / 100.0);
        }
        return (int)OdfUtil.convertTo(value, dpi);
    }

    public static double convertTo(DimensionType value, double prefValue, int dpi) {
        if (value == null) {
            return prefValue;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return prefValue * value.getMeasure() / 100.0;
        }
        return OdfUtil.convertTo(value, dpi);
    }

    public static double convertTo(DimensionType value, int dpi) {
        double INCH_PX = dpi;
        if (value == null || "%".equalsIgnoreCase(value.getUnits())) {
            return -1.0;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / INCH_PX;
        }
        if ("em".equalsIgnoreCase(value.getUnits()) || "ex".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() * 12.0 / INCH_PX;
        }
        double val = value.convertTo("in");
        return val;
    }

    public static double convertImageSize(DimensionType value, int ref, int dpi) {
        if (value == null) {
            return (double)ref / (double)dpi;
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / (double)dpi;
        }
        if ("%".equalsIgnoreCase(value.getUnits())) {
            return value.getMeasure() / 100.0 * (double)ref / (double)dpi;
        }
        return value.convertTo("in");
    }

    public static double twipToPt(double t) {
        return t / 20.0;
    }

    public static int parseFontSize(float value) {
        return Math.round(value / 1000.0f);
    }

    public static String parseColor(String color) {
        String sColor = EmitterUtil.parseColor((String)color);
        if (sColor != null) {
            return "#" + sColor;
        }
        return null;
    }

    public static String[] parseBackgroundSize(String height, String width, int imageWidth, int imageHeight, double pageWidth, double pageHeight) {
        Object actualHeight = height;
        Object actualWidth = width;
        if (height == null || "auto".equalsIgnoreCase(height)) {
            actualHeight = String.valueOf(pageHeight) + "pt";
        }
        if (width == null || "auto".equalsIgnoreCase(width)) {
            actualWidth = String.valueOf(pageWidth) + "pt";
        }
        actualHeight = ((String)actualHeight).trim();
        if ("contain".equalsIgnoreCase((String)(actualWidth = ((String)actualWidth).trim())) || "contain".equalsIgnoreCase((String)actualHeight)) {
            double rh = (double)imageHeight / pageHeight;
            double rw = (double)imageWidth / pageWidth;
            if (rh > rw) {
                actualHeight = String.valueOf(pageHeight) + "pt";
                actualWidth = String.valueOf((double)imageWidth * pageHeight / (double)imageHeight) + "pt";
            } else {
                actualWidth = String.valueOf(pageWidth) + "pt";
                actualHeight = String.valueOf((double)imageHeight * pageWidth / (double)imageWidth) + "pt";
            }
        } else if ("cover".equals(actualWidth) || "cover".equals(actualHeight)) {
            double rh = (double)imageHeight / pageHeight;
            double rw = (double)imageWidth / pageWidth;
            if (rh > rw) {
                actualWidth = String.valueOf(pageWidth) + "pt";
                actualHeight = String.valueOf((double)imageHeight * pageWidth / (double)imageWidth) + "pt";
            } else {
                actualHeight = String.valueOf(pageHeight) + "pt";
                actualWidth = String.valueOf((double)imageWidth * pageHeight / (double)imageHeight) + "pt";
            }
        }
        if (height != null && height.endsWith("%")) {
            actualHeight = OdfUtil.getPercentValue(height, pageHeight) + "pt";
        }
        if (width != null && width.endsWith("%")) {
            actualWidth = OdfUtil.getPercentValue(width, pageWidth) + "pt";
        }
        return new String[]{actualHeight, actualWidth};
    }

    private static String getPercentValue(String height, double pageHeight) {
        String value = null;
        try {
            String percent = height.substring(0, height.length() - 1);
            int percentValue = Integer.parseInt(percent);
            value = String.valueOf(pageHeight * (double)percentValue / 100.0);
        }
        catch (NumberFormatException e) {
            value = height;
        }
        return value;
    }

    public static boolean isField(int autoTextType) {
        return autoTextType == 1 || autoTextType == 0;
    }

    public static boolean isField(IContent content) {
        if (content.getContentType() == 12) {
            IAutoTextContent autoText = (IAutoTextContent)content;
            int type = autoText.getType();
            return OdfUtil.isField(type);
        }
        return false;
    }

    public static double getDimensionValue(CSSValue value, int dpi) {
        if (value != null && value instanceof FloatValue) {
            FloatValue fv = (FloatValue)value;
            float v = fv.getFloatValue();
            switch (fv.getPrimitiveType()) {
                case 6: {
                    return (double)v / 2.54;
                }
                case 8: {
                    return v;
                }
                case 7: {
                    return (double)v / 25.4;
                }
                case 10: {
                    return v * 12.0f * 1000.0f;
                }
                case 5: {
                    return v / (float)dpi;
                }
                case 9: {
                    return v / 72.0f;
                }
                case 1: {
                    return v;
                }
            }
        }
        return 0.0;
    }

    public static String getValue(String val) {
        if (val == null) {
            return "NULL";
        }
        if (val.charAt(0) == '\"' && val.charAt(val.length() - 1) == '\"') {
            return val.substring(1, val.length() - 1);
        }
        return val;
    }

    public static int convertDimensionType(DimensionType value, float parent, float dpi) {
        float INCH_PX = dpi;
        float PX_PT = 72.0f / INCH_PX;
        if (value == null) {
            return (int)parent;
        }
        if ("%".equals(value.getUnits())) {
            return (int)(value.getMeasure() / 100.0 * (double)parent);
        }
        if ("px".equalsIgnoreCase(value.getUnits())) {
            return (int)(value.getMeasure() * (double)PX_PT * 1000.0);
        }
        if ("em".equalsIgnoreCase(value.getUnits()) || "ex".equalsIgnoreCase(value.getUnits())) {
            return (int)(value.getMeasure() * 12.0 * 1000.0);
        }
        return (int)(value.convertTo("pt") * 1000.0);
    }
}

