/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.internal.common.XMLResource;

public class EARFileUtil {
    private EARFileUtil() {
    }

    public static List getIncompatible13ModuleFiles(EARFile earFile) {
        if (EARFileUtil.isJ2EE13(earFile)) {
            return Collections.EMPTY_LIST;
        }
        List moduleFiles = earFile.getModuleFiles();
        ArrayList<ModuleFile> result = new ArrayList<ModuleFile>();
        int i = 0;
        while (i < moduleFiles.size()) {
            ModuleFile aModuleFile = (ModuleFile)moduleFiles.get(i);
            if (EARFileUtil.isJ2EE13(aModuleFile)) {
                result.add(aModuleFile);
            }
            ++i;
        }
        return result;
    }

    public static List getIncompatible14ModuleFiles(EARFile earFile) {
        if (EARFileUtil.isJ2EE14(earFile)) {
            return Collections.EMPTY_LIST;
        }
        List moduleFiles = earFile.getModuleFiles();
        ArrayList<ModuleFile> result = new ArrayList<ModuleFile>();
        int i = 0;
        while (i < moduleFiles.size()) {
            ModuleFile aModuleFile = (ModuleFile)moduleFiles.get(i);
            if (EARFileUtil.isJ2EE14(aModuleFile)) {
                result.add(aModuleFile);
            }
            ++i;
        }
        return result;
    }

    public static boolean isJ2EE13(ModuleFile aModuleFile) {
        try {
            XMLResource xmlResource = (XMLResource)aModuleFile.getDeploymentDescriptorResource();
            return xmlResource.getJ2EEVersionID() == 13;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }

    public static boolean isJ2EE14(ModuleFile aModuleFile) {
        try {
            XMLResource xmlResource = (XMLResource)aModuleFile.getDeploymentDescriptorResource();
            return xmlResource.getJ2EEVersionID() == 14;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
    }
}

