/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation.function;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import org.eclipse.birt.data.engine.api.timefunction.IPeriodsFunction;
import org.eclipse.birt.data.engine.api.timefunction.ReferenceDate;
import org.eclipse.birt.data.engine.api.timefunction.TimeMember;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.AbstractMDX;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.function.TimeFunctionFactory;
import org.junit.Test;
import testutil.BaseTestCase;

public class QuarterToDateFunctionTest
extends BaseTestCase {
    private void printResult(List<TimeMember> resultMember) throws IOException {
        int i = 0;
        while (i < resultMember.size()) {
            int[] resultValues = resultMember.get(i).getMemberValue();
            int j = 0;
            while (j < resultValues.length) {
                this.testPrint(String.valueOf(resultValues[j]));
                this.testPrint(" ");
                ++j;
            }
            this.testPrint("\n");
            ++i;
        }
    }

    @Test
    public void testFunctions() throws IOException {
        int[] values = new int[]{2002, 2};
        String[] levels = new String[]{"year", "quarter"};
        TimeMember member = new TimeMember(values, levels);
        List resultMember = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)false).getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions1() throws IOException {
        int[] values = new int[]{2002, 8};
        String[] levels = new String[]{"year", "month"};
        TimeMember member = new TimeMember(values, levels);
        List resultMember = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)false).getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions2() throws IOException {
        int[] values = new int[]{2002, 3, 9};
        String[] levels = new String[]{"year", "quarter", "month"};
        TimeMember member = new TimeMember(values, levels);
        List resultMember = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)false).getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions3() throws IOException {
        int[] values = new int[]{2002, 3, 8, 18};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        List resultMember = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)false).getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions4() throws IOException {
        int[] values = new int[]{2002, 3, 8, 3};
        String[] levels = new String[]{"year", "quarter", "month", "week-of-month"};
        TimeMember member = new TimeMember(values, levels);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2002, 7, 20));
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)false);
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List resultMember = periodsFunction.getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions5() throws IOException {
        int[] values = new int[]{2002, 3, 8, 3};
        String[] levels = new String[]{"year", "quarter", "month", "week-of-month"};
        TimeMember member = new TimeMember(values, levels);
        ReferenceDate referenceDate = new ReferenceDate(new Date(2002, 7, 20));
        IPeriodsFunction periodsFunction = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)true);
        ((AbstractMDX)periodsFunction).setReferenceDate(referenceDate);
        List resultMember = periodsFunction.getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions6() throws IOException {
        int[] values = new int[]{2002, 3, 8, 18};
        String[] levels = new String[]{"year", "quarter", "month", "day-of-month"};
        TimeMember member = new TimeMember(values, levels);
        List resultMember = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)true).getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }

    @Test
    public void testFunctions7() throws IOException {
        int[] values = new int[]{2002, 8};
        String[] levels = new String[]{"year", "month"};
        TimeMember member = new TimeMember(values, levels);
        List resultMember = TimeFunctionFactory.createPeriodsToDateFunction((String)"quarter", (boolean)true).getResult(member);
        this.printResult(resultMember);
        this.checkOutputFile();
    }
}

