/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.navigator.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.datatools.connectivity.internal.ConnectivityPlugin;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

public class ExpandAllActionDelegate
implements IViewActionDelegate {
    private final int EXPAND_TO_LEVEL = 25;
    private IViewPart view;
    private Display currentDisplay = Display.getCurrent();
    private CommonViewer cViewer;
    private static boolean mDebug = ConnectivityPlugin.getDefault().isDebugging();

    public void init(IViewPart view) {
        this.view = view;
        if (this.view instanceof CommonNavigator) {
            CommonNavigator navigator = (CommonNavigator)this.view;
            this.cViewer = navigator.getCommonViewer();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void checkCancelled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private void handleOuterExpand2(final IProgressMonitor monitor) throws InterruptedException {
        if (this.currentDisplay != null) {
            final Tree tree = this.cViewer.getTree();
            this.currentDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    int count = tree.getItemCount();
                    monitor.beginTask(ConnectivityUIPlugin.getDefault().getResourceString("DSE.Jobs.ExpandAll.label"), count);
                }
            });
            this.currentDisplay.syncExec(new Runnable(){

                @Override
                public void run() {
                    TreeItem[] children = tree.getItems();
                    int i = 0;
                    while (i < children.length) {
                        ExpandAllActionDelegate.this.processChild(monitor, children[i]);
                        monitor.worked(1);
                        Display.getCurrent().readAndDispatch();
                        try {
                            ExpandAllActionDelegate.this.checkCancelled(monitor);
                        }
                        catch (InterruptedException interruptedException) {
                            break;
                        }
                        ++i;
                    }
                }
            });
        }
    }

    private void processChild(IProgressMonitor monitor, TreeItem item) {
        String subTask = ConnectivityUIPlugin.getDefault().getResourceString("DSE.Jobs.ExpandAll.Subtask.label", new String[]{item.getText()});
        monitor.subTask(subTask);
        this.cViewer.setSelection((ISelection)new StructuredSelection((Object)item), true);
        long start = System.currentTimeMillis();
        this.expandToLevel2(this.cViewer, item, monitor, 25);
        try {
            this.checkCancelled(monitor);
        }
        catch (InterruptedException interruptedException) {}
        long check = System.currentTimeMillis();
        ExpandAllActionDelegate.debug("took " + (check - start) + " ms expanding " + item.getText());
        item.getItemCount();
    }

    private void expandToLevel2(CommonViewer viewer, TreeItem item, IProgressMonitor monitor, int count) {
        String subTask = ConnectivityUIPlugin.getDefault().getResourceString("DSE.Jobs.ExpandAll.Subtask.label", new String[]{item.getText()});
        ExpandAllActionDelegate.debug("expanding..." + item.getText() + "... to level " + count);
        monitor.subTask(subTask);
        if (item.getData() == null) {
            return;
        }
        viewer.setSelection((ISelection)new StructuredSelection(item.getData()), true);
        viewer.setExpandedState(item.getData(), true);
        if (item.getItemCount() > 0) {
            TreeItem[] children = item.getItems();
            Display.getCurrent().readAndDispatch();
            if (monitor.isCanceled()) {
                return;
            }
            int tempCount = this.getCurrentExpandedLevelForItem(viewer, item);
            if (tempCount < count) {
                int i = 0;
                while (i < children.length) {
                    this.expandToLevel2(viewer, children[i], monitor, count);
                    Display.getCurrent().readAndDispatch();
                    try {
                        this.checkCancelled(monitor);
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                    ++i;
                }
            }
        }
        Display.getCurrent().readAndDispatch();
        try {
            this.checkCancelled(monitor);
        }
        catch (InterruptedException interruptedException) {}
    }

    public void run(IAction action) {
        CommonNavigator navigator = (CommonNavigator)this.view;
        OuterJob job = new OuterJob();
        job.setUser(true);
        PlatformUI.getWorkbench().getProgressService().showInDialog(navigator.getSite().getShell(), (Job)job);
        job.schedule();
    }

    private int getCurrentExpandedLevelForItem(CommonViewer viewer, Object item) {
        int count = 1;
        if (item instanceof TreeItem) {
            TreeItem tempItem = (TreeItem)item;
            while (tempItem.getParentItem() != null) {
                tempItem = tempItem.getParentItem();
                ++count;
            }
        } else {
            Object tempItem = item;
            ITreeContentProvider itcp = (ITreeContentProvider)viewer.getContentProvider();
            while (itcp.getParent(tempItem) != null) {
                tempItem = itcp.getParent(tempItem);
                ++count;
            }
        }
        return count;
    }

    public static void debug(String msg) {
        if (mDebug) {
            System.out.println("Debug: " + msg);
        }
    }

    private class OuterJob
    extends Job {
        public OuterJob() {
            super(ConnectivityUIPlugin.getDefault().getResourceString("DSE.Jobs.ExpandAll.label"));
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                ExpandAllActionDelegate.this.handleOuterExpand2(monitor);
            }
            catch (Throwable throwable) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

