/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.sql.PreparedStatement;
import org.eclipse.birt.report.data.oda.jdbc.Connection;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.birt.report.data.oda.jdbc.TestUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResultSetMetaDataTest {
    private Connection conn1 = null;
    private Connection conn2 = null;
    private Statement stmt1 = null;
    private Statement stmt2 = null;
    private ResultSet rs = null;
    private ResultSetMetaData rsmd_ResultSet = null;
    private ResultSetMetaData rsmd_Statement = null;
    private java.sql.Connection jdbcConn1 = null;
    private java.sql.Connection jdbcConn2 = null;
    private java.sql.Statement jdbcStmt = null;
    private PreparedStatement jdbcPreparedStmt = null;
    private java.sql.ResultSet jdbcRs = null;
    private java.sql.ResultSetMetaData jdbcRsmd_ResultSet = null;
    private java.sql.ResultSetMetaData jdbcRsmd_PreparedStmt = null;

    @Before
    public void resultSetMetaDataSetUp() throws Exception {
        TestUtil.createTestData();
        this.conn1 = TestUtil.openConnection();
        this.conn2 = TestUtil.openConnection();
        this.stmt1 = (Statement)this.conn1.newQuery("");
        this.stmt2 = (Statement)this.conn2.newQuery("");
        String sql = "select * from \"test_oda_jdbc\"";
        this.stmt1.prepare(sql);
        this.rs = (ResultSet)this.stmt1.executeQuery();
        this.rsmd_ResultSet = (ResultSetMetaData)this.rs.getMetaData();
        this.stmt2.prepare(sql);
        this.rsmd_Statement = (ResultSetMetaData)this.stmt2.getMetaData();
        this.jdbcConn1 = TestUtil.openJDBCConnection();
        this.jdbcConn2 = TestUtil.openJDBCConnection();
        this.jdbcStmt = this.jdbcConn1.createStatement();
        this.jdbcRs = this.jdbcStmt.executeQuery(sql);
        this.jdbcRsmd_ResultSet = this.jdbcRs.getMetaData();
        this.jdbcPreparedStmt = this.jdbcConn2.prepareStatement(sql);
        this.jdbcRsmd_PreparedStmt = this.jdbcPreparedStmt.getMetaData();
    }

    @After
    public void resultSetMetaDataTearDown() throws Exception {
        this.rs.close();
        this.stmt1.close();
        this.stmt2.close();
        this.conn1.close();
        this.conn2.close();
        this.jdbcRs.close();
        this.jdbcStmt.close();
        this.jdbcConn1.close();
        this.jdbcConn2.close();
        TestUtil.deleteTestData();
    }

    @Test
    public void testGetColumnCount_ResultSet() throws Exception {
        Assert.assertEquals((long)this.rsmd_ResultSet.getColumnCount(), (long)this.jdbcRsmd_ResultSet.getColumnCount());
    }

    @Test
    public void testGetColumnName_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            System.out.println("i = " + i);
            System.out.println("rsmd_ResultSet getColumnName  = " + this.rsmd_ResultSet.getColumnName(i));
            Assert.assertEquals((Object)this.rsmd_ResultSet.getColumnName(i), (Object)this.jdbcRsmd_ResultSet.getColumnName(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnLabel_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            Assert.assertEquals((Object)this.rsmd_ResultSet.getColumnLabel(i), (Object)this.jdbcRsmd_ResultSet.getColumnLabel(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnType_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            if (this.jdbcRsmd_ResultSet.getColumnType(i) == 3) {
                Assert.assertEquals((long)this.rsmd_ResultSet.getColumnType(i), (long)this.testDataTypeConversion(this.jdbcRsmd_ResultSet.getColumnType(i), this.jdbcRsmd_ResultSet.getScale(i), this.jdbcRsmd_ResultSet.getPrecision(i)));
            } else {
                Assert.assertEquals((long)this.rsmd_ResultSet.getColumnType(i), (long)this.jdbcRsmd_ResultSet.getColumnType(i));
            }
            ++i;
        }
    }

    @Test
    public void testGetColumnTypeName_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            Assert.assertEquals((Object)this.rsmd_ResultSet.getColumnTypeName(i), (Object)this.jdbcRsmd_ResultSet.getColumnTypeName(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnDisplayLength_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_ResultSet.getColumnDisplayLength(i), (long)this.jdbcRsmd_ResultSet.getColumnDisplaySize(i));
            ++i;
        }
    }

    @Test
    public void testGetPrecision_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_ResultSet.getPrecision(i), (long)this.jdbcRsmd_ResultSet.getPrecision(i));
            ++i;
        }
    }

    @Test
    public void testGetScale_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_ResultSet.getScale(i), (long)this.jdbcRsmd_ResultSet.getScale(i));
            ++i;
        }
    }

    @Test
    public void testIsNullable_ResultSet() throws Exception {
        int i = 1;
        while (i < this.rsmd_ResultSet.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_ResultSet.isNullable(i), (long)this.jdbcRsmd_ResultSet.isNullable(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnCount_Statment() throws Exception {
        Assert.assertEquals((long)this.rsmd_Statement.getColumnCount(), (long)this.jdbcRsmd_PreparedStmt.getColumnCount());
    }

    @Test
    public void testGetColumnName_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((Object)this.rsmd_Statement.getColumnName(i), (Object)this.jdbcRsmd_PreparedStmt.getColumnName(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnLabel_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((Object)this.rsmd_Statement.getColumnLabel(i), (Object)this.jdbcRsmd_PreparedStmt.getColumnLabel(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnType_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            if (this.jdbcRsmd_PreparedStmt.getColumnType(i) == 3) {
                Assert.assertEquals((long)this.rsmd_Statement.getColumnType(i), (long)this.testDataTypeConversion(this.jdbcRsmd_PreparedStmt.getColumnType(i), this.jdbcRsmd_PreparedStmt.getScale(i), this.jdbcRsmd_PreparedStmt.getPrecision(i)));
            } else {
                Assert.assertEquals((long)this.rsmd_Statement.getColumnType(i), (long)this.jdbcRsmd_PreparedStmt.getColumnType(i));
            }
            ++i;
        }
    }

    public int testDataTypeConversion(int reType, int scale, int precision) {
        if (scale == 0 && precision > 0 && precision <= 9) {
            reType = 4;
        } else if (precision > 9 && precision < 308) {
            reType = 8;
        } else if (precision >= 308) {
            reType = 3;
        }
        return reType;
    }

    @Test
    public void testGetColumnTypeName_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((Object)this.rsmd_Statement.getColumnTypeName(i), (Object)this.jdbcRsmd_PreparedStmt.getColumnTypeName(i));
            ++i;
        }
    }

    @Test
    public void testGetColumnDisplayLength_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_Statement.getColumnDisplayLength(i), (long)this.jdbcRsmd_PreparedStmt.getColumnDisplaySize(i));
            ++i;
        }
    }

    @Test
    public void testGetPrecision_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_Statement.getPrecision(i), (long)this.jdbcRsmd_PreparedStmt.getPrecision(i));
            ++i;
        }
    }

    @Test
    public void testGetScale_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_Statement.getScale(i), (long)this.jdbcRsmd_PreparedStmt.getScale(i));
            ++i;
        }
    }

    @Test
    public void testIsNullable_Statment() throws Exception {
        int i = 1;
        while (i < this.rsmd_Statement.getColumnCount() + 1) {
            Assert.assertEquals((long)this.rsmd_Statement.isNullable(i), (long)this.jdbcRsmd_PreparedStmt.isNullable(i));
            ++i;
        }
    }
}

