/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.views.repository;

import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.version.VersionRange;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.views.repository.SearchPanel;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.osgi.resource.Requirement;

public class PackageSearchPanel
extends SearchPanel {
    private String packageName;
    private String versionRangeStr;
    private Control focusControl;

    @Override
    public Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.verticalSpacing = 10;
        container.setLayout((Layout)layout);
        Label lblInstruction = new Label(container, 16448);
        lblInstruction.setText("Enter a package name, which may contain wildcard characters (\"*\").");
        lblInstruction.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        new Label(container, 0).setText("Package Name:");
        Text txtPackageName = new Text(container, 2048);
        if (this.packageName != null) {
            txtPackageName.setText(this.packageName);
        }
        txtPackageName.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        txtPackageName.addModifyListener(e -> {
            this.packageName = txtPackageName.getText().trim();
            this.validate();
        });
        new Label(container, 0).setText("Version Range:");
        Text txtVersion = new Text(container, 2048);
        if (this.versionRangeStr != null) {
            txtVersion.setText(this.versionRangeStr);
        }
        txtVersion.setLayoutData((Object)new GridData(4, 4, true, false));
        txtVersion.addModifyListener(e -> {
            this.versionRangeStr = txtVersion.getText();
            this.validate();
        });
        Label lblVersionHint = new Label(container, 0);
        lblVersionHint.setText("Example: [1.0, 2.0)");
        this.validate();
        this.focusControl = txtPackageName;
        return container;
    }

    private void validate() {
        try {
            if (this.packageName == null || this.packageName.trim().isEmpty()) {
                this.setError(null);
                this.setRequirement(null);
                return;
            }
            if (this.versionRangeStr != null && this.versionRangeStr.trim().length() > 0) {
                try {
                    new VersionRange(this.versionRangeStr);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Invalid version range: " + e.getMessage());
                }
            }
            this.setRequirement((Requirement)CapReqBuilder.createPackageRequirement((String)this.packageName.trim(), (String)this.versionRangeStr).buildSyntheticRequirement());
            this.setError(null);
        }
        catch (Exception e) {
            this.setError(e.getMessage());
            this.setRequirement(null);
        }
    }

    @Override
    public void setFocus() {
        this.focusControl.setFocus();
    }

    @Override
    public Image createImage(Device device) {
        return Resources.getImage("package");
    }

    public void saveState(IMemento memento) {
        memento.putString("packageName", this.packageName);
        memento.putString("versionRange", this.versionRangeStr);
    }

    @Override
    public void restoreState(IMemento memento) {
        this.packageName = memento.getString("packageName");
        this.versionRangeStr = memento.getString("versionRange");
    }
}

