/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.preview.extension;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.report.designer.ui.preview.extension.IViewer;

public class ViewerExtensionManager {
    public static final String VIEWER_EXTENSION_MANAGER_ID = "org.eclipse.birt.report.designer.ui.preview.ViewerExtensionManager";
    private static final String EXTENSION_VIEWER_CONTRIBUTOR = "org.eclipse.birt.report.designer.ui.preview.viewers";

    private static List getExtensionElements(String extensionPointID) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry == null) {
            return Collections.EMPTY_LIST;
        }
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
        if (extensionPoint == null) {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(extensionPoint.getExtensions());
    }

    public IViewer createViewer() throws FrameworkException {
        return this.createViewer(null);
    }

    public IViewer createViewer(String viewerID) throws FrameworkException {
        for (IExtension extension : ViewerExtensionManager.getExtensionElements(EXTENSION_VIEWER_CONTRIBUTOR)) {
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements == null) continue;
            IConfigurationElement element = null;
            int i = 0;
            while (i < elements.length) {
                if (viewerID == null || viewerID.equalsIgnoreCase(elements[i].getAttribute("id"))) {
                    element = elements[i];
                    break;
                }
                ++i;
            }
            if (element == null && elements.length > 0) {
                element = elements[0];
            }
            return element == null ? null : (IViewer)element.createExecutableExtension("class");
        }
        return null;
    }
}

