/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import junit.framework.TestCase;
import org.eclipse.birt.report.engine.emitter.HTMLWriter;

public class HTMLWriterTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testGetEscapeStr() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HTMLWriter writer = new HTMLWriter();
        writer.open((OutputStream)stream);
        writer.text("&<>\"1 2  3   4    ");
        writer.endWriter();
        writer.close();
        HTMLWriterTest.assertEquals((String)"&amp;&lt;>\"1 2&#xa0; 3&#xa0;&#xa0; 4&#xa0;&#xa0;&#xa0;&#xa0;", (String)stream.toString().replaceAll("[\\r|\\t|\\n]*", ""));
        stream.close();
    }

    public void testWhiteSpace() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HTMLWriter writer = new HTMLWriter();
        writer.open((OutputStream)stream);
        writer.text(" a  b \n  abc  \r\n   abc cde");
        writer.endWriter();
        writer.close();
        HTMLWriterTest.assertEquals((String)"&#xa0;a&#xa0; b&#xa0;<br/>&#xa0; abc&#xa0;&#xa0;<br/>&#xa0;&#xa0; abc cde", (String)stream.toString().replaceAll("[\\r|\\t|\\n]*", ""));
        stream.close();
    }

    public void testStyleEscape() throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        HTMLWriter writer = new HTMLWriter();
        writer.open((OutputStream)stream);
        writer.attribute("style", " font-family: Arial,\"Courier New\",\"Franklin Gothic Book\",'ABC{!}\"DEF'");
        writer.endWriter();
        writer.close();
        HTMLWriterTest.assertEquals((String)" style=\" font-family: Arial,&#34;Courier New&#34;,&#34;Franklin Gothic Book&#34;,'ABC{!}&#34;DEF'\"", (String)stream.toString().replaceAll("[\\r|\\t|\\n]*", ""));
        stream.close();
    }
}

